/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.plushie.network;

import de.sarocesch.plushie.block.PlushieBlockEntity;
import de.sarocesch.plushie.block.PlushiePose;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PlushiePosePacket {
    private final BlockPos pos;
    private final float headX;
    private final float headY;
    private final float headZ;
    private final float bodyX;
    private final float bodyY;
    private final float bodyZ;
    private final float leftArmX;
    private final float leftArmY;
    private final float leftArmZ;
    private final float rightArmX;
    private final float rightArmY;
    private final float rightArmZ;
    private final float leftLegX;
    private final float leftLegY;
    private final float leftLegZ;
    private final float rightLegX;
    private final float rightLegY;
    private final float rightLegZ;

    public PlushiePosePacket(BlockPos pos, PlushiePose pose) {
        this.pos = pos;
        this.headX = pose.getHeadRotation().x;
        this.headY = pose.getHeadRotation().y;
        this.headZ = pose.getHeadRotation().z;
        this.bodyX = pose.getBodyRotation().x;
        this.bodyY = pose.getBodyRotation().y;
        this.bodyZ = pose.getBodyRotation().z;
        this.leftArmX = pose.getLeftArmRotation().x;
        this.leftArmY = pose.getLeftArmRotation().y;
        this.leftArmZ = pose.getLeftArmRotation().z;
        this.rightArmX = pose.getRightArmRotation().x;
        this.rightArmY = pose.getRightArmRotation().y;
        this.rightArmZ = pose.getRightArmRotation().z;
        this.leftLegX = pose.getLeftLegRotation().x;
        this.leftLegY = pose.getLeftLegRotation().y;
        this.leftLegZ = pose.getLeftLegRotation().z;
        this.rightLegX = pose.getRightLegRotation().x;
        this.rightLegY = pose.getRightLegRotation().y;
        this.rightLegZ = pose.getRightLegRotation().z;
    }

    private PlushiePosePacket(BlockPos pos, float headX, float headY, float headZ, float bodyX, float bodyY, float bodyZ, float leftArmX, float leftArmY, float leftArmZ, float rightArmX, float rightArmY, float rightArmZ, float leftLegX, float leftLegY, float leftLegZ, float rightLegX, float rightLegY, float rightLegZ) {
        this.pos = pos;
        this.headX = headX;
        this.headY = headY;
        this.headZ = headZ;
        this.bodyX = bodyX;
        this.bodyY = bodyY;
        this.bodyZ = bodyZ;
        this.leftArmX = leftArmX;
        this.leftArmY = leftArmY;
        this.leftArmZ = leftArmZ;
        this.rightArmX = rightArmX;
        this.rightArmY = rightArmY;
        this.rightArmZ = rightArmZ;
        this.leftLegX = leftLegX;
        this.leftLegY = leftLegY;
        this.leftLegZ = leftLegZ;
        this.rightLegX = rightLegX;
        this.rightLegY = rightLegY;
        this.rightLegZ = rightLegZ;
    }

    public static void encode(PlushiePosePacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.writeFloat(msg.headX);
        buf.writeFloat(msg.headY);
        buf.writeFloat(msg.headZ);
        buf.writeFloat(msg.bodyX);
        buf.writeFloat(msg.bodyY);
        buf.writeFloat(msg.bodyZ);
        buf.writeFloat(msg.leftArmX);
        buf.writeFloat(msg.leftArmY);
        buf.writeFloat(msg.leftArmZ);
        buf.writeFloat(msg.rightArmX);
        buf.writeFloat(msg.rightArmY);
        buf.writeFloat(msg.rightArmZ);
        buf.writeFloat(msg.leftLegX);
        buf.writeFloat(msg.leftLegY);
        buf.writeFloat(msg.leftLegZ);
        buf.writeFloat(msg.rightLegX);
        buf.writeFloat(msg.rightLegY);
        buf.writeFloat(msg.rightLegZ);
    }

    public static PlushiePosePacket decode(FriendlyByteBuf buf) {
        return new PlushiePosePacket(buf.m_130135_(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat());
    }

    public static void handle(PlushiePosePacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_284548_();
            if (!msg.pos.m_203195_((Position)player.m_20182_(), 8.0)) {
                return;
            }
            BlockEntity entity = level.m_7702_(msg.pos);
            if (entity instanceof PlushieBlockEntity) {
                PlushieBlockEntity plushieEntity = (PlushieBlockEntity)entity;
                PlushiePose pose = new PlushiePose();
                pose.setHeadRotation(msg.headX, msg.headY, msg.headZ);
                pose.setBodyRotation(msg.bodyX, msg.bodyY, msg.bodyZ);
                pose.setLeftArmRotation(msg.leftArmX, msg.leftArmY, msg.leftArmZ);
                pose.setRightArmRotation(msg.rightArmX, msg.rightArmY, msg.rightArmZ);
                pose.setLeftLegRotation(msg.leftLegX, msg.leftLegY, msg.leftLegZ);
                pose.setRightLegRotation(msg.rightLegX, msg.rightLegY, msg.rightLegZ);
                plushieEntity.setPose(pose);
            }
        });
        ctx.setPacketHandled(true);
    }
}

