/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.plushie.network;

import de.sarocesch.plushie.block.PlushieBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PlushiePositionPacket {
    private final BlockPos pos;
    private final float offsetX;
    private final float offsetY;
    private final float offsetZ;
    private final float baseRotation;

    public PlushiePositionPacket(BlockPos pos, float offsetX, float offsetY, float offsetZ, float baseRotation) {
        this.pos = pos;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.baseRotation = baseRotation;
    }

    public static void encode(PlushiePositionPacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
        buf.writeFloat(packet.offsetX);
        buf.writeFloat(packet.offsetY);
        buf.writeFloat(packet.offsetZ);
        buf.writeFloat(packet.baseRotation);
    }

    public static PlushiePositionPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        float offsetX = buf.readFloat();
        float offsetY = buf.readFloat();
        float offsetZ = buf.readFloat();
        float baseRotation = buf.readFloat();
        return new PlushiePositionPacket(pos, offsetX, offsetY, offsetZ, baseRotation);
    }

    public static void handle(PlushiePositionPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_284548_();
            if (!level.m_46749_(packet.pos)) {
                return;
            }
            BlockEntity blockEntity = level.m_7702_(packet.pos);
            if (blockEntity instanceof PlushieBlockEntity) {
                PlushieBlockEntity plushieEntity = (PlushieBlockEntity)blockEntity;
                plushieEntity.setPosition(packet.offsetX, packet.offsetY, packet.offsetZ, packet.baseRotation);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

