/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.plushie.network;

import de.sarocesch.plushie.block.PlushieBlockEntity;
import de.sarocesch.plushie.util.SkinFetcher;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PlushieUpdatePacket {
    private final BlockPos pos;
    private final String playerName;
    private final boolean showNameTag;
    private final boolean showHeart;
    private final boolean isHighRes;
    private final boolean showSkinLayers;
    private final String heartText;

    public PlushieUpdatePacket(BlockPos pos, String playerName, boolean showNameTag, boolean showHeart, boolean isHighRes, boolean showSkinLayers, String heartText) {
        this.pos = pos;
        this.playerName = playerName;
        this.showNameTag = showNameTag;
        this.showHeart = showHeart;
        this.isHighRes = isHighRes;
        this.showSkinLayers = showSkinLayers;
        this.heartText = heartText != null ? heartText : "";
    }

    public static void encode(PlushieUpdatePacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.m_130072_(msg.playerName, 64);
        buf.writeBoolean(msg.showNameTag);
        buf.writeBoolean(msg.showHeart);
        buf.writeBoolean(msg.isHighRes);
        buf.writeBoolean(msg.showSkinLayers);
        buf.m_130072_(msg.heartText, 20);
    }

    public static PlushieUpdatePacket decode(FriendlyByteBuf buf) {
        return new PlushieUpdatePacket(buf.m_130135_(), buf.m_130136_(64), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.m_130136_(20));
    }

    public static void handle(PlushieUpdatePacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_284548_();
            if (!msg.pos.m_203195_((Position)player.m_20182_(), 8.0)) {
                return;
            }
            BlockEntity entity = level.m_7702_(msg.pos);
            if (entity instanceof PlushieBlockEntity) {
                PlushieBlockEntity plushieEntity = (PlushieBlockEntity)entity;
                plushieEntity.updateAll(msg.playerName, msg.showNameTag, msg.showHeart, msg.isHighRes);
                plushieEntity.setShowSkinLayers(msg.showSkinLayers);
                plushieEntity.setHeartText(msg.heartText);
                if (!msg.playerName.isEmpty()) {
                    SkinFetcher.fetchSkinData(msg.playerName, (skinUrl, isSlim) -> level.m_7654_().execute(() -> {
                        plushieEntity.setSkinUrl((String)skinUrl);
                        plushieEntity.setSlimArms((boolean)isSlim);
                    }));
                } else {
                    plushieEntity.setSkinUrl("");
                    plushieEntity.setSlimArms(false);
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

