/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding;

import com.simplebuilding.blocks.ModBlocks;
import com.simplebuilding.blocks.entity.ModBlockEntities;
import com.simplebuilding.component.ModDataComponentTypes;
import com.simplebuilding.config.SimplebuildingConfig;
import com.simplebuilding.datagen.ModLootTableProvider;
import com.simplebuilding.datagen.ModTradeOffers;
import com.simplebuilding.enchantment.ModEnchantmentEffects;
import com.simplebuilding.items.ModItemGroups;
import com.simplebuilding.items.ModItems;
import com.simplebuilding.items.custom.BuildingWandItem;
import com.simplebuilding.items.custom.OctantItem;
import com.simplebuilding.items.custom.ReinforcedBundleItem;
import com.simplebuilding.networking.BuildingWandConfigurePayload;
import com.simplebuilding.networking.OctantConfigurePayload;
import com.simplebuilding.networking.OctantScrollPayload;
import com.simplebuilding.networking.ReinforcedBundleSelectionPayload;
import com.simplebuilding.networking.TrimBenefitPayload;
import com.simplebuilding.util.DynamicLightHandler;
import com.simplebuilding.util.ModRegistries;
import com.simplebuilding.util.SledgehammerEntityInteraction;
import com.simplebuilding.util.SledgehammerUsageEvent;
import com.simplebuilding.util.StripMinerUsageEvent;
import com.simplebuilding.util.TrimBenefitUser;
import com.simplebuilding.util.VeinMinerUsageEvent;
import com.simplebuilding.util.VersatilityUsageEvent;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_5556;
import net.minecraft.class_5620;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Simplebuilding
implements ModInitializer {
    public static final String MOD_ID = "simplebuilding";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"simplebuilding");
    private static SimplebuildingConfig CONFIG;

    public void onInitialize() {
        LOGGER.info("Starting Simplebuilding initialization...");
        AutoConfig.register(SimplebuildingConfig.class, GsonConfigSerializer::new);
        CONFIG = (SimplebuildingConfig)AutoConfig.getConfigHolder(SimplebuildingConfig.class).getConfig();
        ModBlocks.registerModBlocks();
        ModItems.registerModItems();
        ModBlockEntities.registerBlockEntities();
        ModItemGroups.registerItemGroups();
        ModLootTableProvider.modifyLootTables();
        ModTradeOffers.registerModTradeOffers();
        ModDataComponentTypes.registerDataComponentTypes();
        ModEnchantmentEffects.registerEnchantmentEffects();
        ModRegistries.registerModStuffs();
        this.registerCauldronBehavior();
        PlayerBlockBreakEvents.BEFORE.register((Object)new SledgehammerUsageEvent());
        SledgehammerEntityInteraction.register();
        PlayerBlockBreakEvents.BEFORE.register((Object)new StripMinerUsageEvent());
        PlayerBlockBreakEvents.BEFORE.register((Object)new VeinMinerUsageEvent());
        AttackBlockCallback.EVENT.register((Object)new VersatilityUsageEvent());
        PayloadTypeRegistry.playC2S().register(ReinforcedBundleSelectionPayload.ID, ReinforcedBundleSelectionPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ReinforcedBundleSelectionPayload.ID, (payload, context) -> context.server().execute(() -> {
            class_1735 slot;
            int slotId;
            class_3222 player = context.player();
            if (player.field_7512 != null && (slotId = payload.slotId()) >= 0 && slotId < player.field_7512.field_7761.size() && (slot = player.field_7512.method_7611(slotId)) != null && slot.method_7681() && slot.method_7677().method_7909() instanceof ReinforcedBundleItem) {
                ReinforcedBundleItem.setBundleSelectedItem(slot.method_7677(), payload.selectedIndex());
            }
        }));
        PayloadTypeRegistry.playC2S().register(OctantConfigurePayload.ID, OctantConfigurePayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(OctantConfigurePayload.ID, (payload, context) -> context.server().execute(() -> {
            class_3222 player = context.player();
            class_1799 stack = player.method_6047();
            if (stack.method_7909() instanceof OctantItem) {
                class_9279 nbtComponent = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
                class_2487 nbt = nbtComponent.method_57461();
                payload.pos1().ifPresent(p -> nbt.method_10539("Pos1", new int[]{p.method_10263(), p.method_10264(), p.method_10260()}));
                payload.pos2().ifPresent(p -> nbt.method_10539("Pos2", new int[]{p.method_10263(), p.method_10264(), p.method_10260()}));
                if (payload.shapeName() != null && !payload.shapeName().isEmpty()) {
                    nbt.method_10582("Shape", payload.shapeName());
                }
                nbt.method_10556("Locked", payload.locked());
                stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
            }
        }));
        PayloadTypeRegistry.playC2S().register(OctantScrollPayload.ID, OctantScrollPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(OctantScrollPayload.ID, (payload, context) -> context.server().execute(() -> {
            class_3222 player = context.player();
            class_1799 stack = player.method_6047();
            if (stack.method_7909() instanceof OctantItem) {
                class_9279 nbtComponent = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
                class_2487 nbt = nbtComponent.method_57461();
                boolean changed = false;
                if (payload.alt()) {
                    String currentShapeName = nbt.method_10558("Shape").orElse("");
                    OctantItem.SelectionShape currentShape = OctantItem.SelectionShape.CUBOID;
                    if (!currentShapeName.isEmpty()) {
                        try {
                            currentShape = OctantItem.SelectionShape.valueOf(currentShapeName);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    OctantItem.SelectionShape[] values = OctantItem.SelectionShape.values();
                    int currentIndex = currentShape.ordinal();
                    int nextIndex = (currentIndex + payload.amount()) % values.length;
                    if (nextIndex < 0) {
                        nextIndex += values.length;
                    }
                    OctantItem.SelectionShape nextShape = values[nextIndex];
                    nbt.method_10582("Shape", nextShape.name());
                    changed = true;
                } else {
                    int[] p2;
                    int[] p1;
                    class_2350 direction = player.method_5735();
                    if (player.method_36455() < -60.0f) {
                        direction = class_2350.field_11036;
                    } else if (player.method_36455() > 60.0f) {
                        direction = class_2350.field_11033;
                    }
                    int dx = direction.method_10148() * payload.amount();
                    int dy = direction.method_10164() * payload.amount();
                    int dz = direction.method_10165() * payload.amount();
                    boolean hasPos1 = nbt.method_10545("Pos1");
                    boolean hasPos2 = nbt.method_10545("Pos2");
                    if (payload.control() && hasPos1 && (p1 = nbt.method_10561("Pos1").orElse(new int[0])).length == 3) {
                        p1[0] = p1[0] + dx;
                        p1[1] = p1[1] + dy;
                        p1[2] = p1[2] + dz;
                        nbt.method_10539("Pos1", p1);
                        changed = true;
                    }
                    if (payload.shift() && hasPos2 && (p2 = nbt.method_10561("Pos2").orElse(new int[0])).length == 3) {
                        p2[0] = p2[0] + dx;
                        p2[1] = p2[1] + dy;
                        p2[2] = p2[2] + dz;
                        nbt.method_10539("Pos2", p2);
                        changed = true;
                    }
                }
                if (changed) {
                    stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
                }
            }
        }));
        PayloadTypeRegistry.playC2S().register(BuildingWandConfigurePayload.ID, BuildingWandConfigurePayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(BuildingWandConfigurePayload.ID, (payload, context) -> context.server().execute(() -> {
            class_1799 stack = context.player().method_6047();
            if (stack.method_7909() instanceof BuildingWandItem) {
                class_9279 nbtComponent = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
                class_2487 nbt = nbtComponent.method_57461();
                nbt.method_10569("SettingsRadius", payload.selectedRadius());
                nbt.method_10569("SettingsAxis", payload.axisMode());
                stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
            }
        }));
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3222 player : server.method_3760().method_14571()) {
                if (server.method_3780() % 2 != 0) continue;
                DynamicLightHandler.tick((class_1657)player);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> DynamicLightHandler.onDisconnect(handler.field_14140));
        PayloadTypeRegistry.playC2S().register(TrimBenefitPayload.ID, TrimBenefitPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(TrimBenefitPayload.ID, (payload, context) -> context.server().execute(() -> {
            class_3222 patt0$temp = context.player();
            if (patt0$temp instanceof TrimBenefitUser) {
                TrimBenefitUser user = (TrimBenefitUser)patt0$temp;
                user.simplebuilding$setTrimBenefitsEnabled(payload.enabled());
            }
        }));
    }

    private void registerCauldronBehavior() {
        class_5620 cleanRangefinder = (state, world, pos, player, hand, stack) -> {
            class_1792 item = stack.method_7909();
            if (!(item instanceof OctantItem) || item == ModItems.OCTANT) {
                return class_1269.field_5811;
            }
            if (!world.method_8608()) {
                class_1799 newStack = new class_1799((class_1935)ModItems.OCTANT);
                if (stack.method_57826(class_9334.field_49628)) {
                    newStack.method_57379(class_9334.field_49628, (Object)((class_9279)stack.method_58694(class_9334.field_49628)));
                }
                player.method_6122(hand, newStack);
                player.method_7281(class_3468.field_15382);
                class_5556.method_31650((class_2680)state, (class_1937)world, (class_2338)pos);
            }
            return class_1269.field_5812;
        };
        for (class_1767 color : class_1767.values()) {
            class_1792 coloredItem = ModItems.COLORED_OCTANT_ITEMS.get(color);
            if (coloredItem == null) continue;
            class_5620.field_27776.comp_1982().put(coloredItem, cleanRangefinder);
        }
    }

    public static SimplebuildingConfig getConfig() {
        return CONFIG;
    }
}

