/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding.blocks.entity.custom;

import com.simplebuilding.blocks.ModBlocks;
import com.simplebuilding.blocks.entity.ModBlockEntities;
import java.util.function.BooleanSupplier;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1722;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2377;
import net.minecraft.class_2561;
import net.minecraft.class_2614;
import net.minecraft.class_2615;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public class ModHopperBlockEntity
extends class_2621
implements class_2615 {
    private class_2371<class_1799> inventory = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
    private int transferCooldown = -1;
    private long lastTickTime;
    private static final int[][] AVAILABLE_SLOTS_CACHE = new int[54][];

    public ModHopperBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.MOD_HOPPER_BE, pos, state);
    }

    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (!this.method_54871(view)) {
            class_1262.method_5429((class_11368)view, this.inventory);
        }
        this.transferCooldown = view.method_71424("TransferCooldown", -1);
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        if (!this.method_54872(view)) {
            class_1262.method_5426((class_11372)view, this.inventory);
        }
        view.method_71465("TransferCooldown", this.transferCooldown);
    }

    public int method_5439() {
        return 5;
    }

    public double method_11266() {
        return (double)this.field_11867.method_10263() + 0.5;
    }

    public double method_11264() {
        return (double)this.field_11867.method_10264() + 0.5;
    }

    public double method_11265() {
        return (double)this.field_11867.method_10260() + 0.5;
    }

    public boolean method_57081() {
        return false;
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.hopper");
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> inventory) {
        this.inventory = inventory;
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new class_1722(syncId, playerInventory, (class_1263)this);
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, ModHopperBlockEntity blockEntity) {
        --blockEntity.transferCooldown;
        blockEntity.lastTickTime = world.method_75260();
        if (!blockEntity.needsCooldown()) {
            blockEntity.setTransferCooldown(0);
            ModHopperBlockEntity.insertAndExtract(world, pos, state, blockEntity, () -> class_2614.method_11241((class_1937)world, (class_2615)blockEntity));
        }
    }

    private static boolean insertAndExtract(class_1937 world, class_2338 pos, class_2680 state, ModHopperBlockEntity blockEntity, BooleanSupplier booleanSupplier) {
        if (world.method_8608()) {
            return false;
        }
        if (!blockEntity.needsCooldown() && ((Boolean)state.method_11654((class_2769)class_2377.field_11126)).booleanValue()) {
            boolean bl = false;
            if (!blockEntity.method_5442()) {
                bl = ModHopperBlockEntity.insert(world, pos, blockEntity);
            }
            if (!blockEntity.isFull()) {
                bl |= booleanSupplier.getAsBoolean();
            }
            if (bl) {
                int speed = 8;
                class_2248 block = state.method_26204();
                if (block == ModBlocks.NETHERITE_HOPPER) {
                    speed = 2;
                } else if (block == ModBlocks.REINFORCED_HOPPER) {
                    speed = 4;
                }
                blockEntity.setTransferCooldown(speed);
                ModHopperBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                return true;
            }
        }
        return false;
    }

    private static boolean insert(class_1937 world, class_2338 pos, ModHopperBlockEntity blockEntity) {
        class_1263 inventory = ModHopperBlockEntity.getOutputInventory(world, pos, blockEntity);
        if (inventory == null) {
            return false;
        }
        class_2350 direction = ModHopperBlockEntity.stateToFacing(blockEntity.method_11010()).method_10153();
        if (ModHopperBlockEntity.isInventoryFull(inventory, direction)) {
            return false;
        }
        for (int i = 0; i < blockEntity.method_5439(); ++i) {
            class_1799 itemStack = blockEntity.method_5438(i);
            if (itemStack.method_7960()) continue;
            int count = itemStack.method_7947();
            class_1799 itemStack2 = class_2614.method_11260((class_1263)blockEntity, (class_1263)inventory, (class_1799)blockEntity.method_5434(i, 1), (class_2350)direction);
            if (itemStack2.method_7960()) {
                inventory.method_5431();
                return true;
            }
            itemStack.method_7939(count);
            if (count != 1) continue;
            blockEntity.method_5447(i, itemStack);
        }
        return false;
    }

    @Nullable
    private static class_1263 getOutputInventory(class_1937 world, class_2338 pos, ModHopperBlockEntity blockEntity) {
        return class_2614.method_11250((class_1937)world, (class_2338)pos.method_10093(ModHopperBlockEntity.stateToFacing(blockEntity.method_11010())));
    }

    private static class_2350 stateToFacing(class_2680 state) {
        return (class_2350)state.method_11654((class_2769)class_2377.field_11129);
    }

    private boolean isFull() {
        for (class_1799 itemStack : this.inventory) {
            if (!itemStack.method_7960() && itemStack.method_7947() == itemStack.method_7914()) continue;
            return false;
        }
        return true;
    }

    private static boolean isInventoryFull(class_1263 inventory, class_2350 direction) {
        int[] slots;
        for (int i : slots = ModHopperBlockEntity.getAvailableSlots(inventory, direction)) {
            class_1799 itemStack = inventory.method_5438(i);
            if (itemStack.method_7947() >= itemStack.method_7914()) continue;
            return false;
        }
        return true;
    }

    private static int[] getAvailableSlots(class_1263 inventory, class_2350 side) {
        if (inventory instanceof class_1278) {
            class_1278 sided = (class_1278)inventory;
            return sided.method_5494(side);
        }
        int i = inventory.method_5439();
        if (i < AVAILABLE_SLOTS_CACHE.length) {
            int[] cache = AVAILABLE_SLOTS_CACHE[i];
            if (cache != null) {
                return cache;
            }
            int[] created = ModHopperBlockEntity.indexArray(i);
            ModHopperBlockEntity.AVAILABLE_SLOTS_CACHE[i] = created;
            return created;
        }
        return ModHopperBlockEntity.indexArray(i);
    }

    private static int[] indexArray(int size) {
        int[] is = new int[size];
        int i = 0;
        while (i < is.length) {
            is[i] = i++;
        }
        return is;
    }

    private void setTransferCooldown(int transferCooldown) {
        this.transferCooldown = transferCooldown;
    }

    private boolean needsCooldown() {
        return this.transferCooldown > 0;
    }
}

