/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding.client.gui;

import com.simplebuilding.SimplebuildingClient;
import com.simplebuilding.items.custom.BuildingWandItem;
import com.simplebuilding.networking.BuildingWandConfigurePayload;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_11908;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_8710;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class BuildingWandScreen
extends class_437 {
    private final class_1799 stack;
    private int currentRadius = 0;
    private int maxRadiusForTier = 1;
    private int axisMode = 0;
    private int columnCenterX;
    private int startY;

    public BuildingWandScreen(class_1799 stack) {
        super((class_2561)class_2561.method_43471((String)"simplebuilding.gui.wand_title"));
        this.stack = stack;
        this.determineMaxRadius();
        this.loadDataFromStack();
    }

    private void determineMaxRadius() {
        class_1792 class_17922 = this.stack.method_7909();
        if (class_17922 instanceof BuildingWandItem) {
            BuildingWandItem wand = (BuildingWandItem)class_17922;
            int diameter = wand.getWandSquareDiameter();
            this.maxRadiusForTier = (diameter - 1) / 2;
        } else {
            this.maxRadiusForTier = 1;
        }
    }

    private void loadDataFromStack() {
        class_9279 nbtData = (class_9279)this.stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 nbt = nbtData.method_57461();
        this.currentRadius = nbt.method_10545("SettingsRadius") ? nbt.method_68083("SettingsRadius", 1) : this.maxRadiusForTier;
        if (this.currentRadius > this.maxRadiusForTier) {
            this.currentRadius = this.maxRadiusForTier;
        }
        if (this.currentRadius < 0) {
            this.currentRadius = 0;
        }
        this.axisMode = nbt.method_68083("SettingsAxis", 0);
    }

    protected void method_25426() {
        this.columnCenterX = this.field_22789 / 2;
        this.startY = this.field_22790 / 2 - 40;
        this.method_37063((class_364)class_4185.method_46430((class_2561)this.getRadiusText(), b -> {
            ++this.currentRadius;
            if (this.currentRadius > this.maxRadiusForTier) {
                this.currentRadius = 0;
            }
            b.method_25355(this.getRadiusText());
            this.updateLocalAndSend();
        }).method_46434(this.columnCenterX - 100, this.startY, 200, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)this.getAxisText(), b -> {
            this.axisMode = (this.axisMode + 1) % 4;
            b.method_25355(this.getAxisText());
            this.updateLocalAndSend();
        }).method_46434(this.columnCenterX - 100, this.startY + 25, 200, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"simplebuilding.gui.close"), b -> this.method_25419()).method_46434(this.columnCenterX - 50, this.startY + 60, 100, 20).method_46431());
    }

    private class_2561 getRadiusText() {
        return class_2561.method_43471((String)"simplebuilding.gui.radius").method_27693(": " + this.currentRadius + " / " + this.maxRadiusForTier);
    }

    private class_2561 getAxisText() {
        String modeString = switch (this.axisMode) {
            case 1 -> "X";
            case 2 -> "Y";
            case 3 -> "Z";
            default -> "Face (Auto)";
        };
        class_124 color = this.axisMode == 0 ? class_124.field_1080 : class_124.field_1054;
        return class_2561.method_43471((String)"simplebuilding.gui.axis").method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)modeString).method_27692(color));
    }

    private void updateLocalAndSend() {
        try {
            class_9279 nbtData = (class_9279)this.stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
            class_2487 nbt = nbtData.method_57461();
            nbt.method_10569("SettingsRadius", this.currentRadius);
            nbt.method_10569("SettingsAxis", this.axisMode);
            this.stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
            ClientPlayNetworking.send((class_8710)new BuildingWandConfigurePayload(this.currentRadius, this.axisMode));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean method_25404(class_11908 input) {
        int keyCode = input.comp_4795();
        if (SimplebuildingClient.settingsKey.method_1417(input) || keyCode == 69 || keyCode == 256) {
            this.method_25419();
            return true;
        }
        return super.method_25404(input);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(0, 0, this.field_22789, this.field_22790, 0x15000000);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"simplebuilding.gui.wand_settings"), this.columnCenterX, this.startY - 20, 0xFFFFFF);
    }
}

