/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding.client.gui;

import com.simplebuilding.SimplebuildingClient;
import com.simplebuilding.items.custom.OctantItem;
import com.simplebuilding.networking.OctantConfigurePayload;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_11908;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_8710;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class OctantScreen
extends class_437 {
    private final class_1799 stack;
    private class_342 x1Field;
    private class_342 y1Field;
    private class_342 z1Field;
    private class_342 x2Field;
    private class_342 y2Field;
    private class_342 z2Field;
    private class_342 wField;
    private class_342 hField;
    private class_342 dField;
    private class_4185 shapeButton;
    private class_4185 lockButton;
    private class_4185 orientationButton;
    private class_4185 hollowButton;
    private class_4185 layerModeButton;
    private class_4185 fillOrderButton;
    private OctantItem.SelectionShape currentShape = OctantItem.SelectionShape.CUBOID;
    private class_2350.class_2351 currentOrientation = class_2350.class_2351.field_11052;
    private boolean isHollow = false;
    private boolean isLayerMode = false;
    private OctantItem.FillOrder currentOrder = OctantItem.FillOrder.DEFAULT;
    private class_2338 pos1 = new class_2338(0, 0, 0);
    private class_2338 pos2 = new class_2338(0, 0, 0);
    private boolean isLocked = false;
    private boolean isUpdating = false;
    private int columnCenterX;
    private int startY;
    private final int rowSpacing = 28;
    private final int fieldOffsetY = 10;

    public OctantScreen(class_1799 stack) {
        super((class_2561)class_2561.method_43471((String)"simplebuilding.gui.title"));
        this.stack = stack;
        this.loadDataFromStack();
    }

    private void loadDataFromStack() {
        int orientIdx;
        class_9279 nbtData = (class_9279)this.stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 nbt = nbtData.method_57461();
        if (nbt.method_10545("Pos1")) {
            nbt.method_10561("Pos1").ifPresent(p -> {
                if (((int[])p).length == 3) {
                    this.pos1 = new class_2338(p[0], p[1], p[2]);
                }
            });
        }
        if (nbt.method_10545("Pos2")) {
            nbt.method_10561("Pos2").ifPresent(p -> {
                if (((int[])p).length == 3) {
                    this.pos2 = new class_2338(p[0], p[1], p[2]);
                }
            });
        }
        if (nbt.method_10545("Shape")) {
            try {
                this.currentShape = OctantItem.SelectionShape.valueOf(nbt.method_68564("Shape", OctantItem.SelectionShape.CUBOID.name()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.currentOrientation = (orientIdx = nbt.method_68083("Orientation", 1)) == 0 ? class_2350.class_2351.field_11048 : (orientIdx == 2 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11052);
        this.isHollow = nbt.method_68566("Hollow", false);
        this.isLayerMode = nbt.method_68566("LayerMode", false);
        try {
            this.currentOrder = OctantItem.FillOrder.valueOf(nbt.method_68564("FillOrder", OctantItem.FillOrder.DEFAULT.name()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isLocked = nbt.method_68566("Locked", false);
    }

    protected void method_25426() {
        int menuWidth = 160;
        this.columnCenterX = this.field_22789 - menuWidth / 2 - 20;
        int totalHeight = 184;
        this.startY = Math.max(10, (this.field_22790 - totalHeight) / 2);
        this.createRow(this.columnCenterX, this.startY + 10, this.pos1.method_10263(), this.pos1.method_10264(), this.pos1.method_10260(), f -> {
            this.x1Field = f;
        }, f -> {
            this.y1Field = f;
        }, f -> {
            this.z1Field = f;
        });
        this.createRow(this.columnCenterX, this.startY + 10 + 28, this.pos2.method_10263(), this.pos2.method_10264(), this.pos2.method_10260(), f -> {
            this.x2Field = f;
        }, f -> {
            this.y2Field = f;
        }, f -> {
            this.z2Field = f;
        });
        int w = Math.abs(this.pos2.method_10263() - this.pos1.method_10263()) + 1;
        int h = Math.abs(this.pos2.method_10264() - this.pos1.method_10264()) + 1;
        int d = Math.abs(this.pos2.method_10260() - this.pos1.method_10260()) + 1;
        this.createSizeRow(this.columnCenterX, this.startY + 10 + 56, w, h, d);
        int yControls = this.startY + 10 + 84 + 5;
        this.shapeButton = class_4185.method_46430((class_2561)this.getShapeText(), b -> this.cycleShape()).method_46434(this.columnCenterX - 100, yControls, 125, 20).method_46431();
        this.method_37063((class_364)this.shapeButton);
        this.orientationButton = class_4185.method_46430((class_2561)this.getOrientationText(), b -> this.cycleOrientation()).method_46434(this.columnCenterX + 30, yControls, 50, 20).method_46431();
        this.method_37063((class_364)this.orientationButton);
        int yFill = yControls + 25;
        this.hollowButton = class_4185.method_46430((class_2561)this.getHollowText(), b -> {
            this.isHollow = !this.isHollow;
            b.method_25355(this.getHollowText());
            this.updateLocalAndSend();
        }).method_46434(this.columnCenterX - 100, yFill, 75, 20).method_46431();
        this.method_37063((class_364)this.hollowButton);
        this.layerModeButton = class_4185.method_46430((class_2561)this.getLayerText(), b -> {
            this.isLayerMode = !this.isLayerMode;
            b.method_25355(this.getLayerText());
            this.updateLocalAndSend();
        }).method_46434(this.columnCenterX - 20, yFill, 100, 20).method_46431();
        this.method_37063((class_364)this.layerModeButton);
        int yOrder = yFill + 25;
        this.fillOrderButton = class_4185.method_46430((class_2561)this.getOrderText(), b -> this.cycleOrder()).method_46434(this.columnCenterX - 100, yOrder, 180, 20).method_46431();
        this.method_37063((class_364)this.fillOrderButton);
        int yDone = yOrder + 25;
        this.lockButton = class_4185.method_46430((class_2561)this.getLockIcon(), b -> {
            this.isLocked = !this.isLocked;
            b.method_25355(this.getLockIcon());
            this.updateLocalAndSend();
        }).method_46434(this.columnCenterX - 100, yDone, 25, 20).method_46431();
        this.method_37063((class_364)this.lockButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"simplebuilding.gui.close"), b -> this.method_25419()).method_46434(this.columnCenterX - 70, yDone, 150, 20).method_46431());
    }

    private void createRow(int cX, int y, int v1, int v2, int v3, Consumer<class_342> a1, Consumer<class_342> a2, Consumer<class_342> a3) {
        int groupWidth = 50;
        int startX = cX - (int)((double)groupWidth * 1.5) - 5;
        this.createControlGroup(startX, y, v1, a1, false);
        this.createControlGroup(startX + groupWidth + 5, y, v2, a2, false);
        this.createControlGroup(startX + (groupWidth + 5) * 2, y, v3, a3, false);
    }

    private void createSizeRow(int cX, int y, int w, int h, int d) {
        int groupWidth = 50;
        int startX = cX - (int)((double)groupWidth * 1.5) - 5;
        this.createControlGroup(startX, y, w, f -> {
            this.wField = f;
        }, true);
        this.createControlGroup(startX + groupWidth + 5, y, h, f -> {
            this.hField = f;
        }, true);
        this.createControlGroup(startX + (groupWidth + 5) * 2, y, d, f -> {
            this.dField = f;
        }, true);
    }

    private void createControlGroup(int x, int y, int val, Consumer<class_342> assigner, boolean isSize) {
        class_342 field = new class_342(this.field_22793, x, y, 30, 16, (class_2561)class_2561.method_43473());
        field.method_1852(String.valueOf(val));
        field.method_1863(s -> {
            if (!this.isUpdating) {
                if (isSize) {
                    this.updatePos2FromSize();
                } else {
                    this.updateLocalAndSend();
                }
            }
        });
        assigner.accept(field);
        this.method_37063((class_364)field);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), b -> this.adjustField(field, 1, isSize)).method_46434(x + 31, y, 12, 8).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"-"), b -> this.adjustField(field, -1, isSize)).method_46434(x + 31, y + 8, 12, 8).method_46431());
    }

    private void adjustField(class_342 field, int delta, boolean isSize) {
        try {
            int val = Integer.parseInt(field.method_1882()) + delta;
            if (isSize && val < 1) {
                val = 1;
            }
            field.method_1852(String.valueOf(val));
            if (isSize) {
                this.updatePos2FromSize();
            } else {
                this.updateLocalAndSend();
            }
        }
        catch (Exception e) {
            field.method_1852("0");
        }
    }

    private class_2561 getLockIcon() {
        return this.isLocked ? class_2561.method_43471((String)"simplebuilding.gui.locked") : class_2561.method_43471((String)"simplebuilding.gui.unlocked");
    }

    private class_2561 getShapeText() {
        return this.currentShape.getText();
    }

    private class_2561 getOrientationText() {
        return class_2561.method_43469((String)"simplebuilding.gui.orientation", (Object[])new Object[]{this.currentOrientation.name()});
    }

    private class_2561 getHollowText() {
        return class_2561.method_43469((String)"simplebuilding.gui.hollow", (Object[])new Object[]{this.isHollow ? "ON" : "OFF"});
    }

    private class_2561 getLayerText() {
        return class_2561.method_43469((String)"simplebuilding.gui.layer", (Object[])new Object[]{this.isLayerMode ? "ON" : "OFF"});
    }

    private class_2561 getOrderText() {
        return class_2561.method_43469((String)"simplebuilding.gui.order", (Object[])new Object[]{this.currentOrder.getText()});
    }

    private void cycleShape() {
        this.currentShape = OctantItem.SelectionShape.values()[(this.currentShape.ordinal() + 1) % OctantItem.SelectionShape.values().length];
        this.shapeButton.method_25355(this.getShapeText());
        this.updateLocalAndSend();
    }

    private void cycleOrientation() {
        this.currentOrientation = this.currentOrientation == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11052 : (this.currentOrientation == class_2350.class_2351.field_11052 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048);
        this.orientationButton.method_25355(this.getOrientationText());
        this.updateLocalAndSend();
    }

    private void cycleOrder() {
        this.currentOrder = OctantItem.FillOrder.values()[(this.currentOrder.ordinal() + 1) % OctantItem.FillOrder.values().length];
        this.fillOrderButton.method_25355(this.getOrderText());
        this.updateLocalAndSend();
    }

    private void updatePos2FromSize() {
        if (this.isUpdating || this.x1Field == null) {
            return;
        }
        this.isUpdating = true;
        try {
            int x1 = this.parse(this.x1Field);
            int y1 = this.parse(this.y1Field);
            int z1 = this.parse(this.z1Field);
            int w = Math.max(1, this.parse(this.wField));
            int h = Math.max(1, this.parse(this.hField));
            int d = Math.max(1, this.parse(this.dField));
            this.x2Field.method_1852(String.valueOf(x1 + w - 1));
            this.y2Field.method_1852(String.valueOf(y1 + h - 1));
            this.z2Field.method_1852(String.valueOf(z1 + d - 1));
            this.isUpdating = false;
            this.updateLocalAndSend();
        }
        catch (Exception e) {
            this.isUpdating = false;
        }
    }

    private void updateLocalAndSend() {
        if (this.x1Field == null) {
            return;
        }
        try {
            class_2338 p1 = new class_2338(this.parse(this.x1Field), this.parse(this.y1Field), this.parse(this.z1Field));
            class_2338 p2 = new class_2338(this.parse(this.x2Field), this.parse(this.y2Field), this.parse(this.z2Field));
            class_9279 nbtData = (class_9279)this.stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
            class_2487 nbt = nbtData.method_57461();
            nbt.method_10539("Pos1", new int[]{p1.method_10263(), p1.method_10264(), p1.method_10260()});
            nbt.method_10539("Pos2", new int[]{p2.method_10263(), p2.method_10264(), p2.method_10260()});
            nbt.method_10582("Shape", this.currentShape.name());
            nbt.method_10569("Orientation", this.currentOrientation == class_2350.class_2351.field_11048 ? 0 : (this.currentOrientation == class_2350.class_2351.field_11052 ? 1 : 2));
            nbt.method_10556("Locked", this.isLocked);
            nbt.method_10556("Hollow", this.isHollow);
            nbt.method_10556("LayerMode", this.isLayerMode);
            nbt.method_10582("FillOrder", this.currentOrder.name());
            this.stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
            ClientPlayNetworking.send((class_8710)new OctantConfigurePayload(Optional.of(p1), Optional.of(p2), this.currentShape.name(), this.isLocked, this.currentOrientation == class_2350.class_2351.field_11048 ? 0 : (this.currentOrientation == class_2350.class_2351.field_11052 ? 1 : 2), this.isHollow, this.isLayerMode, this.currentOrder.name()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int parse(class_342 f) {
        try {
            return Integer.parseInt(f.method_1882());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public boolean method_25404(class_11908 input) {
        int keyCode = input.comp_4795();
        if (SimplebuildingClient.settingsKey.method_1417(input) || keyCode == 69 || keyCode == 256) {
            this.method_25419();
            return true;
        }
        return super.method_25404(input);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(0, 0, this.field_22789, this.field_22790, 0x15000000);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"simplebuilding.gui.title"), this.columnCenterX, this.startY - 15, 0xFFFFFF);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"simplebuilding.gui.pos1"), this.columnCenterX, this.startY, 0xAAAAAA);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"simplebuilding.gui.pos2"), this.columnCenterX, this.startY + 28, 0xAAAAAA);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"simplebuilding.gui.size"), this.columnCenterX, this.startY + 56, 0x55FFFF);
        if (this.lockButton.method_25405((double)mouseX, (double)mouseY)) {
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"simplebuilding.gui.lock_tooltip"), mouseX, mouseY);
        }
    }
}

