/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding.client.render;

import com.simplebuilding.Simplebuilding;
import com.simplebuilding.SimplebuildingClient;
import com.simplebuilding.enchantment.ModEnchantments;
import com.simplebuilding.items.custom.OctantItem;
import com.simplebuilding.util.guiDrawHelper;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import net.minecraft.class_12249;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.class_9799;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class BlockHighlightRenderer {
    public static void render(Matrix4f positionMatrix, class_4184 camera) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        class_1799 stack = client.field_1724.method_6047();
        boolean isRangefinder = stack.method_7909() instanceof OctantItem;
        if (!isRangefinder) {
            stack = client.field_1724.method_6079();
            isRangefinder = stack.method_7909() instanceof OctantItem;
        }
        if (isRangefinder) {
            BlockHighlightRenderer.renderHighlights(positionMatrix, camera, stack);
        }
    }

    private static void renderHighlights(Matrix4f positionMatrix, class_4184 camera, class_1799 stack) {
        class_2350.class_2351 orientation;
        class_9279 nbtData = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 nbt = nbtData.method_57461();
        class_2338 pos1 = guiDrawHelper.getPos(nbt, "Pos1");
        class_2338 pos2 = guiDrawHelper.getPos(nbt, "Pos2");
        String shapeName = nbt.method_68564("Shape", "");
        OctantItem.SelectionShape shape = OctantItem.SelectionShape.CUBOID;
        try {
            if (!shapeName.isEmpty()) {
                shape = OctantItem.SelectionShape.valueOf(shapeName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int orientIdx = nbt.method_68083("Orientation", 1);
        class_2350.class_2351 class_23512 = orientIdx == 0 ? class_2350.class_2351.field_11048 : (orientation = orientIdx == 2 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11052);
        if (pos1 == null && pos2 == null) {
            return;
        }
        boolean isInverted = Simplebuilding.getConfig().tools.invertOctantSneak;
        int opacityPercent = Simplebuilding.getConfig().tools.buildingHighlightOpacity;
        boolean hasConstructorsTouch = guiDrawHelper.hasEnchantment(stack, class_310.method_1551(), ModEnchantments.CONSTRUCTORS_TOUCH);
        boolean showFill = isInverted ^ hasConstructorsTouch;
        float baseAlpha = (float)Math.max(0, Math.min(100, opacityPercent)) / 100.0f;
        OctantItem octant = (OctantItem)stack.method_7909();
        guiDrawHelper.RenderColors colors = guiDrawHelper.getRenderColors(octant.getColor());
        double camX = camera.method_71156().field_1352;
        double camY = camera.method_71156().field_1351;
        double camZ = camera.method_71156().field_1350;
        class_4587 matrices = new class_4587();
        matrices.method_22903();
        matrices.method_34425((Matrix4fc)positionMatrix);
        matrices.method_22904(-camX, -camY, -camZ);
        class_9799 mainAllocator = new class_9799(0x200000);
        LinkedHashMap<class_1921, class_9799> layerBuffers = new LinkedHashMap<class_1921, class_9799>();
        layerBuffers.put(class_12249.method_76015(), new class_9799(0x200000));
        layerBuffers.put(class_12249.method_76023(), new class_9799(0x200000));
        class_4597.class_4598 consumers = class_4597.method_22992(layerBuffers, (class_9799)mainAllocator);
        class_4588 lines = consumers.method_73477(class_12249.method_76015());
        class_4588 fill = consumers.method_73477(class_12249.method_76023());
        float lineAlpha = 0.8f;
        float fillAlpha = 0.3f * baseAlpha;
        if (pos1 != null) {
            guiDrawHelper.drawBoxOutline(matrices, lines, new class_238(pos1).method_1014(0.001), colors.r1(), colors.g1(), colors.b1(), lineAlpha);
        }
        if (pos2 != null) {
            guiDrawHelper.drawBoxOutline(matrices, lines, new class_238(pos2).method_1014(0.002), colors.r2(), colors.g2(), colors.b2(), lineAlpha);
        }
        if (pos1 != null && pos2 != null && showFill && SimplebuildingClient.showHighlights) {
            Predicate<class_2338> shapeFunc;
            class_238 bounds = guiDrawHelper.getFullArea(pos1, pos2);
            switch (shape) {
                default: {
                    throw new MatchException(null, null);
                }
                case CYLINDER: 
                case ELLIPSE: {
                    Predicate<class_2338> predicate = p -> {
                        class_2338 transformed = BlockHighlightRenderer.transformToY(p, orientation);
                        class_238 tBounds = BlockHighlightRenderer.transformToY(bounds, orientation);
                        if ((double)transformed.method_10264() < tBounds.field_1322 || (double)transformed.method_10264() >= tBounds.field_1325) {
                            return false;
                        }
                        return BlockHighlightRenderer.isPointInEllipse((double)transformed.method_10263() + 0.5, (double)transformed.method_10260() + 0.5, tBounds);
                    };
                    break;
                }
                case SPHERE: {
                    Predicate<class_2338> predicate = p -> BlockHighlightRenderer.isPointInEllipsoid((double)p.method_10263() + 0.5, (double)p.method_10264() + 0.5, (double)p.method_10260() + 0.5, bounds);
                    break;
                }
                case PYRAMID: {
                    Predicate<class_2338> predicate = p -> {
                        class_2338 transformed = BlockHighlightRenderer.transformToY(p, orientation);
                        class_238 tBounds = BlockHighlightRenderer.transformToY(bounds, orientation);
                        return BlockHighlightRenderer.isPointInPyramid((double)transformed.method_10263() + 0.5, (double)transformed.method_10264() + 0.5, (double)transformed.method_10260() + 0.5, tBounds);
                    };
                    break;
                }
                case TRIANGLE: {
                    Predicate<class_2338> predicate = p -> {
                        class_2338 transformed = BlockHighlightRenderer.transformToY(p, orientation);
                        class_238 tBounds = BlockHighlightRenderer.transformToY(bounds, orientation);
                        return BlockHighlightRenderer.isPointInPrism((double)transformed.method_10263() + 0.5, (double)transformed.method_10264() + 0.5, (double)transformed.method_10260() + 0.5, tBounds);
                    };
                    break;
                }
                case RECTANGLE: 
                case CUBOID: {
                    Predicate<class_2338> predicate = shapeFunc = p -> true;
                }
            }
            if (shape == OctantItem.SelectionShape.CUBOID || shape == OctantItem.SelectionShape.RECTANGLE) {
                guiDrawHelper.drawBoxOutline(matrices, lines, bounds.method_1014(0.003), colors.r3(), colors.g3(), colors.b3(), lineAlpha);
                guiDrawHelper.drawBoxFill(matrices, fill, bounds.method_1014(0.009), colors.r3(), colors.g3(), colors.b3(), fillAlpha);
            } else {
                BlockHighlightRenderer.renderVoxelShape(matrices, lines, fill, bounds, shapeFunc, colors.r3(), colors.g3(), colors.b3(), lineAlpha, fillAlpha);
            }
        }
        consumers.method_22993();
        matrices.method_22909();
        mainAllocator.close();
        layerBuffers.values().forEach(class_9799::close);
    }

    private static class_2338 transformToY(class_2338 p, class_2350.class_2351 orientation) {
        if (orientation == class_2350.class_2351.field_11052) {
            return p;
        }
        if (orientation == class_2350.class_2351.field_11048) {
            return new class_2338(p.method_10264(), p.method_10263(), p.method_10260());
        }
        return new class_2338(p.method_10263(), p.method_10260(), p.method_10264());
    }

    private static class_238 transformToY(class_238 b, class_2350.class_2351 orientation) {
        if (orientation == class_2350.class_2351.field_11052) {
            return b;
        }
        if (orientation == class_2350.class_2351.field_11048) {
            return new class_238(b.field_1322, b.field_1323, b.field_1321, b.field_1325, b.field_1320, b.field_1324);
        }
        return new class_238(b.field_1323, b.field_1321, b.field_1322, b.field_1320, b.field_1324, b.field_1325);
    }

    private static void renderVoxelShape(class_4587 matrices, class_4588 lines, class_4588 fill, class_238 bounds, Predicate<class_2338> inShape, float r, float g, float b, float la, float fa) {
        int minX = (int)bounds.field_1323;
        int minY = (int)bounds.field_1322;
        int minZ = (int)bounds.field_1321;
        int maxX = (int)bounds.field_1320;
        int maxY = (int)bounds.field_1325;
        int maxZ = (int)bounds.field_1324;
        class_2338.class_2339 pos = new class_2338.class_2339();
        class_2338.class_2339 neighborPos = new class_2338.class_2339();
        class_2338.class_2339 diagPos = new class_2338.class_2339();
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    pos.method_10103(x, y, z);
                    if (!inShape.test((class_2338)pos)) continue;
                    for (class_2350 dir : class_2350.values()) {
                        boolean isSurfaceFace;
                        neighborPos.method_10101((class_2382)pos).method_10098(dir);
                        boolean bl = isSurfaceFace = !inShape.test((class_2338)neighborPos);
                        if (!isSurfaceFace) continue;
                        guiDrawHelper.drawQuadFace(matrices, fill, new class_238((class_2338)pos).method_1014(0.002), dir, r, g, b, fa);
                        for (class_2350 edgeDir : class_2350.values()) {
                            if (edgeDir == dir || edgeDir == dir.method_10153()) continue;
                            class_2338 sideNeighbor = new class_2338((class_2382)pos).method_10081(edgeDir.method_62675());
                            diagPos.method_10101((class_2382)neighborPos).method_10098(edgeDir);
                            boolean sideIsShape = inShape.test(sideNeighbor);
                            boolean diagIsShape = inShape.test((class_2338)diagPos);
                            if (sideIsShape && !diagIsShape) continue;
                            BlockHighlightRenderer.drawEdgeLine(matrices, lines, (class_2338)pos, dir, edgeDir, r, g, b, la);
                        }
                    }
                }
            }
        }
    }

    private static void drawEdgeLine(class_4587 matrices, class_4588 builder, class_2338 pos, class_2350 face, class_2350 edgeDir, float r, float g, float b, float a) {
        double x1 = pos.method_10263();
        double y1 = pos.method_10264();
        double z1 = pos.method_10260();
        double x2 = x1 + 1.0;
        double y2 = y1 + 1.0;
        double z2 = z1 + 1.0;
        if (face == class_2350.field_11033) {
            y2 = y1;
        }
        if (face == class_2350.field_11036) {
            y1 = y2;
        }
        if (face == class_2350.field_11043) {
            z2 = z1;
        }
        if (face == class_2350.field_11035) {
            z1 = z2;
        }
        if (face == class_2350.field_11039) {
            x2 = x1;
        }
        if (face == class_2350.field_11034) {
            x1 = x2;
        }
        if (edgeDir == class_2350.field_11033) {
            y2 = y1;
        }
        if (edgeDir == class_2350.field_11036) {
            y1 = y2;
        }
        if (edgeDir == class_2350.field_11043) {
            z2 = z1;
        }
        if (edgeDir == class_2350.field_11035) {
            z1 = z2;
        }
        if (edgeDir == class_2350.field_11039) {
            x2 = x1;
        }
        if (edgeDir == class_2350.field_11034) {
            x1 = x2;
        }
        if (face.method_10166() != class_2350.class_2351.field_11048 && edgeDir.method_10166() != class_2350.class_2351.field_11048) {
            x1 = pos.method_10263();
            x2 = pos.method_10263() + 1;
        }
        if (face.method_10166() != class_2350.class_2351.field_11052 && edgeDir.method_10166() != class_2350.class_2351.field_11052) {
            y1 = pos.method_10264();
            y2 = pos.method_10264() + 1;
        }
        if (face.method_10166() != class_2350.class_2351.field_11051 && edgeDir.method_10166() != class_2350.class_2351.field_11051) {
            z1 = pos.method_10260();
            z2 = pos.method_10260() + 1;
        }
        guiDrawHelper.drawLineWithNormal(builder, matrices.method_23760().method_23761(), x1, y1, z1, x2, y2, z2, r, g, b, a);
    }

    private static boolean isPointInEllipse(double x, double z, class_238 b) {
        double width = b.field_1320 - b.field_1323;
        double length = b.field_1324 - b.field_1321;
        double cx = b.field_1323 + width / 2.0;
        double cz = b.field_1321 + length / 2.0;
        double rx = width / 2.0;
        double rz = length / 2.0;
        if (rx <= 0.0 || rz <= 0.0) {
            return false;
        }
        return Math.pow(x - cx, 2.0) / Math.pow(rx, 2.0) + Math.pow(z - cz, 2.0) / Math.pow(rz, 2.0) <= 1.0;
    }

    private static boolean isPointInEllipsoid(double x, double y, double z, class_238 b) {
        double w = b.field_1320 - b.field_1323;
        double h = b.field_1325 - b.field_1322;
        double l = b.field_1324 - b.field_1321;
        double cx = b.field_1323 + w / 2.0;
        double cy = b.field_1322 + h / 2.0;
        double cz = b.field_1321 + l / 2.0;
        double rx = w / 2.0;
        double ry = h / 2.0;
        double rz = l / 2.0;
        if (rx <= 0.0 || ry <= 0.0 || rz <= 0.0) {
            return false;
        }
        return Math.pow(x - cx, 2.0) / Math.pow(rx, 2.0) + Math.pow(y - cy, 2.0) / Math.pow(ry, 2.0) + Math.pow(z - cz, 2.0) / Math.pow(rz, 2.0) <= 1.0;
    }

    private static boolean isPointInPyramid(double x, double y, double z, class_238 b) {
        double w = b.field_1320 - b.field_1323;
        double h = b.field_1325 - b.field_1322;
        double l = b.field_1324 - b.field_1321;
        double cx = b.field_1323 + w / 2.0;
        double cz = b.field_1321 + l / 2.0;
        double rx = w / 2.0;
        double rz = l / 2.0;
        if (y < b.field_1322 || y >= b.field_1325) {
            return false;
        }
        double progress = (y - b.field_1322) / h;
        double crx = rx * (1.0 - progress);
        double crz = rz * (1.0 - progress);
        return Math.abs(x - cx) <= crx && Math.abs(z - cz) <= crz;
    }

    private static boolean isPointInPrism(double x, double y, double z, class_238 b) {
        double wX = b.field_1320 - b.field_1323;
        double h = b.field_1325 - b.field_1322;
        double wZ = b.field_1324 - b.field_1321;
        if (y < b.field_1322 || y >= b.field_1325) {
            return false;
        }
        boolean alongZ = wZ > wX;
        double progress = (y - b.field_1322) / h;
        if (alongZ) {
            double cx = b.field_1323 + wX / 2.0;
            return Math.abs(x - cx) <= wX / 2.0 * (1.0 - progress);
        }
        double cz = b.field_1321 + wZ / 2.0;
        return Math.abs(z - cz) <= wZ / 2.0 * (1.0 - progress);
    }
}

