/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding.items.custom;

import com.simplebuilding.enchantment.ModEnchantments;
import com.simplebuilding.items.custom.ReinforcedBundleItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9276;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class BuildingWandItem
extends class_1792 {
    public static final int BUILDING_WAND_SQUARE_COPPER = 3;
    public static final int BUILDING_WAND_SQUARE_IRON = 5;
    public static final int BUILDING_WAND_SQUARE_GOLD = 7;
    public static final int BUILDING_WAND_SQUARE_DIAMOND = 7;
    public static final int BUILDING_WAND_SQUARE_NETHERITE = 9;
    public static final int DELAY_TICKS = 4;
    public static final int DELAY_TICKS_LINE = 2;
    private int maxDiameter = 3;

    public BuildingWandItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public void setWandSquareDiameter(int diameter) {
        this.maxDiameter = diameter;
    }

    public int getWandSquareDiameter() {
        return this.maxDiameter;
    }

    public static Map<class_2338, class_2680> getPreviewStates(class_1937 world, class_1657 player, class_1799 wandStack, class_2338 originPos, class_2350 face, int maxDiameter) {
        HashMap<class_2338, class_2680> previewMap;
        block7: {
            boolean hasMasterBuilder;
            ArrayList<class_2338> positions;
            block6: {
                int userRadius;
                previewMap = new HashMap<class_2338, class_2680>();
                class_9279 comp = (class_9279)wandStack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
                class_2487 nbt = comp.method_57461();
                int maxTierRadius = (maxDiameter - 1) / 2;
                int n = userRadius = nbt.method_10545("SettingsRadius") ? nbt.method_68083("SettingsRadius", maxTierRadius) : maxTierRadius;
                if (userRadius > maxTierRadius) {
                    userRadius = maxTierRadius;
                }
                int axisMode = nbt.method_68083("SettingsAxis", 0);
                positions = new ArrayList<class_2338>();
                for (int r = 0; r <= userRadius; ++r) {
                    positions.addAll(BuildingWandItem.calculatePositions(originPos, face, r, axisMode));
                }
                if (positions.isEmpty()) {
                    return previewMap;
                }
                hasMasterBuilder = BuildingWandItem.hasEnchantment(wandStack, world, ModEnchantments.MASTER_BUILDER);
                boolean hasColorPalette = BuildingWandItem.hasEnchantment(wandStack, world, ModEnchantments.COLOR_PALETTE);
                if (!hasColorPalette) break block6;
                List<class_2680> palette = BuildingWandItem.findAllBuildingBlocks(player, wandStack, hasMasterBuilder);
                if (palette.isEmpty()) {
                    return previewMap;
                }
                for (class_2338 pos : positions) {
                    long seed = pos.method_10063();
                    int index = Math.abs((int)(seed % (long)palette.size()));
                    previewMap.put(pos, palette.get(index));
                }
                break block7;
            }
            class_2680 state = BuildingWandItem.findFirstBlockStateClient(player, wandStack, hasMasterBuilder);
            if (state == null) break block7;
            for (class_2338 pos : positions) {
                previewMap.put(pos, state);
            }
        }
        return previewMap;
    }

    private static class_2680 findFirstBlockStateClient(class_1657 player, class_1799 wandStack, boolean hasMasterBuilder) {
        class_2680 res;
        int i;
        class_1937 world = player.method_73183();
        class_2680 off = BuildingWandItem.checkStackIsBlockState(player.method_6079(), wandStack, world, hasMasterBuilder);
        if (off != null) {
            return off;
        }
        for (i = 0; i < 9; ++i) {
            res = BuildingWandItem.checkStackIsBlockState(player.method_31548().method_5438(i), wandStack, world, hasMasterBuilder);
            if (res == null) continue;
            return res;
        }
        if (hasMasterBuilder) {
            for (i = 9; i < player.method_31548().method_67533().size(); ++i) {
                res = BuildingWandItem.checkStackIsBlockState(player.method_31548().method_5438(i), wandStack, world, hasMasterBuilder);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    private static List<class_2680> findAllBuildingBlocks(class_1657 player, class_1799 wandStack, boolean hasMasterBuilder) {
        ArrayList<class_2680> blocks = new ArrayList<class_2680>();
        class_1937 world = player.method_73183();
        BuildingWandItem.collectBlocksFromStack(player.method_6079(), wandStack, world, hasMasterBuilder, blocks);
        int limit = hasMasterBuilder ? player.method_31548().method_67533().size() : 9;
        for (int i = 0; i < limit; ++i) {
            BuildingWandItem.collectBlocksFromStack(player.method_31548().method_5438(i), wandStack, world, hasMasterBuilder, blocks);
        }
        return blocks;
    }

    private static void collectBlocksFromStack(class_1799 stack, class_1799 wand, class_1937 world, boolean masterBuilder, List<class_2680> list) {
        if (stack.method_7960()) {
            return;
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 bi = (class_1747)class_17922;
            list.add(bi.method_7711().method_9564());
        } else if (stack.method_7909() instanceof ReinforcedBundleItem) {
            class_9276 contents;
            boolean bundleHasMB = BuildingWandItem.hasEnchantment(stack, world, ModEnchantments.MASTER_BUILDER);
            if ((masterBuilder || bundleHasMB) && (contents = (class_9276)stack.method_58694(class_9334.field_49650)) != null) {
                for (class_1799 s : contents.method_57421()) {
                    class_1792 class_17923 = s.method_7909();
                    if (!(class_17923 instanceof class_1747)) continue;
                    class_1747 bi = (class_1747)class_17923;
                    list.add(bi.method_7711().method_9564());
                }
            }
        }
    }

    private static class_2680 checkStackIsBlockState(class_1799 stack, class_1799 wandStack, class_1937 world, boolean wandHasMasterBuilder) {
        if (stack.method_7960()) {
            return null;
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 bi = (class_1747)class_17922;
            return bi.method_7711().method_9564();
        }
        if (stack.method_7909() instanceof ReinforcedBundleItem) {
            class_9276 contents;
            boolean bundleHasMasterBuilder = BuildingWandItem.hasEnchantment(stack, world, ModEnchantments.MASTER_BUILDER);
            if ((wandHasMasterBuilder || bundleHasMasterBuilder) && (contents = (class_9276)stack.method_58694(class_9334.field_49650)) != null && !contents.method_57429()) {
                for (class_1799 s : contents.method_57421()) {
                    class_1792 class_17923 = s.method_7909();
                    if (!(class_17923 instanceof class_1747)) continue;
                    class_1747 bi = (class_1747)class_17923;
                    return bi.method_7711().method_9564();
                }
            }
        }
        return null;
    }

    private MaterialResult findFirstBuildingBlock(class_1657 player, class_1799 wandStack, boolean hasMasterBuilder) {
        MaterialResult res;
        int i;
        class_1937 world = player.method_73183();
        MaterialResult offHandRes = this.checkStackIsBlock(player.method_6079(), wandStack, world, hasMasterBuilder);
        if (offHandRes != null) {
            return offHandRes;
        }
        for (i = 0; i < 9; ++i) {
            res = this.checkStackIsBlock(player.method_31548().method_5438(i), wandStack, world, hasMasterBuilder);
            if (res == null) continue;
            return res;
        }
        if (hasMasterBuilder) {
            for (i = 9; i < player.method_31548().method_67533().size(); ++i) {
                res = this.checkStackIsBlock(player.method_31548().method_5438(i), wandStack, world, hasMasterBuilder);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    private MaterialResult checkStackIsBlock(class_1799 stack, class_1799 wandStack, class_1937 world, boolean wandHasMasterBuilder) {
        if (stack.method_7960()) {
            return null;
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 bi = (class_1747)class_17922;
            MaterialResult res = new MaterialResult();
            res.sourceStack = stack;
            res.fromBundle = false;
            res.stateToPlace = bi.method_7711().method_9564();
            return res;
        }
        if (stack.method_7909() instanceof ReinforcedBundleItem) {
            boolean bundleHasMasterBuilder = BuildingWandItem.hasEnchantment(stack, world, ModEnchantments.MASTER_BUILDER);
            if (wandHasMasterBuilder || bundleHasMasterBuilder) {
                return this.findFirstBlockInBundle(stack);
            }
        }
        return null;
    }

    private MaterialResult findFirstBlockInBundle(class_1799 bundle) {
        class_9276 contents = (class_9276)bundle.method_58694(class_9334.field_49650);
        if (contents == null || contents.method_57429()) {
            return null;
        }
        int i = 0;
        for (class_1799 s : contents.method_57421()) {
            class_1792 class_17922;
            if (!s.method_7960() && (class_17922 = s.method_7909()) instanceof class_1747) {
                class_1747 bi = (class_1747)class_17922;
                MaterialResult res = new MaterialResult();
                res.sourceStack = bundle;
                res.fromBundle = true;
                res.bundleIndex = i;
                res.stateToPlace = bi.method_7711().method_9564();
                return res;
            }
            ++i;
        }
        return null;
    }

    private MaterialResult findMaterialForPlacement(class_1657 player, class_1799 wand, class_2248 targetBlock, boolean wandHasMasterBuilder, boolean colorPaletteActive) {
        if (colorPaletteActive) {
            return this.findFirstBuildingBlock(player, wand, wandHasMasterBuilder);
        }
        return this.findSpecificMaterial(player, wand, targetBlock, wandHasMasterBuilder);
    }

    private MaterialResult findSpecificMaterial(class_1657 player, class_1799 wand, class_2248 targetBlock, boolean wandHasMasterBuilder) {
        MaterialResult res;
        int i;
        class_1937 world = player.method_73183();
        class_1799 offHand = player.method_6079();
        MaterialResult offRes = this.checkStackForSpecificBlock(offHand, targetBlock, wand, world, wandHasMasterBuilder);
        if (offRes != null) {
            return offRes;
        }
        for (i = 0; i < 9; ++i) {
            res = this.checkStackForSpecificBlock(player.method_31548().method_5438(i), targetBlock, wand, world, wandHasMasterBuilder);
            if (res == null) continue;
            return res;
        }
        if (wandHasMasterBuilder) {
            for (i = 9; i < player.method_31548().method_67533().size(); ++i) {
                res = this.checkStackForSpecificBlock(player.method_31548().method_5438(i), targetBlock, wand, world, wandHasMasterBuilder);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    private MaterialResult checkStackForSpecificBlock(class_1799 stack, class_2248 targetBlock, class_1799 wandStack, class_1937 world, boolean wandHasMasterBuilder) {
        class_1747 bi;
        if (stack.method_7960()) {
            return null;
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747 && (bi = (class_1747)class_17922).method_7711() == targetBlock) {
            MaterialResult res = new MaterialResult();
            res.sourceStack = stack;
            res.fromBundle = false;
            res.stateToPlace = bi.method_7711().method_9564();
            return res;
        }
        if (stack.method_7909() instanceof ReinforcedBundleItem) {
            boolean bundleHasMasterBuilder = BuildingWandItem.hasEnchantment(stack, world, ModEnchantments.MASTER_BUILDER);
            if (wandHasMasterBuilder || bundleHasMasterBuilder) {
                return this.findInBundleSpecific(stack, targetBlock);
            }
        }
        return null;
    }

    private MaterialResult findInBundleSpecific(class_1799 bundle, class_2248 targetBlock) {
        class_9276 contents = (class_9276)bundle.method_58694(class_9334.field_49650);
        if (contents == null || contents.method_57429()) {
            return null;
        }
        int i = 0;
        for (class_1799 s : contents.method_57421()) {
            class_1747 bi;
            class_1792 class_17922;
            if (!s.method_7960() && (class_17922 = s.method_7909()) instanceof class_1747 && (bi = (class_1747)class_17922).method_7711() == targetBlock) {
                MaterialResult res = new MaterialResult();
                res.sourceStack = bundle;
                res.fromBundle = true;
                res.bundleIndex = i;
                res.stateToPlace = bi.method_7711().method_9564();
                return res;
            }
            ++i;
        }
        return null;
    }

    public class_1269 method_7884(class_1838 context) {
        if (context.method_20287() != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        class_1937 world = context.method_8045();
        class_1657 player = context.method_8036();
        class_2338 clickedPos = context.method_8037();
        class_1799 wandStack = context.method_8041();
        if (player == null) {
            return class_1269.field_5811;
        }
        if (world.method_8608()) {
            return class_1269.field_5812;
        }
        boolean hasMasterBuilder = BuildingWandItem.hasEnchantment(wandStack, world, ModEnchantments.MASTER_BUILDER);
        MaterialResult preview = this.findFirstBuildingBlock(player, wandStack, hasMasterBuilder);
        if (preview == null && !player.method_31549().field_7477) {
            return class_1269.field_5814;
        }
        class_2248 buildBlock = preview != null ? preview.stateToPlace.method_26204() : class_2246.field_10124;
        class_2350 clickedFace = context.method_8038();
        class_2487 nbt = this.getOrInitNbt(wandStack);
        nbt.method_10556("Active", true);
        nbt.method_10569("CurrentRadius", 0);
        nbt.method_10569("Timer", 0);
        nbt.method_10569("OriginX", clickedPos.method_10263());
        nbt.method_10569("OriginY", clickedPos.method_10264());
        nbt.method_10569("OriginZ", clickedPos.method_10260());
        nbt.method_10569("Face", clickedFace.ordinal());
        nbt.method_10569("BuildBlockRawId", class_7923.field_41175.method_10206((Object)buildBlock));
        class_243 hitPos = context.method_17698().method_1023((double)clickedPos.method_10263(), (double)clickedPos.method_10264(), (double)clickedPos.method_10260());
        nbt.method_10548("HitX", (float)hitPos.field_1352);
        nbt.method_10548("HitY", (float)hitPos.field_1351);
        nbt.method_10548("HitZ", (float)hitPos.field_1350);
        this.setNbt(wandStack, nbt);
        return class_1269.field_21466;
    }

    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, class_1304 slot) {
        int userRadius;
        if (!(entity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)entity;
        class_2487 nbt = this.getOrInitNbt(stack);
        if (!this.getBlockBoolean(nbt)) {
            return;
        }
        if (slot != class_1304.field_6173 && slot != class_1304.field_6171) {
            nbt.method_10556("Active", false);
            this.setNbt(stack, nbt);
            return;
        }
        int timer = this.getBlockInt(nbt, "Timer");
        if (timer > 0) {
            nbt.method_10569("Timer", timer - 1);
            this.setNbt(stack, nbt);
            return;
        }
        int maxTierRadius = (this.maxDiameter - 1) / 2;
        int n = userRadius = nbt.method_10545("SettingsRadius") ? nbt.method_68083("SettingsRadius", maxTierRadius) : maxTierRadius;
        if (userRadius > maxTierRadius) {
            userRadius = maxTierRadius;
        }
        int currentRadius = this.getBlockInt(nbt, "CurrentRadius");
        boolean isLinePlace = BuildingWandItem.hasEnchantment(stack, (class_1937)world, ModEnchantments.LINEAR);
        boolean hasMasterBuilder = BuildingWandItem.hasEnchantment(stack, (class_1937)world, ModEnchantments.MASTER_BUILDER);
        boolean hasColorPalette = BuildingWandItem.hasEnchantment(stack, (class_1937)world, ModEnchantments.COLOR_PALETTE);
        int ox = this.getBlockInt(nbt, "OriginX");
        int oy = this.getBlockInt(nbt, "OriginY");
        int oz = this.getBlockInt(nbt, "OriginZ");
        class_2338 originPos = new class_2338(ox, oy, oz);
        class_2350 face = class_2350.values()[this.getBlockInt(nbt, "Face")];
        int blockId = nbt.method_68083("BuildBlockRawId", class_7923.field_41175.method_10206((Object)class_2246.field_10124));
        class_2248 targetBlock = (class_2248)class_7923.field_41175.method_10200(blockId);
        if (!hasColorPalette && targetBlock == class_2246.field_10124) {
            MaterialResult res = this.findFirstBuildingBlock((class_1657)player, stack, hasMasterBuilder);
            if (res != null) {
                targetBlock = res.stateToPlace.method_26204();
            } else {
                nbt.method_10556("Active", false);
                this.setNbt(stack, nbt);
                return;
            }
        }
        int axisMode = nbt.method_68083("SettingsAxis", 0);
        List<class_2338> stepPositions = BuildingWandItem.calculatePositions(originPos, face, currentRadius, axisMode);
        for (class_2338 rawPos : stepPositions) {
            if (!world.method_8320(rawPos).method_45474()) continue;
            MaterialResult material = this.findMaterialForPlacement((class_1657)player, stack, targetBlock, hasMasterBuilder, hasColorPalette);
            if (material == null && !player.method_31549().field_7477) {
                nbt.method_10556("Active", false);
                this.setNbt(stack, nbt);
                return;
            }
            class_2680 stateToPlace = material != null ? material.stateToPlace : (hasColorPalette ? class_2246.field_10340.method_9564() : targetBlock.method_9564());
            if (!world.method_8652(rawPos, stateToPlace, 3)) continue;
            class_2498 soundGroup = stateToPlace.method_26231();
            world.method_8396(null, rawPos, soundGroup.method_10598(), class_3419.field_15245, (soundGroup.method_10597() + 1.0f) / 2.0f, soundGroup.method_10599() * 0.8f);
            if (player.method_31549().field_7477 || material == null) continue;
            material.consume();
            stack.method_7970(1, (class_1309)player, class_1304.field_6173);
        }
        if (currentRadius < userRadius) {
            nbt.method_10569("CurrentRadius", currentRadius + 1);
            nbt.method_10569("Timer", isLinePlace ? 2 : 4);
        } else {
            nbt.method_10556("Active", false);
        }
        this.setNbt(stack, nbt);
    }

    public static List<class_2338> getBuildingPositions(class_1937 world, class_1657 player, class_1799 wandStack, class_2338 originPos, class_2350 face, int maxDiameter, class_3965 hitResult) {
        int userRadius;
        class_9279 comp = (class_9279)wandStack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 nbt = comp.method_57461();
        int maxTierRadius = (maxDiameter - 1) / 2;
        int n = userRadius = nbt.method_10545("SettingsRadius") ? nbt.method_68083("SettingsRadius", maxTierRadius) : maxTierRadius;
        if (userRadius > maxTierRadius) {
            userRadius = maxTierRadius;
        }
        int axisMode = nbt.method_68083("SettingsAxis", 0);
        ArrayList<class_2338> allPositions = new ArrayList<class_2338>();
        for (int r = 0; r <= userRadius; ++r) {
            allPositions.addAll(BuildingWandItem.calculatePositions(originPos, face, r, axisMode));
        }
        return allPositions;
    }

    private static List<class_2338> calculatePositions(class_2338 originPos, class_2350 face, int currentRadius, int axisMode) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        class_2338 placeOrigin = originPos.method_10093(face);
        class_2350.class_2351 buildAxis = axisMode == 1 ? class_2350.class_2351.field_11048 : (axisMode == 2 ? class_2350.class_2351.field_11052 : (axisMode == 3 ? class_2350.class_2351.field_11051 : face.method_10166()));
        int r = currentRadius;
        if (r == 0) {
            positions.add(placeOrigin);
            return positions;
        }
        for (int u = -r; u <= r; ++u) {
            for (int v = -r; v <= r; ++v) {
                if (Math.abs(u) != r && Math.abs(v) != r) continue;
                class_2338 offset = BuildingWandItem.getOffsetForAxis(buildAxis, u, v);
                positions.add(placeOrigin.method_10081((class_2382)offset));
            }
        }
        return positions;
    }

    private static class_2338 getOffsetForAxis(class_2350.class_2351 axis, int u, int v) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case class_2350.class_2351.field_11052 -> new class_2338(u, 0, v);
            case class_2350.class_2351.field_11051 -> new class_2338(u, v, 0);
            case class_2350.class_2351.field_11048 -> new class_2338(0, u, v);
        };
    }

    private static void removeOneFromBundle(class_1799 bundle, int indexToRemove) {
        class_9276 contents = (class_9276)bundle.method_58694(class_9334.field_49650);
        if (contents == null) {
            return;
        }
        ArrayList<class_1799> newItems = new ArrayList<class_1799>();
        int i = 0;
        for (class_1799 s : contents.method_57421()) {
            if (i == indexToRemove) {
                class_1799 copy = s.method_7972();
                copy.method_7934(1);
                if (!copy.method_7960()) {
                    newItems.add(copy);
                }
            } else {
                newItems.add(s.method_7972());
            }
            ++i;
        }
        bundle.method_57379(class_9334.field_49650, (Object)new class_9276(newItems));
    }

    private static boolean hasEnchantment(class_1799 stack, class_1937 world, class_5321<class_1887> key) {
        if (world == null) {
            return false;
        }
        class_5455 registry = world.method_30349();
        class_2378 lookup = registry.method_30530(class_7924.field_41265);
        Optional entry = lookup.method_46746(key);
        return entry.isPresent() && class_1890.method_8225((class_6880)((class_6880)entry.get()), (class_1799)stack) > 0;
    }

    private boolean getBlockBoolean(class_2487 nbt) {
        if (!nbt.method_10545("Active")) {
            return false;
        }
        return nbt.method_68566("Active", false);
    }

    private int getBlockInt(class_2487 nbt, String key) {
        if (!nbt.method_10545(key)) {
            return 0;
        }
        return nbt.method_68083(key, 0);
    }

    private class_2487 getOrInitNbt(class_1799 stack) {
        class_9279 component = (class_9279)stack.method_58694(class_9334.field_49628);
        return component != null ? component.method_57461() : new class_2487();
    }

    private void setNbt(class_1799 stack, class_2487 nbt) {
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
    }

    private static class MaterialResult {
        class_1799 sourceStack;
        int bundleIndex;
        boolean fromBundle;
        class_2680 stateToPlace;

        private MaterialResult() {
        }

        public void consume() {
            if (this.fromBundle) {
                BuildingWandItem.removeOneFromBundle(this.sourceStack, this.bundleIndex);
            } else {
                this.sourceStack.method_7934(1);
            }
        }
    }
}

