/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding.items.custom;

import com.simplebuilding.component.ModDataComponentTypes;
import com.simplebuilding.enchantment.ModEnchantments;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2465;
import net.minecraft.class_2510;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9886;

public class ChiselItem
extends class_1792 {
    private Direction chiselDirection = Direction.FORWARD;
    private class_3414 chiselSound = class_3417.field_17710;
    private int cooldownTicks = 100;
    private final class_9886 material;
    private final Map<class_2248, class_2248> forwardMap;
    private final Map<class_2248, class_2248> backwardMap;
    private final Map<class_2248, class_2248> touchForwardMap;
    private final Map<class_2248, class_2248> touchBackwardMap;
    private static final Map<class_2248, class_2248> STONE_CHISEL_MAP = new HashMap<class_2248, class_2248>();
    private static final Map<class_2248, class_2248> STONE_SPATULA_MAP = new HashMap<class_2248, class_2248>();
    private static final Map<class_2248, class_2248> STONE_TOUCH_MAP = new HashMap<class_2248, class_2248>();
    private static final Map<class_2248, class_2248> STONE_TOUCH_SPATULA_MAP = new HashMap<class_2248, class_2248>();
    private static final Map<class_2248, class_2248> IRON_CHISEL_MAP = new HashMap<class_2248, class_2248>();
    private static final Map<class_2248, class_2248> IRON_SPATULA_MAP = new HashMap<class_2248, class_2248>();
    private static final Map<class_2248, class_2248> IRON_TOUCH_MAP = new HashMap<class_2248, class_2248>();
    private static final Map<class_2248, class_2248> IRON_TOUCH_SPATULA_MAP = new HashMap<class_2248, class_2248>();
    private static final Map<class_2248, class_2248> DIAMOND_CHISEL_MAP = new HashMap<class_2248, class_2248>();
    private static final Map<class_2248, class_2248> DIAMOND_SPATULA_MAP = new HashMap<class_2248, class_2248>();
    private static final Map<class_2248, class_2248> DIAMOND_TOUCH_MAP = new HashMap<class_2248, class_2248>();
    private static final Map<class_2248, class_2248> DIAMOND_TOUCH_SPATULA_MAP = new HashMap<class_2248, class_2248>();
    private static final Map<class_2248, class_2248> NETHERITE_CHISEL_MAP = new HashMap<class_2248, class_2248>();
    private static final Map<class_2248, class_2248> NETHERITE_SPATULA_MAP = new HashMap<class_2248, class_2248>();
    private static final Map<class_2248, class_2248> NETHERITE_TOUCH_MAP = new HashMap<class_2248, class_2248>();
    private static final Map<class_2248, class_2248> NETHERITE_TOUCH_SPATULA_MAP = new HashMap<class_2248, class_2248>();
    public static Map<class_2248, class_2248> FINAL_STONE_FWD;
    public static Map<class_2248, class_2248> FINAL_STONE_BWD;
    public static Map<class_2248, class_2248> FINAL_STONE_TOUCH_FWD;
    public static Map<class_2248, class_2248> FINAL_STONE_TOUCH_BWD;
    public static Map<class_2248, class_2248> FINAL_IRON_FWD;
    public static Map<class_2248, class_2248> FINAL_IRON_BWD;
    public static Map<class_2248, class_2248> FINAL_IRON_TOUCH_FWD;
    public static Map<class_2248, class_2248> FINAL_IRON_TOUCH_BWD;
    public static Map<class_2248, class_2248> FINAL_DIAMOND_FWD;
    public static Map<class_2248, class_2248> FINAL_DIAMOND_BWD;
    public static Map<class_2248, class_2248> FINAL_DIAMOND_TOUCH_FWD;
    public static Map<class_2248, class_2248> FINAL_DIAMOND_TOUCH_BWD;
    public static Map<class_2248, class_2248> FINAL_NETHERITE_FWD;
    public static Map<class_2248, class_2248> FINAL_NETHERITE_BWD;
    public static Map<class_2248, class_2248> FINAL_NETHERITE_TOUCH_FWD;
    public static Map<class_2248, class_2248> FINAL_NETHERITE_TOUCH_BWD;
    private boolean isDedicatedSpatula = false;

    public ChiselItem(class_9886 material, class_1792.class_1793 settings) {
        super(settings);
        this.material = material;
        if (material == class_9886.field_52586) {
            this.forwardMap = FINAL_STONE_FWD;
            this.backwardMap = FINAL_STONE_BWD;
            this.touchForwardMap = FINAL_STONE_TOUCH_FWD;
            this.touchBackwardMap = FINAL_STONE_TOUCH_BWD;
        } else if (material == class_9886.field_61350 || material == class_9886.field_52587) {
            this.forwardMap = FINAL_IRON_FWD;
            this.backwardMap = FINAL_IRON_BWD;
            this.touchForwardMap = FINAL_IRON_TOUCH_FWD;
            this.touchBackwardMap = FINAL_IRON_TOUCH_BWD;
        } else if (material == class_9886.field_52589 || material == class_9886.field_52588) {
            this.forwardMap = FINAL_DIAMOND_FWD;
            this.backwardMap = FINAL_DIAMOND_BWD;
            this.touchForwardMap = FINAL_DIAMOND_TOUCH_FWD;
            this.touchBackwardMap = FINAL_DIAMOND_TOUCH_BWD;
        } else if (material == class_9886.field_52590) {
            this.forwardMap = FINAL_NETHERITE_FWD;
            this.backwardMap = FINAL_NETHERITE_BWD;
            this.touchForwardMap = FINAL_NETHERITE_TOUCH_FWD;
            this.touchBackwardMap = FINAL_NETHERITE_TOUCH_BWD;
        } else {
            this.forwardMap = Map.of();
            this.backwardMap = Map.of();
            this.touchForwardMap = Map.of();
            this.touchBackwardMap = Map.of();
        }
    }

    public class_9886 getMaterial() {
        return this.material;
    }

    public boolean method_58405(class_1799 stack, class_2680 state) {
        return state.method_26164(class_3481.field_33715) || state.method_26164(class_3481.field_33713) || state.method_26164(class_3481.field_33716);
    }

    public float method_58404(class_1799 stack, class_2680 state) {
        if (!this.method_58405(stack, state)) {
            return 1.0f;
        }
        float materialSpeed = this.material.comp_2932();
        int fastChiselingLevel = this.getFastChiselingLevel(stack);
        float efficiencyBonus = 0.0f;
        if (fastChiselingLevel == 1) {
            efficiencyBonus = 5.0f;
        } else if (fastChiselingLevel >= 2) {
            efficiencyBonus = 17.0f;
        }
        return (materialSpeed + efficiencyBonus) * 0.5f;
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        if (!world.method_8608() && state.method_26214((class_1922)world, pos) != 0.0f) {
            stack.method_7970(2, miner, class_1304.field_6173);
        }
        return true;
    }

    private int getFastChiselingLevel(class_1799 stack) {
        class_9304 enchantments = (class_9304)stack.method_58694(class_9334.field_49633);
        if (enchantments == null) {
            return 0;
        }
        for (class_6880 entry : enchantments.method_57534()) {
            if (!entry.method_40225(ModEnchantments.FAST_CHISELING)) continue;
            return enchantments.method_57536(entry);
        }
        return 0;
    }

    public void setCooldownTicks(int ticks) {
        this.cooldownTicks = ticks;
    }

    public void setChiselSound(class_3414 chiselSound) {
        this.chiselSound = chiselSound;
    }

    public void setChiselDirectionCycle(Direction direction) {
        this.chiselDirection = direction;
    }

    public void setAsDedicatedSpatula(boolean value) {
        this.isDedicatedSpatula = value;
    }

    public class_1269 method_7884(class_1838 context) {
        assert (context.method_8036() != null);
        if (context.method_8045().method_8608() || context.method_8036().method_7357().method_7904(context.method_8041())) {
            return class_1269.field_5811;
        }
        class_243 relativeHit = context.method_17698().method_1020(class_243.method_24954((class_2382)context.method_8037()));
        return this.tryChiselBlock(context.method_8045(), context.method_8036(), context.method_20287(), context.method_8037(), context.method_8041(), context.method_8038(), relativeHit) ? class_1269.field_5812 : class_1269.field_5811;
    }

    private boolean tryChiselBlock(class_1937 world, class_1657 player, class_1268 hand, class_2338 pos, class_1799 stack, class_2350 side, class_243 relativeHit) {
        Map<class_2248, class_2248> currentMap;
        if (player.method_7357().method_7904(stack)) {
            return false;
        }
        class_2680 oldState = world.method_8320(pos);
        class_2248 oldBlock = oldState.method_26204();
        class_5455 registryManager = world.method_30349();
        class_6880<class_1887> touchEntry = this.getEnchantment((class_7225.class_7874)registryManager, ModEnchantments.CONSTRUCTORS_TOUCH);
        boolean hasConstructorsTouch = touchEntry != null && class_1890.method_8225(touchEntry, (class_1799)stack) > 0;
        boolean isSneaking = player.method_5715();
        boolean isReverseAction = false;
        if (this.isDedicatedSpatula) {
            currentMap = isSneaking ? (hasConstructorsTouch ? this.touchForwardMap : this.forwardMap) : (hasConstructorsTouch ? this.touchBackwardMap : this.backwardMap);
        } else if (isSneaking) {
            currentMap = hasConstructorsTouch ? this.touchBackwardMap : this.backwardMap;
            isReverseAction = true;
        } else {
            Map<class_2248, class_2248> map = currentMap = hasConstructorsTouch ? this.touchForwardMap : this.forwardMap;
        }
        if (currentMap.containsKey(oldBlock)) {
            class_2248 newBlock = currentMap.get(oldBlock);
            class_2680 newState = newBlock.method_9564();
            for (class_2769 prop : oldState.method_28501()) {
                if (!newState.method_28498(prop)) continue;
                newState = this.copyProperty(oldState, newState, prop);
            }
            newState = ChiselItem.applyIntuitiveOrientation(newState, side, relativeHit, player);
            world.method_8501(pos, newState);
            class_6880<class_1887> fastChiselEntry = this.getEnchantment((class_7225.class_7874)registryManager, ModEnchantments.FAST_CHISELING);
            int fastChiselingLevel = fastChiselEntry != null ? class_1890.method_8225(fastChiselEntry, (class_1799)stack) : 0;
            int finalCooldown = this.cooldownTicks;
            if (fastChiselingLevel > 0) {
                finalCooldown = Math.max(1, (int)((float)finalCooldown * (1.0f - (float)fastChiselingLevel * 0.3f)));
            }
            if (!player.method_31549().field_7477) {
                player.method_7357().method_62835(stack, finalCooldown);
                int damageAmount = isReverseAction ? 2 : 1;
                stack.method_7956(damageAmount, (class_3218)world, (class_3222)player, item -> player.method_20235(item, hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171));
            }
            float pitch = 1.0f + (world.field_9229.method_43057() * 0.4f - 0.2f);
            world.method_8396(null, pos, this.chiselSound, class_3419.field_15245, 0.5f, pitch);
            this.spawnEffects((class_3218)world, pos, oldState);
            stack.method_57379(ModDataComponentTypes.COORDINATES, (Object)pos);
            return true;
        }
        return false;
    }

    private <T extends Comparable<T>> class_2680 copyProperty(class_2680 from, class_2680 to, class_2769<T> property) {
        return (class_2680)to.method_11657(property, from.method_11654(property));
    }

    private void spawnEffects(class_3218 world, class_2338 pos, class_2680 oldState) {
        world.method_65096((class_2394)new class_2388(class_2398.field_11217, oldState), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 8, 0.2, 0.2, 0.2, 0.1);
    }

    private static void registerLinear(Map<class_2248, class_2248> forward, Map<class_2248, class_2248> backward, class_2248 ... blocks) {
        if (blocks.length < 2) {
            return;
        }
        for (int i = 0; i < blocks.length - 1; ++i) {
            class_2248 current = blocks[i];
            class_2248 next = blocks[i + 1];
            forward.put(current, next);
            backward.put(next, current);
        }
    }

    private static void registerCyclic(Map<class_2248, class_2248> forward, Map<class_2248, class_2248> backward, class_2248 ... blocks) {
        if (blocks.length < 2) {
            return;
        }
        for (int i = 0; i < blocks.length; ++i) {
            class_2248 current = blocks[i];
            class_2248 next = blocks[(i + 1) % blocks.length];
            forward.put(current, next);
            backward.put(next, current);
        }
    }

    private static Map<class_2248, class_2248> merge(Map<class_2248, class_2248> base, Map<class_2248, class_2248> addition) {
        HashMap<class_2248, class_2248> result = new HashMap<class_2248, class_2248>(base);
        result.putAll(addition);
        return Map.copyOf(result);
    }

    private static void registerLogs() {
        ChiselItem.registerLinear(STONE_TOUCH_MAP, STONE_TOUCH_SPATULA_MAP, class_2246.field_10431, class_2246.field_10519);
        ChiselItem.registerLinear(STONE_TOUCH_MAP, STONE_TOUCH_SPATULA_MAP, class_2246.field_10037, class_2246.field_10436);
        ChiselItem.registerLinear(STONE_TOUCH_MAP, STONE_TOUCH_SPATULA_MAP, class_2246.field_10511, class_2246.field_10366);
        ChiselItem.registerLinear(STONE_TOUCH_MAP, STONE_TOUCH_SPATULA_MAP, class_2246.field_10306, class_2246.field_10254);
        ChiselItem.registerLinear(STONE_TOUCH_MAP, STONE_TOUCH_SPATULA_MAP, class_2246.field_10533, class_2246.field_10622);
        ChiselItem.registerLinear(STONE_TOUCH_MAP, STONE_TOUCH_SPATULA_MAP, class_2246.field_10010, class_2246.field_10244);
        ChiselItem.registerLinear(STONE_TOUCH_MAP, STONE_TOUCH_SPATULA_MAP, class_2246.field_37545, class_2246.field_37548);
        ChiselItem.registerLinear(STONE_TOUCH_MAP, STONE_TOUCH_SPATULA_MAP, class_2246.field_42729, class_2246.field_42732);
        ChiselItem.registerLinear(STONE_TOUCH_MAP, STONE_TOUCH_SPATULA_MAP, class_2246.field_54715, class_2246.field_54716);
    }

    private static void registerWood() {
        ChiselItem.registerLinear(IRON_TOUCH_MAP, IRON_TOUCH_SPATULA_MAP, class_2246.field_10126, class_2246.field_10250);
        ChiselItem.registerLinear(IRON_TOUCH_MAP, IRON_TOUCH_SPATULA_MAP, class_2246.field_10155, class_2246.field_10558);
        ChiselItem.registerLinear(IRON_TOUCH_MAP, IRON_TOUCH_SPATULA_MAP, class_2246.field_10307, class_2246.field_10204);
        ChiselItem.registerLinear(IRON_TOUCH_MAP, IRON_TOUCH_SPATULA_MAP, class_2246.field_10303, class_2246.field_10084);
        ChiselItem.registerLinear(IRON_TOUCH_MAP, IRON_TOUCH_SPATULA_MAP, class_2246.field_9999, class_2246.field_10103);
        ChiselItem.registerLinear(IRON_TOUCH_MAP, IRON_TOUCH_SPATULA_MAP, class_2246.field_10178, class_2246.field_10374);
        ChiselItem.registerLinear(IRON_TOUCH_MAP, IRON_TOUCH_SPATULA_MAP, class_2246.field_37549, class_2246.field_37550);
        ChiselItem.registerLinear(IRON_TOUCH_MAP, IRON_TOUCH_SPATULA_MAP, class_2246.field_42733, class_2246.field_42730);
        ChiselItem.registerLinear(IRON_TOUCH_MAP, IRON_TOUCH_SPATULA_MAP, class_2246.field_54734, class_2246.field_54713);
    }

    private static void registerWoodVariants(Map<class_2248, class_2248> forward, Map<class_2248, class_2248> backward) {
        ChiselItem.registerLinear(forward, backward, class_2246.field_10161, class_2246.field_10563);
        ChiselItem.registerLinear(forward, backward, class_2246.field_10563, class_2246.field_10119);
        ChiselItem.registerLinear(forward, backward, class_2246.field_9975, class_2246.field_10569);
        ChiselItem.registerLinear(forward, backward, class_2246.field_10569, class_2246.field_10071);
        ChiselItem.registerLinear(forward, backward, class_2246.field_10148, class_2246.field_10408);
        ChiselItem.registerLinear(forward, backward, class_2246.field_10408, class_2246.field_10257);
        ChiselItem.registerLinear(forward, backward, class_2246.field_10334, class_2246.field_10122);
        ChiselItem.registerLinear(forward, backward, class_2246.field_10122, class_2246.field_10617);
        ChiselItem.registerLinear(forward, backward, class_2246.field_10218, class_2246.field_10256);
        ChiselItem.registerLinear(forward, backward, class_2246.field_10256, class_2246.field_10031);
        ChiselItem.registerLinear(forward, backward, class_2246.field_10075, class_2246.field_10616);
        ChiselItem.registerLinear(forward, backward, class_2246.field_10616, class_2246.field_10500);
        ChiselItem.registerLinear(forward, backward, class_2246.field_37577, class_2246.field_37561);
        ChiselItem.registerLinear(forward, backward, class_2246.field_37561, class_2246.field_37564);
        ChiselItem.registerLinear(forward, backward, class_2246.field_42751, class_2246.field_42744);
        ChiselItem.registerLinear(forward, backward, class_2246.field_42744, class_2246.field_42746);
        ChiselItem.registerLinear(forward, backward, class_2246.field_40294, class_2246.field_40287);
        ChiselItem.registerLinear(forward, backward, class_2246.field_40287, class_2246.field_40292);
        ChiselItem.registerLinear(forward, backward, class_2246.field_54735, class_2246.field_54726);
        ChiselItem.registerLinear(forward, backward, class_2246.field_54726, class_2246.field_54727);
    }

    private static void registerNetherWoodVariants(Map<class_2248, class_2248> forward, Map<class_2248, class_2248> backward) {
        ChiselItem.registerLinear(forward, backward, class_2246.field_22126, class_2246.field_22098);
        ChiselItem.registerLinear(forward, backward, class_2246.field_22098, class_2246.field_22128);
        ChiselItem.registerLinear(forward, backward, class_2246.field_22127, class_2246.field_22099);
        ChiselItem.registerLinear(forward, backward, class_2246.field_22099, class_2246.field_22129);
    }

    private static void registerAndesiteDioriteGranite() {
        ChiselItem.registerLinear(IRON_CHISEL_MAP, IRON_SPATULA_MAP, class_2246.field_10093, class_2246.field_10115);
        ChiselItem.registerLinear(IRON_CHISEL_MAP, IRON_SPATULA_MAP, class_2246.field_9994, class_2246.field_10386);
        ChiselItem.registerLinear(IRON_CHISEL_MAP, IRON_SPATULA_MAP, class_2246.field_10322, class_2246.field_10016);
        ChiselItem.registerLinear(IRON_CHISEL_MAP, IRON_SPATULA_MAP, class_2246.field_10346, class_2246.field_10508);
        ChiselItem.registerLinear(IRON_CHISEL_MAP, IRON_SPATULA_MAP, class_2246.field_10310, class_2246.field_10216);
        ChiselItem.registerLinear(IRON_CHISEL_MAP, IRON_SPATULA_MAP, class_2246.field_10412, class_2246.field_10507);
        ChiselItem.registerLinear(IRON_CHISEL_MAP, IRON_SPATULA_MAP, class_2246.field_10289, class_2246.field_10474);
        ChiselItem.registerLinear(IRON_CHISEL_MAP, IRON_SPATULA_MAP, class_2246.field_10435, class_2246.field_10607);
        ChiselItem.registerLinear(IRON_CHISEL_MAP, IRON_SPATULA_MAP, class_2246.field_10329, class_2246.field_10189);
    }

    private static void registerStems() {
        ChiselItem.registerLinear(NETHERITE_TOUCH_MAP, NETHERITE_TOUCH_SPATULA_MAP, class_2246.field_22118, class_2246.field_22119);
        ChiselItem.registerLinear(NETHERITE_TOUCH_MAP, NETHERITE_TOUCH_SPATULA_MAP, class_2246.field_22111, class_2246.field_22112);
    }

    private static void registerConcrete() {
        class_2248[] blocks = new class_2248[]{class_2246.field_10107, class_2246.field_10210, class_2246.field_10585, class_2246.field_10242, class_2246.field_10542, class_2246.field_10421, class_2246.field_10434, class_2246.field_10038, class_2246.field_10172, class_2246.field_10308, class_2246.field_10206, class_2246.field_10011, class_2246.field_10439, class_2246.field_10367, class_2246.field_10058, class_2246.field_10458};
        class_2248[] powders = new class_2248[]{class_2246.field_10197, class_2246.field_10022, class_2246.field_10300, class_2246.field_10321, class_2246.field_10145, class_2246.field_10133, class_2246.field_10522, class_2246.field_10353, class_2246.field_10628, class_2246.field_10233, class_2246.field_10404, class_2246.field_10456, class_2246.field_10023, class_2246.field_10529, class_2246.field_10287, class_2246.field_10506};
        for (int i = 0; i < blocks.length; ++i) {
            ChiselItem.registerLinear(NETHERITE_TOUCH_MAP, NETHERITE_TOUCH_SPATULA_MAP, blocks[i], powders[i]);
        }
    }

    public boolean canChisel(class_1937 world, class_2338 pos, class_1799 stack, class_1657 player) {
        if (player.method_7357().method_7904(stack)) {
            return false;
        }
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        class_5455 registryManager = world.method_30349();
        class_6880<class_1887> touchEntry = this.getEnchantment((class_7225.class_7874)registryManager, ModEnchantments.CONSTRUCTORS_TOUCH);
        boolean hasConstructorsTouch = touchEntry != null && class_1890.method_8225(touchEntry, (class_1799)stack) > 0;
        boolean isSneaking = player.method_5715();
        Map<class_2248, class_2248> currentMap = this.isDedicatedSpatula ? (isSneaking ? (hasConstructorsTouch ? this.touchForwardMap : this.forwardMap) : (hasConstructorsTouch ? this.touchBackwardMap : this.backwardMap)) : (isSneaking ? (hasConstructorsTouch ? this.touchBackwardMap : this.backwardMap) : (hasConstructorsTouch ? this.touchForwardMap : this.forwardMap));
        return currentMap.containsKey(block);
    }

    private class_6880<class_1887> getEnchantment(class_7225.class_7874 registry, class_5321<class_1887> key) {
        Optional optional = registry.method_46762(class_7924.field_41265).method_46746(key);
        return optional.orElse(null);
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type) {
        if (stack.method_58694(ModDataComponentTypes.COORDINATES) != null) {
            class_2338 p = (class_2338)stack.method_58694(ModDataComponentTypes.COORDINATES);
            assert (p != null);
            textConsumer.accept((class_2561)class_2561.method_43470((String)("Last Target: " + p.method_10263() + ", " + p.method_10264() + ", " + p.method_10260())).method_27692(class_124.field_1080));
        }
        super.method_67187(stack, context, displayComponent, textConsumer, type);
    }

    public static class_2680 applyIntuitiveOrientation(class_2680 state, class_2350 side, class_243 hit, class_1657 player) {
        double margin = 0.25;
        double x = hit.field_1352;
        double y = hit.field_1351;
        double z = hit.field_1350;
        class_2350 orientation = side;
        boolean isEdge = false;
        if (side.method_10166() == class_2350.class_2351.field_11052) {
            if (x < margin) {
                orientation = class_2350.field_11039;
                isEdge = true;
            } else if (x > 1.0 - margin) {
                orientation = class_2350.field_11034;
                isEdge = true;
            } else if (z < margin) {
                orientation = class_2350.field_11043;
                isEdge = true;
            } else if (z > 1.0 - margin) {
                orientation = class_2350.field_11035;
                isEdge = true;
            }
        } else if (side.method_10166() == class_2350.class_2351.field_11048) {
            if (y < margin) {
                orientation = class_2350.field_11033;
                isEdge = true;
            } else if (y > 1.0 - margin) {
                orientation = class_2350.field_11036;
                isEdge = true;
            } else if (z < margin) {
                orientation = class_2350.field_11043;
                isEdge = true;
            } else if (z > 1.0 - margin) {
                orientation = class_2350.field_11035;
                isEdge = true;
            }
        } else if (side.method_10166() == class_2350.class_2351.field_11051) {
            if (y < margin) {
                orientation = class_2350.field_11033;
                isEdge = true;
            } else if (y > 1.0 - margin) {
                orientation = class_2350.field_11036;
                isEdge = true;
            } else if (x < margin) {
                orientation = class_2350.field_11039;
                isEdge = true;
            } else if (x > 1.0 - margin) {
                orientation = class_2350.field_11034;
                isEdge = true;
            }
        }
        if (state.method_28498((class_2769)class_2465.field_11459)) {
            class_2350.class_2351 axis = isEdge ? orientation.method_10166() : side.method_10166();
            return (class_2680)state.method_11657((class_2769)class_2465.field_11459, (Comparable)axis);
        }
        if (state.method_28498((class_2769)class_2510.field_11571)) {
            class_2350 facing = isEdge && orientation.method_10166().method_10179() ? orientation.method_10153() : player.method_5735();
            state = (class_2680)state.method_11657((class_2769)class_2510.field_11571, (Comparable)facing);
            class_2760 half = side == class_2350.field_11036 && !isEdge || y < 0.5 && !isEdge ? class_2760.field_12617 : (side == class_2350.field_11033 && !isEdge || y > 0.5 && !isEdge ? class_2760.field_12619 : (y > 0.5 ? class_2760.field_12619 : class_2760.field_12617));
            if (orientation == class_2350.field_11036) {
                half = class_2760.field_12617;
            }
            if (orientation == class_2350.field_11033) {
                half = class_2760.field_12619;
            }
            state = (class_2680)state.method_11657((class_2769)class_2510.field_11572, (Comparable)half);
            return state;
        }
        if (state.method_28498((class_2769)class_2741.field_12525)) {
            return (class_2680)state.method_11657((class_2769)class_2741.field_12525, (Comparable)(isEdge ? orientation : side));
        }
        return state;
    }

    static {
        ChiselItem.registerLinear(STONE_CHISEL_MAP, STONE_SPATULA_MAP, class_2246.field_10467, class_2246.field_10361, class_2246.field_9979, class_2246.field_10292);
        ChiselItem.registerLinear(STONE_CHISEL_MAP, STONE_SPATULA_MAP, class_2246.field_10142, class_2246.field_10549);
        ChiselItem.registerLinear(STONE_CHISEL_MAP, STONE_SPATULA_MAP, class_2246.field_10007, class_2246.field_18890, class_2246.field_10262);
        ChiselItem.registerLinear(STONE_CHISEL_MAP, STONE_SPATULA_MAP, class_2246.field_10483, class_2246.field_10518, class_2246.field_10344, class_2246.field_10117);
        ChiselItem.registerLinear(STONE_CHISEL_MAP, STONE_SPATULA_MAP, class_2246.field_10420, class_2246.field_10039);
        ChiselItem.registerLinear(STONE_CHISEL_MAP, STONE_SPATULA_MAP, class_2246.field_10624, class_2246.field_18891, class_2246.field_10283);
        ChiselItem.registerLinear(STONE_CHISEL_MAP, STONE_SPATULA_MAP, class_2246.field_10340, class_2246.field_10552);
        ChiselItem.registerLinear(STONE_CHISEL_MAP, STONE_SPATULA_MAP, class_2246.field_10136, class_2246.field_10454);
        ChiselItem.registerLinear(STONE_CHISEL_MAP, STONE_SPATULA_MAP, class_2246.field_10440, class_2246.field_10596);
        ChiselItem.registerLinear(STONE_TOUCH_MAP, STONE_TOUCH_SPATULA_MAP, class_2246.field_37557, class_2246.field_37556, class_2246.field_37576);
        ChiselItem.registerLinear(STONE_TOUCH_MAP, STONE_TOUCH_SPATULA_MAP, class_2246.field_37558, class_2246.field_37558);
        ChiselItem.registerLinear(STONE_TOUCH_MAP, STONE_TOUCH_SPATULA_MAP, class_2246.field_37562, class_2246.field_37562);
        ChiselItem.registerLinear(STONE_TOUCH_MAP, STONE_TOUCH_SPATULA_MAP, class_2246.field_10445, class_2246.field_9989);
        ChiselItem.registerLinear(STONE_TOUCH_MAP, STONE_TOUCH_SPATULA_MAP, class_2246.field_10596, class_2246.field_10207);
        ChiselItem.registerLinear(STONE_TOUCH_MAP, STONE_TOUCH_SPATULA_MAP, class_2246.field_10351, class_2246.field_10405);
        ChiselItem.registerLogs();
        ChiselItem.registerLinear(IRON_CHISEL_MAP, IRON_SPATULA_MAP, class_2246.field_10552, class_2246.field_10056, class_2246.field_10416);
        ChiselItem.registerLinear(IRON_CHISEL_MAP, IRON_SPATULA_MAP, class_2246.field_10392, class_2246.field_10173);
        ChiselItem.registerLinear(IRON_CHISEL_MAP, IRON_SPATULA_MAP, class_2246.field_10131, class_2246.field_10024);
        ChiselItem.registerAndesiteDioriteGranite();
        ChiselItem.registerLinear(IRON_CHISEL_MAP, IRON_SPATULA_MAP, class_2246.field_47030, class_2246.field_27165);
        ChiselItem.registerLinear(IRON_CHISEL_MAP, IRON_SPATULA_MAP, class_2246.field_47032, class_2246.field_47028);
        ChiselItem.registerLinear(IRON_CHISEL_MAP, IRON_SPATULA_MAP, class_2246.field_47031, class_2246.field_47027);
        ChiselItem.registerLinear(IRON_TOUCH_MAP, IRON_TOUCH_SPATULA_MAP, class_2246.field_10104, class_2246.field_37557);
        ChiselItem.registerLinear(IRON_TOUCH_MAP, IRON_TOUCH_SPATULA_MAP, class_2246.field_10089, class_2246.field_37558);
        ChiselItem.registerLinear(IRON_TOUCH_MAP, IRON_TOUCH_SPATULA_MAP, class_2246.field_10191, class_2246.field_37562);
        ChiselItem.registerWood();
        ChiselItem.registerWoodVariants(IRON_CHISEL_MAP, IRON_SPATULA_MAP);
        ChiselItem.registerNetherWoodVariants(IRON_TOUCH_MAP, IRON_TOUCH_SPATULA_MAP);
        ChiselItem.registerLinear(DIAMOND_CHISEL_MAP, DIAMOND_SPATULA_MAP, class_2246.field_9978, class_2246.field_10437, class_2246.field_23868, class_2246.field_10044, class_2246.field_10153);
        ChiselItem.registerLinear(DIAMOND_CHISEL_MAP, DIAMOND_SPATULA_MAP, class_2246.field_10245, class_2246.field_10451);
        ChiselItem.registerLinear(DIAMOND_CHISEL_MAP, DIAMOND_SPATULA_MAP, class_2246.field_10601, class_2246.field_10237);
        ChiselItem.registerLinear(DIAMOND_CHISEL_MAP, DIAMOND_SPATULA_MAP, class_2246.field_47030, class_2246.field_27165, class_2246.field_47034, class_2246.field_47035);
        ChiselItem.registerLinear(DIAMOND_CHISEL_MAP, DIAMOND_SPATULA_MAP, class_2246.field_47028, class_2246.field_47037, class_2246.field_47032);
        ChiselItem.registerLinear(DIAMOND_CHISEL_MAP, DIAMOND_SPATULA_MAP, class_2246.field_47027, class_2246.field_47036, class_2246.field_47031);
        ChiselItem.registerLinear(DIAMOND_TOUCH_MAP, DIAMOND_TOUCH_SPATULA_MAP, class_2246.field_10135, class_2246.field_10006);
        ChiselItem.registerLinear(DIAMOND_TOUCH_MAP, DIAMOND_TOUCH_SPATULA_MAP, class_2246.field_10350, class_2246.field_10190);
        ChiselItem.registerLinear(DIAMOND_TOUCH_MAP, DIAMOND_TOUCH_SPATULA_MAP, class_2246.field_10389, class_2246.field_10236);
        ChiselItem.registerLinear(DIAMOND_TOUCH_MAP, DIAMOND_TOUCH_SPATULA_MAP, class_2246.field_10360, class_2246.field_10340);
        ChiselItem.registerLinear(DIAMOND_TOUCH_MAP, DIAMOND_TOUCH_SPATULA_MAP, class_2246.field_10136, class_2246.field_10454);
        ChiselItem.registerLinear(DIAMOND_CHISEL_MAP, DIAMOND_SPATULA_MAP, class_2246.field_23873, class_2246.field_23869, class_2246.field_23876, class_2246.field_23874, class_2246.field_23875);
        ChiselItem.registerLinear(DIAMOND_CHISEL_MAP, DIAMOND_SPATULA_MAP, class_2246.field_23861, class_2246.field_23870, class_2246.field_23878);
        ChiselItem.registerLinear(DIAMOND_CHISEL_MAP, DIAMOND_SPATULA_MAP, class_2246.field_23862, class_2246.field_23872, class_2246.field_23877);
        ChiselItem.registerLinear(DIAMOND_CHISEL_MAP, DIAMOND_SPATULA_MAP, class_2246.field_22091, class_2246.field_29032, class_2246.field_23151);
        ChiselItem.registerLinear(DIAMOND_CHISEL_MAP, DIAMOND_SPATULA_MAP, class_2246.field_28892, class_2246.field_28904, class_2246.field_28900, class_2246.field_29222, class_2246.field_28896, class_2246.field_29223, class_2246.field_28888, class_2246.field_29031);
        ChiselItem.registerLinear(DIAMOND_CHISEL_MAP, DIAMOND_SPATULA_MAP, class_2246.field_28893, class_2246.field_28901, class_2246.field_28897, class_2246.field_28889);
        ChiselItem.registerLinear(DIAMOND_CHISEL_MAP, DIAMOND_SPATULA_MAP, class_2246.field_28894, class_2246.field_28902, class_2246.field_28898, class_2246.field_28890);
        ChiselItem.registerLinear(DIAMOND_CHISEL_MAP, DIAMOND_SPATULA_MAP, class_2246.field_10416, class_2246.field_10445);
        ChiselItem.registerLinear(DIAMOND_TOUCH_MAP, DIAMOND_TOUCH_SPATULA_MAP, class_2246.field_10471, class_2246.field_10462);
        ChiselItem.registerLinear(DIAMOND_TOUCH_MAP, DIAMOND_TOUCH_SPATULA_MAP, class_2246.field_10012, class_2246.field_10012);
        ChiselItem.registerLinear(DIAMOND_TOUCH_MAP, DIAMOND_TOUCH_SPATULA_MAP, class_2246.field_10064, class_2246.field_10064);
        ChiselItem.registerLinear(DIAMOND_TOUCH_MAP, DIAMOND_TOUCH_SPATULA_MAP, class_2246.field_10505, class_2246.field_10286);
        ChiselItem.registerLinear(DIAMOND_TOUCH_MAP, DIAMOND_TOUCH_SPATULA_MAP, class_2246.field_9992, class_2246.field_9992);
        ChiselItem.registerLinear(DIAMOND_TOUCH_MAP, DIAMOND_TOUCH_SPATULA_MAP, class_2246.field_10175, class_2246.field_10175);
        ChiselItem.registerLinear(DIAMOND_TOUCH_MAP, DIAMOND_TOUCH_SPATULA_MAP, class_2246.field_27119, class_2246.field_27124, class_2246.field_47057, class_2246.field_47064);
        ChiselItem.registerLinear(DIAMOND_TOUCH_MAP, DIAMOND_TOUCH_SPATULA_MAP, class_2246.field_27128, class_2246.field_27128);
        ChiselItem.registerLinear(DIAMOND_TOUCH_MAP, DIAMOND_TOUCH_SPATULA_MAP, class_2246.field_27132, class_2246.field_27132);
        ChiselItem.registerCyclic(DIAMOND_TOUCH_MAP, DIAMOND_TOUCH_SPATULA_MAP, class_2246.field_10264, class_2246.field_10396, class_2246.field_10111, class_2246.field_10488, class_2246.field_10614);
        ChiselItem.registerCyclic(DIAMOND_TOUCH_MAP, DIAMOND_TOUCH_SPATULA_MAP, class_2246.field_10629, class_2246.field_10000, class_2246.field_10516, class_2246.field_10464, class_2246.field_10309);
        ChiselItem.registerCyclic(NETHERITE_CHISEL_MAP, NETHERITE_SPATULA_MAP, class_2246.field_10515, class_2246.field_10266, class_2246.field_23867, class_2246.field_23866);
        ChiselItem.registerLinear(NETHERITE_CHISEL_MAP, NETHERITE_SPATULA_MAP, class_2246.field_10159, class_2246.field_10159);
        ChiselItem.registerLinear(NETHERITE_CHISEL_MAP, NETHERITE_SPATULA_MAP, class_2246.field_10390, class_2246.field_10390);
        ChiselItem.registerLinear(NETHERITE_CHISEL_MAP, NETHERITE_SPATULA_MAP, class_2246.field_55054, class_2246.field_55058);
        ChiselItem.registerLinear(NETHERITE_CHISEL_MAP, NETHERITE_SPATULA_MAP, class_2246.field_55055, class_2246.field_55055);
        ChiselItem.registerLinear(NETHERITE_CHISEL_MAP, NETHERITE_SPATULA_MAP, class_2246.field_55056, class_2246.field_55056);
        ChiselItem.registerLinear(NETHERITE_CHISEL_MAP, NETHERITE_SPATULA_MAP, class_2246.field_10292, class_2246.field_10102);
        ChiselItem.registerLinear(NETHERITE_CHISEL_MAP, NETHERITE_SPATULA_MAP, class_2246.field_10117, class_2246.field_10534);
        ChiselItem.registerLinear(NETHERITE_TOUCH_MAP, NETHERITE_TOUCH_SPATULA_MAP, class_2246.field_10346, class_2246.field_10508, class_2246.field_27114, class_2246.field_28049);
        ChiselItem.registerLinear(NETHERITE_TOUCH_MAP, NETHERITE_TOUCH_SPATULA_MAP, class_2246.field_10540, class_2246.field_22423);
        ChiselItem.registerStems();
        ChiselItem.registerConcrete();
        FINAL_STONE_FWD = Map.copyOf(STONE_CHISEL_MAP);
        FINAL_STONE_BWD = Map.copyOf(STONE_SPATULA_MAP);
        FINAL_STONE_TOUCH_FWD = ChiselItem.merge(STONE_CHISEL_MAP, STONE_TOUCH_MAP);
        FINAL_STONE_TOUCH_BWD = ChiselItem.merge(STONE_SPATULA_MAP, STONE_TOUCH_SPATULA_MAP);
        FINAL_IRON_FWD = ChiselItem.merge(FINAL_STONE_FWD, IRON_CHISEL_MAP);
        FINAL_IRON_BWD = ChiselItem.merge(FINAL_STONE_BWD, IRON_SPATULA_MAP);
        FINAL_IRON_TOUCH_FWD = ChiselItem.merge(FINAL_STONE_TOUCH_FWD, ChiselItem.merge(IRON_CHISEL_MAP, IRON_TOUCH_MAP));
        FINAL_IRON_TOUCH_BWD = ChiselItem.merge(FINAL_STONE_TOUCH_BWD, ChiselItem.merge(IRON_SPATULA_MAP, IRON_TOUCH_SPATULA_MAP));
        FINAL_DIAMOND_FWD = ChiselItem.merge(FINAL_IRON_FWD, DIAMOND_CHISEL_MAP);
        FINAL_DIAMOND_BWD = ChiselItem.merge(FINAL_IRON_BWD, DIAMOND_SPATULA_MAP);
        FINAL_DIAMOND_TOUCH_FWD = ChiselItem.merge(FINAL_IRON_TOUCH_FWD, ChiselItem.merge(DIAMOND_CHISEL_MAP, DIAMOND_TOUCH_MAP));
        FINAL_DIAMOND_TOUCH_BWD = ChiselItem.merge(FINAL_IRON_TOUCH_BWD, ChiselItem.merge(DIAMOND_SPATULA_MAP, DIAMOND_TOUCH_SPATULA_MAP));
        FINAL_NETHERITE_FWD = ChiselItem.merge(FINAL_DIAMOND_FWD, NETHERITE_CHISEL_MAP);
        FINAL_NETHERITE_BWD = ChiselItem.merge(FINAL_DIAMOND_BWD, NETHERITE_SPATULA_MAP);
        FINAL_NETHERITE_TOUCH_FWD = ChiselItem.merge(FINAL_DIAMOND_TOUCH_FWD, ChiselItem.merge(NETHERITE_CHISEL_MAP, NETHERITE_TOUCH_MAP));
        FINAL_NETHERITE_TOUCH_BWD = ChiselItem.merge(FINAL_DIAMOND_TOUCH_BWD, ChiselItem.merge(NETHERITE_SPATULA_MAP, NETHERITE_TOUCH_SPATULA_MAP));
    }

    public static enum Direction {
        FORWARD,
        BACKWARD;

    }
}

