/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding.items.custom;

import com.simplebuilding.enchantment.ModEnchantments;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class OreDetectorItem
extends class_1792 {
    private static final double BUDGET_COMMON = 24.0;
    private static final double BUDGET_MEDIUM = 18.0;
    private static final double BUDGET_RARE = 16.0;
    private static final double BUDGET_VERY_RARE = 10.0;
    private static final int SCAN_INTERVAL = 20;

    public OreDetectorItem(class_1792.class_1793 settings) {
        super(settings.method_7889(1).method_7895(1024));
    }

    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
        class_2338 targetPos;
        boolean isHeld;
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        boolean bl = isHeld = slot == class_1304.field_6173 || slot == class_1304.field_6171;
        if (!isHeld) {
            return;
        }
        if (world.method_75260() % 20L != 0L) {
            return;
        }
        DetectMode mode = this.getMode(stack);
        class_2338 playerPos = class_2338.method_49638((class_2374)player.method_33571());
        double costMultiplier = 2.0;
        class_5455 registry = world.method_30349();
        class_2378 enchantments = registry.method_30530(class_7924.field_41265);
        Optional touchKey = enchantments.method_46746(ModEnchantments.CONSTRUCTORS_TOUCH);
        if (touchKey.isPresent() && class_1890.method_8225((class_6880)((class_6880)touchKey.get()), (class_1799)stack) > 0) {
            costMultiplier = 1.0;
        }
        if ((targetPos = this.findNearestOreWithRaycast((class_1937)world, player.method_33571(), mode, stack, costMultiplier)) != null) {
            class_2680 targetState = world.method_8320(targetPos);
            double distance = Math.sqrt(playerPos.method_10262((class_2382)targetPos));
            float pitch = (float)((double)1.8f - distance / 32.0);
            pitch = Math.max(0.6f, Math.min(2.0f, pitch));
            world.method_8396(null, targetPos, class_3417.field_26980, class_3419.field_15245, 0.9f, pitch);
            world.method_8396(null, targetPos, class_3417.field_28081, class_3419.field_15245, 0.6f, 2.0f);
            class_3414 blockSound = targetState.method_26231().method_10595();
            world.method_8396(null, targetPos, blockSound, class_3419.field_15245, 0.55f, pitch);
            this.spawnSonarBeam(world, player.method_33571(), targetPos, targetState);
        }
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (user.method_5715()) {
            if (!world.method_8608()) {
                class_1799 stack = user.method_5998(hand);
                this.cycleMode(stack, user);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public class_1269 method_7884(class_1838 context) {
        if (context.method_8036() != null && context.method_8036().method_5715()) {
            class_1937 world = context.method_8045();
            if (!world.method_8608()) {
                class_1799 stack = context.method_8041();
                class_2680 state = world.method_8320(context.method_8037());
                this.setMode(stack, DetectMode.CUSTOM);
                this.setCustomBlock(stack, state);
                context.method_8036().method_7353((class_2561)class_2561.method_43470((String)"Calibrated to: ").method_27692(class_124.field_1060).method_10852((class_2561)state.method_26204().method_9518().method_27661().method_27692(class_124.field_1068)), true);
                world.method_8396(null, context.method_8037(), class_3417.field_37364, class_3419.field_15248, 1.0f, 1.0f);
            }
            return class_1269.field_5812;
        }
        return super.method_7884(context);
    }

    private class_2338 findNearestOreWithRaycast(class_1937 world, class_243 eyesPos, DetectMode mode, class_1799 stack, double costMultiplier) {
        class_2338 origin = class_2338.method_49638((class_2374)eyesPos);
        class_2680 customTarget = mode == DetectMode.CUSTOM ? this.getCustomBlock(stack, (class_7225.class_7874)world.method_30349()) : null;
        int scanRadius = (int)Math.ceil(mode.budget);
        ArrayList<class_2338> candidates = new ArrayList<class_2338>();
        for (int x = -scanRadius; x <= scanRadius; ++x) {
            for (int y = -scanRadius; y <= scanRadius; ++y) {
                for (int z = -scanRadius; z <= scanRadius; ++z) {
                    class_2680 state;
                    class_2338 checkPos = origin.method_10069(x, y, z);
                    if (origin.method_10262((class_2382)checkPos) > (double)(scanRadius * scanRadius) || !this.isTarget(state = world.method_8320(checkPos), mode, customTarget)) continue;
                    candidates.add(checkPos);
                }
            }
        }
        candidates.sort(Comparator.comparingDouble(pos -> pos.method_10262((class_2382)origin)));
        for (class_2338 candidate : candidates) {
            if (!this.canReach(world, eyesPos, candidate, mode.budget, costMultiplier)) continue;
            return candidate;
        }
        return null;
    }

    private boolean canReach(class_1937 world, class_243 start, class_2338 target, double budget, double costMultiplier) {
        class_243 currentPos;
        class_2338 bPos;
        class_243 end = target.method_46558();
        class_243 vector = end.method_1020(start);
        double distance = vector.method_1033();
        class_243 direction = vector.method_1029();
        double accumulatedCost = 0.0;
        double stepSize = 0.5;
        for (double d = 0.0; d < distance && !(bPos = class_2338.method_49638((class_2374)(currentPos = start.method_1019(direction.method_1021(d))))).equals((Object)target); d += stepSize) {
            class_2680 state = world.method_8320(bPos);
            double blockDensity = this.getBlockDensity(state);
            if (!((accumulatedCost += stepSize * blockDensity * costMultiplier) > budget)) continue;
            return false;
        }
        return accumulatedCost <= budget;
    }

    private double getBlockDensity(class_2680 state) {
        if (state.method_26215() || !state.method_26216()) {
            return 1.0;
        }
        if (state.method_27852(class_2246.field_10515)) {
            return 1.5;
        }
        if (state.method_26164(class_3481.field_28993) || state.method_27852(class_2246.field_22091) || state.method_27852(class_2246.field_23151) || state.method_27852(class_2246.field_23869)) {
            return 6.0;
        }
        if (state.method_26164(class_3481.field_25806)) {
            return 3.0;
        }
        return 3.0;
    }

    private boolean isTarget(class_2680 state, DetectMode mode, class_2680 customTarget) {
        return switch (mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> state.method_26164(class_3481.field_28988);
            case 1 -> state.method_26164(class_3481.field_23062);
            case 2 -> state.method_26164(class_3481.field_28989);
            case 3 -> state.method_27852(class_2246.field_22109);
            case 4 -> {
                if (state.method_26164(class_3481.field_29193) || state.method_26164(class_3481.field_28988) || state.method_26164(class_3481.field_29195) || state.method_26164(class_3481.field_23062) || state.method_26164(class_3481.field_28990) || state.method_26164(class_3481.field_28991) || state.method_26164(class_3481.field_28989) || state.method_26164(class_3481.field_29194) || state.method_27852(class_2246.field_22109) || state.method_27852(class_2246.field_10213)) {
                    yield true;
                }
                yield false;
            }
            case 5 -> customTarget != null && state.method_27852(customTarget.method_26204());
        };
    }

    private void spawnSonarBeam(class_3218 world, class_243 startPos, class_2338 endPos, class_2680 targetState) {
        class_243 targetCenter = endPos.method_46558();
        class_243 direction = targetCenter.method_1020(startPos).method_1029();
        double distance = startPos.method_1022(targetCenter);
        double stepSize = 0.4;
        for (double d = 0.5; d < distance; d += stepSize) {
            class_243 p = startPos.method_1019(direction.method_1021(d));
            world.method_65096((class_2394)new class_2388(class_2398.field_11217, targetState), p.field_1352, p.field_1351, p.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
        world.method_65096((class_2394)class_2398.field_11207, targetCenter.field_1352, targetCenter.field_1351, targetCenter.field_1350, 3, 0.1, 0.1, 0.1, 0.02);
        world.method_65096((class_2394)class_2398.field_29642, targetCenter.field_1352, targetCenter.field_1351, targetCenter.field_1350, 5, 0.3, 0.3, 0.3, 0.05);
    }

    private void cycleMode(class_1799 stack, class_1657 player) {
        DetectMode current = this.getMode(stack);
        DetectMode[] modes = DetectMode.values();
        DetectMode next = modes[(current.ordinal() + 1) % modes.length];
        this.setMode(stack, next);
        player.method_7353((class_2561)class_2561.method_43470((String)"Detector Mode: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)next.name).method_27692(next.color)), true);
        player.method_5783((class_3414)class_3417.field_15015.comp_349(), 0.5f, 1.5f);
        if (!player.method_68878()) {
            stack.method_7970(1, (class_1309)player, class_1304.field_6173);
        }
    }

    private DetectMode getMode(class_1799 stack) {
        class_2487 nbt = ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        int modeIndex = 0;
        if (nbt.method_10545("Mode")) {
            modeIndex = nbt.method_68083("Mode", 0);
        }
        modeIndex = Math.max(0, Math.min(DetectMode.values().length - 1, modeIndex));
        return DetectMode.values()[modeIndex];
    }

    private void setMode(class_1799 stack, DetectMode mode) {
        class_9279.method_57452((class_9331)class_9334.field_49628, (class_1799)stack, nbt -> nbt.method_10569("Mode", mode.ordinal()));
    }

    private void setCustomBlock(class_1799 stack, class_2680 state) {
        class_9279.method_57452((class_9331)class_9334.field_49628, (class_1799)stack, nbt -> nbt.method_10566("CustomBlock", (class_2520)class_2512.method_10686((class_2680)state)));
    }

    private class_2680 getCustomBlock(class_1799 stack, class_7225.class_7874 registryLookup) {
        if (registryLookup == null) {
            return null;
        }
        class_2487 nbt = ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        if (nbt.method_10545("CustomBlock")) {
            class_7225.class_7226 blockRegistry = registryLookup.method_46762(class_7924.field_41254);
            return class_2512.method_10681((class_7871)blockRegistry, (class_2487)nbt.method_68568("CustomBlock"));
        }
        return null;
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type) {
        DetectMode mode = this.getMode(stack);
        textConsumer.accept((class_2561)class_2561.method_43470((String)"Mode: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)mode.name).method_27692(mode.color)));
        if (mode == DetectMode.CUSTOM) {
            class_2680 custom = this.getCustomBlock(stack, context.method_59527());
            if (custom != null) {
                textConsumer.accept((class_2561)class_2561.method_43470((String)"Target: ").method_27692(class_124.field_1080).method_10852((class_2561)custom.method_26204().method_9518().method_27661().method_27692(class_124.field_1060)));
            } else {
                textConsumer.accept((class_2561)class_2561.method_43470((String)"Target: None (Sneak-Use on block)").method_27692(class_124.field_1061));
            }
        } else {
            textConsumer.accept((class_2561)class_2561.method_43470((String)"Sneak + Use to cycle modes").method_27692(class_124.field_1063));
        }
        textConsumer.accept((class_2561)class_2561.method_43473());
        textConsumer.accept((class_2561)class_2561.method_43470((String)("Power: " + (int)mode.budget)).method_27692(class_124.field_1062));
        textConsumer.accept((class_2561)class_2561.method_43470((String)"Penetrates dense blocks slower.").method_27692(class_124.field_1080));
    }

    private static enum DetectMode {
        IRON(class_124.field_1080, "Iron", (class_6862<class_2248>)class_3481.field_28988, 24.0),
        GOLD(class_124.field_1065, "Gold", (class_6862<class_2248>)class_3481.field_23062, 18.0),
        DIAMOND(class_124.field_1075, "Diamond", (class_6862<class_2248>)class_3481.field_28989, 16.0),
        NETHERITE(class_124.field_1064, "Netherite", null, 10.0),
        ALL(class_124.field_1068, "All Ores", null, 24.0),
        CUSTOM(class_124.field_1054, "Custom", null, 24.0);

        final class_124 color;
        final String name;
        final class_6862<class_2248> tag;
        final double budget;

        private DetectMode(class_124 color, String name, class_6862<class_2248> tag, double budget) {
            this.color = color;
            this.name = name;
            this.tag = tag;
            this.budget = budget;
        }
    }
}

