/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding.items.custom;

import com.simplebuilding.enchantment.ModEnchantments;
import com.simplebuilding.items.custom.ChiselItem;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9886;

public class SledgehammerItem
extends class_1792 {
    public static final int STONE_ATTACK_DAMAGE = 4;
    public static final int COPPER_ATTACK_DAMAGE = 4;
    public static final int IRON_ATTACK_DAMAGE = 6;
    public static final int GOLD_ATTACK_DAMAGE = 5;
    public static final int DIAMOND_ATTACK_DAMAGE = 7;
    public static final int NETHERITE_ATTACK_DAMAGE = 8;
    public static final float ATTACK_SPEED_OFFSET = 0.4f;
    public static final float STONE_ATTACK_SPEED = -3.4f;
    public static final float COPPER_ATTACK_SPEED = -3.2f;
    public static final float IRON_ATTACK_SPEED = -3.4f;
    public static final float GOLD_ATTACK_SPEED = -3.2f;
    public static final float DIAMOND_ATTACK_SPEED = -3.2f;
    public static final float NETHERITE_ATTACK_SPEED = -3.0f;
    public static final int BASE_DURABILITY_MULTIPLIER = 4;
    public static final int DURABILITY_STONE_SLEDGEHAMMER = 760;
    public static final int DURABILITY_COPPER_SLEDGEHAMMER = 760;
    public static final int DURABILITY_IRON_SLEDGEHAMMER = 1000;
    public static final int DURABILITY_GOLD_SLEDGEHAMMER = 128;
    public static final int DURABILITY_DIAMOND_SLEDGEHAMMER = 6244;
    public static final int DURABILITY_NETHERITE_SLEDGEHAMMER = 8124;
    private final class_9886 material;

    public SledgehammerItem(class_9886 material, float attackDamage, float attackSpeed, int durability, class_1792.class_1793 settings) {
        super(settings.method_66330(material, attackDamage, attackSpeed).method_7895(durability));
        this.material = material;
    }

    public class_9886 getMaterial() {
        return this.material;
    }

    public float method_58404(class_1799 stack, class_2680 state) {
        float baseSpeed = super.method_58404(stack, state);
        if (baseSpeed > 1.0f) {
            int blockCount = SledgehammerItem.getBlockCountForSpeed(stack);
            float cappedCount = Math.min(blockCount, 25);
            float speedMultiplier = 1.25f + (cappedCount - 1.0f) / 24.0f * 0.6f;
            return baseSpeed * speedMultiplier;
        }
        return baseSpeed;
    }

    public static int getBlockCountForSpeed(class_1799 stack) {
        class_9304 enchantments = (class_9304)stack.method_58694(class_9334.field_49633);
        if (enchantments == null) {
            return 9;
        }
        boolean hasRadius = false;
        boolean hasBreakThrough = false;
        for (Object2IntMap.Entry entry : enchantments.method_57539()) {
            if (((class_6880)entry.getKey()).method_40225(ModEnchantments.RADIUS)) {
                hasRadius = true;
            }
            if (!((class_6880)entry.getKey()).method_40225(ModEnchantments.BREAK_THROUGH)) continue;
            hasBreakThrough = true;
        }
        int blockCount = 9;
        if (hasRadius) {
            blockCount = 25;
        }
        if (hasBreakThrough) {
            blockCount *= 2;
        }
        return blockCount;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();
        class_1799 stack = context.method_8041();
        class_2680 state = world.method_8320(pos);
        class_243 relativeHit = context.method_17698().method_1020(class_243.method_24954((class_2382)pos));
        class_2680 transformState = this.getTransformationState(state, context.method_8038(), relativeHit, player, stack);
        if (transformState != null) {
            if (player != null) {
                player.method_6019(context.method_20287());
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    public boolean method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        return false;
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        class_243 relativeHit;
        class_2350 side;
        class_2338 pos;
        class_2680 state;
        class_2680 newState;
        if (!(user instanceof class_1657)) {
            return stack;
        }
        class_1657 player = (class_1657)user;
        class_239 hitResult = player.method_5745(5.0, 0.0f, false);
        if (hitResult.method_17783() == class_239.class_240.field_1332 && (newState = this.getTransformationState(state = world.method_8320(pos = ((class_3965)hitResult).method_17777()), side = ((class_3965)hitResult).method_17780(), relativeHit = hitResult.method_17784().method_1020(class_243.method_24954((class_2382)pos)), player, stack)) != null && !world.method_8608()) {
            world.method_8501(pos, newState);
            world.method_8396(null, pos, state.method_26231().method_10595(), class_3419.field_15245, 1.0f, 0.8f);
            ((class_3218)world).method_65096((class_2394)new class_2388(class_2398.field_11217, state), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 20, 0.25, 0.25, 0.25, 0.05);
            if (!player.method_68878()) {
                boolean isReverse = player.method_5715() && this.hasConstructorsTouch(stack, world);
                int damage = isReverse ? 2 : 1;
                stack.method_7970(damage, (class_1309)player, class_1304.field_6173);
            }
        }
        return stack;
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        Optional efficiencyEntry;
        float baseTime = 20.0f;
        int efficiencyLevel = 0;
        Optional registry = user.method_56673().method_46759(class_7924.field_41265);
        if (registry.isPresent() && (efficiencyEntry = ((class_2378)registry.get()).method_46746(class_1893.field_9131)).isPresent()) {
            efficiencyLevel = class_1890.method_8225((class_6880)((class_6880)efficiencyEntry.get()), (class_1799)stack);
        }
        float speed = this.getMaterial().comp_2932();
        float factor = speed + (float)efficiencyLevel * 5.0f;
        int time = (int)(baseTime * 10.0f / factor);
        return Math.clamp((long)time, 4, 40);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    private boolean hasConstructorsTouch(class_1799 stack, class_1937 world) {
        Optional entry;
        Optional registry = world.method_30349().method_46759(class_7924.field_41265);
        if (registry.isPresent() && (entry = ((class_2378)registry.get()).method_46746(ModEnchantments.CONSTRUCTORS_TOUCH)).isPresent()) {
            return class_1890.method_8225((class_6880)((class_6880)entry.get()), (class_1799)stack) > 0;
        }
        return false;
    }

    public class_2680 getTransformationState(class_2680 state, class_2350 side, class_243 hit, class_1657 player, class_1799 stack) {
        class_2248 block = state.method_26204();
        class_1937 world = player.method_73183();
        if (player.method_5715()) {
            String baseName;
            String id;
            if (!this.hasConstructorsTouch(stack, world)) {
                return null;
            }
            if (block instanceof class_2482) {
                id = class_7923.field_41175.method_10221((Object)block).method_12832();
                baseName = id.replace("_slab", "");
                Optional stairs = class_7923.field_41175.method_17966(class_2960.method_60655((String)class_7923.field_41175.method_10221((Object)block).method_12836(), (String)(baseName + "_stairs")));
                if (stairs.isPresent()) {
                    class_2680 stairState = ((class_2248)stairs.get()).method_9564();
                    return ChiselItem.applyIntuitiveOrientation(stairState, side, hit, player);
                }
            }
            if (block instanceof class_2510) {
                id = class_7923.field_41175.method_10221((Object)block).method_12832();
                baseName = id.replace("_stairs", "");
                Optional fullBlock = class_7923.field_41175.method_17966(class_2960.method_60655((String)class_7923.field_41175.method_10221((Object)block).method_12836(), (String)baseName));
                if (fullBlock.isEmpty()) {
                    fullBlock = class_7923.field_41175.method_17966(class_2960.method_60655((String)class_7923.field_41175.method_10221((Object)block).method_12836(), (String)(baseName + "s")));
                }
                if (fullBlock.isEmpty()) {
                    fullBlock = class_7923.field_41175.method_17966(class_2960.method_60655((String)class_7923.field_41175.method_10221((Object)block).method_12836(), (String)(baseName + "_planks")));
                }
                if (fullBlock.isPresent()) {
                    return ((class_2248)fullBlock.get()).method_9564();
                }
            }
        } else {
            String id;
            if (state.method_26234(null, null)) {
                id = class_7923.field_41175.method_10221((Object)block).method_12832();
                Optional stairs = class_7923.field_41175.method_17966(class_2960.method_60655((String)class_7923.field_41175.method_10221((Object)block).method_12836(), (String)(id + "_stairs")));
                if (stairs.isPresent()) {
                    class_2680 stairState = ((class_2248)stairs.get()).method_9564();
                    return ChiselItem.applyIntuitiveOrientation(stairState, side, hit, player);
                }
            }
            if (block instanceof class_2510) {
                id = class_7923.field_41175.method_10221((Object)block).method_12832();
                String baseName = id.replace("_stairs", "");
                Optional slab = class_7923.field_41175.method_17966(class_2960.method_60655((String)class_7923.field_41175.method_10221((Object)block).method_12836(), (String)(baseName + "_slab")));
                if (slab.isPresent()) {
                    class_2680 slabState = ((class_2248)slab.get()).method_9564();
                    return ChiselItem.applyIntuitiveOrientation(slabState, side, hit, player);
                }
            }
        }
        return null;
    }

    public static List<class_2338> getBlocksToBeDestroyed(int baseRange, class_2338 initialPos, class_1657 player) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        class_1937 world = player.method_73183();
        class_1799 stack = player.method_6047();
        class_2680 initialState = world.method_8320(initialPos);
        if (!stack.method_7909().method_58405(stack, initialState)) {
            return positions;
        }
        boolean isPlayerSneaking = player.method_5715();
        class_2350 sideHit = SledgehammerItem.getHitSideFromPlayer(player);
        class_5455 registry = world.method_30349();
        class_2378 enchantLookup = registry.method_30530(class_7924.field_41265);
        Optional radiusKey = enchantLookup.method_46746(ModEnchantments.RADIUS);
        int range = baseRange + (!isPlayerSneaking && radiusKey.isPresent() ? class_1890.method_8225((class_6880)((class_6880)radiusKey.get()), (class_1799)stack) : 0);
        Optional breakThroughKey = enchantLookup.method_46746(ModEnchantments.BREAK_THROUGH);
        int depth = !isPlayerSneaking && breakThroughKey.isPresent() ? class_1890.method_8225((class_6880)((class_6880)breakThroughKey.get()), (class_1799)stack) : 0;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = 0; z <= depth; ++z) {
                    if (x == 0 && y == 0 && z == 0) {
                        positions.add(initialPos);
                        continue;
                    }
                    class_2338 targetPos = null;
                    if (sideHit == class_2350.field_11033 || sideHit == class_2350.field_11036) {
                        depthOffset = sideHit == class_2350.field_11036 ? -z : z;
                        targetPos = initialPos.method_10069(x, depthOffset, y);
                    } else if (sideHit == class_2350.field_11043 || sideHit == class_2350.field_11035) {
                        depthOffset = sideHit == class_2350.field_11043 ? z : -z;
                        targetPos = initialPos.method_10069(x, y, depthOffset);
                    } else if (sideHit == class_2350.field_11034 || sideHit == class_2350.field_11039) {
                        depthOffset = sideHit == class_2350.field_11039 ? z : -z;
                        targetPos = initialPos.method_10069(depthOffset, y, x);
                    }
                    if (targetPos == null) continue;
                    positions.add(targetPos);
                }
            }
        }
        return positions;
    }

    private static class_2350 getHitSideFromPlayer(class_1657 player) {
        float pitch = player.method_36455();
        if (pitch < -60.0f) {
            return class_2350.field_11033;
        }
        if (pitch > 60.0f) {
            return class_2350.field_11036;
        }
        return player.method_5735().method_10153();
    }
}

