/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding.mixin;

import com.mojang.datafixers.util.Pair;
import com.simplebuilding.enchantment.ModEnchantments;
import com.simplebuilding.items.custom.SledgehammerItem;
import com.simplebuilding.util.StructureConfig;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3544;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_4208;
import net.minecraft.class_4861;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7045;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8047;
import net.minecraft.class_9290;
import net.minecraft.class_9291;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1706.class})
public abstract class AnvilScreenHandlerMixin
extends class_4861 {
    @Shadow
    private int field_7776;
    @Shadow
    @Final
    private class_3915 field_7770;
    @Shadow
    @Nullable
    private String field_7774;
    @Unique
    private static final class_6862<class_3195> ANCIENT_CITY_TAG = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60655((String)"minecraft", (String)"ancient_city"));
    @Unique
    private static final class_6862<class_3195> BASTION_TAG = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60655((String)"minecraft", (String)"bastion_remnant"));
    @Unique
    private static final class_6862<class_3195> FORTRESS_TAG = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60655((String)"minecraft", (String)"fortress"));
    @Unique
    private static final class_6862<class_3195> OUTPOST_TAG = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60655((String)"minecraft", (String)"pillager_outpost"));
    @Unique
    private static final class_6862<class_3195> END_CITY_TAG = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60655((String)"minecraft", (String)"end_city"));
    @Unique
    private static final class_6862<class_3195> MINESHAFT_TAG = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60655((String)"minecraft", (String)"mineshaft"));
    @Unique
    private static final class_6862<class_3195> VILLAGE_TAG = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60655((String)"minecraft", (String)"village"));
    @Unique
    private static final class_6862<class_3195> SHIPWRECK_TAG = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60655((String)"minecraft", (String)"shipwreck"));
    @Unique
    private static final class_6862<class_3195> IGLOO_TAG = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60655((String)"minecraft", (String)"igloo"));
    @Unique
    private static final class_6862<class_3195> DESERT_PYRAMID_TAG = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60655((String)"minecraft", (String)"desert_pyramid"));
    @Unique
    private static final class_6862<class_3195> JUNGLE_PYRAMID_TAG = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60655((String)"minecraft", (String)"jungle_pyramid"));
    @Unique
    private static final class_6862<class_3195> SWAMP_HUT_TAG = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60655((String)"minecraft", (String)"swamp_hut"));
    @Unique
    private static final class_6862<class_3195> STRONGHOLD_TAG = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60655((String)"minecraft", (String)"stronghold"));
    @Unique
    private static final Map<class_1792, StructureConfig> STRUCTURE_RECIPES = Map.ofEntries(Map.entry(class_1802.field_38746, new StructureConfig(ANCIENT_CITY_TAG, "Ancient City Locator", class_124.field_1062)), Map.entry(class_1802.field_8288, new StructureConfig((class_6862<class_3195>)class_7045.field_37042, "Mansion Seeker", class_124.field_1077)), Map.entry(class_1802.field_8207, new StructureConfig((class_6862<class_3195>)class_7045.field_37043, "Monument Tracker", class_124.field_1075)), Map.entry(class_1802.field_8894, new StructureConfig(FORTRESS_TAG, "Fortress Finder", class_124.field_1061)), Map.entry(class_1802.field_8494, new StructureConfig(BASTION_TAG, "Bastion Compass", class_124.field_1065)), Map.entry(class_1802.field_47315, new StructureConfig((class_6862<class_3195>)class_7045.field_49958, "Trial Key Compass", class_124.field_1076)), Map.entry(class_1802.field_50140, new StructureConfig(OUTPOST_TAG, "Outpost Tracker", class_124.field_1080)), Map.entry(class_1802.field_8233, new StructureConfig(END_CITY_TAG, "End City Compass", class_124.field_1076)), Map.entry(class_1802.field_8129, new StructureConfig(MINESHAFT_TAG, "Mineshaft Detector", class_124.field_1063)), Map.entry(class_1802.field_8687, new StructureConfig(VILLAGE_TAG, "Village Finder", class_124.field_1060)), Map.entry(class_1802.field_8662, new StructureConfig(SHIPWRECK_TAG, "Shipwreck Sensor", class_124.field_1078)), Map.entry(class_1802.field_8246, new StructureConfig(IGLOO_TAG, "Igloo Compass", class_124.field_1068)), Map.entry(class_1802.field_8552, new StructureConfig(DESERT_PYRAMID_TAG, "Desert Pyramid Compass", class_124.field_1065)), Map.entry(class_1802.field_20392, new StructureConfig(JUNGLE_PYRAMID_TAG, "Jungle Temple Compass", class_124.field_1077)), Map.entry(class_1802.field_8777, new StructureConfig(SWAMP_HUT_TAG, "Witch Hut Tracker", class_124.field_1064)), Map.entry(class_1802.field_8449, new StructureConfig(STRONGHOLD_TAG, "Stronghold Locator", class_124.field_1064)));

    public AnvilScreenHandlerMixin(@Nullable class_3917<?> type, int syncId, class_1661 playerInventory, class_3914 context, class_8047 forgingSlotsManager) {
        super(type, syncId, playerInventory, context, forgingSlotsManager);
    }

    @Inject(method={"method_24928"}, at={@At(value="HEAD")}, cancellable=true)
    private void updateResultHead(CallbackInfo ci) {
        class_1799 leftStack = this.field_22480.method_5438(0);
        class_1799 rightStack = this.field_22480.method_5438(1);
        if (leftStack.method_7960()) {
            return;
        }
        if (leftStack.method_7909() instanceof SledgehammerItem) {
            if (rightStack.method_7909() instanceof SledgehammerItem) {
                int leftDurability = leftStack.method_7936() - leftStack.method_7919();
                int rightDurability = rightStack.method_7936() - rightStack.method_7919();
                int bonus = (int)((float)leftStack.method_7936() * 0.12f);
                int combinedDurability = leftDurability + rightDurability + bonus;
                int newDamage = leftStack.method_7936() - combinedDurability;
                if (newDamage < 0) {
                    newDamage = 0;
                }
                class_1799 result = leftStack.method_7972();
                result.method_7974(newDamage);
                result.method_57379(class_9334.field_49639, (Object)0);
                this.handleRenaming(leftStack, result);
                this.field_22479.method_5447(0, result);
                this.field_7770.method_17404(1);
                this.field_7776 = 1;
                ci.cancel();
            } else if (leftStack.method_7986() && leftStack.method_61655(rightStack)) {
                int materialsUsed;
                class_1799 result = leftStack.method_7972();
                int repairPerItem = result.method_7936() / 11;
                if (repairPerItem <= 0) {
                    repairPerItem = 1;
                }
                int damage = result.method_7919();
                int materialsAvailable = rightStack.method_7947();
                for (materialsUsed = 0; damage > 0 && materialsUsed < materialsAvailable; damage -= repairPerItem, ++materialsUsed) {
                }
                if (damage < 0) {
                    damage = 0;
                }
                result.method_7974(damage);
                this.field_7776 = materialsUsed;
                int cost = materialsUsed;
                if (this.handleRenaming(leftStack, result)) {
                    ++cost;
                }
                result.method_57379(class_9334.field_49639, (Object)0);
                if (cost <= 0) {
                    cost = 1;
                }
                this.field_7770.method_17404(Math.min(cost, 39));
                this.field_22479.method_5447(0, result);
                ci.cancel();
            }
        }
    }

    @Inject(method={"method_24928"}, at={@At(value="RETURN")})
    private void applyAnvilTweaks(CallbackInfo ci) {
        class_1799 outputStack = this.field_22479.method_5438(0);
        if (outputStack.method_7960()) {
            return;
        }
        if (outputStack.method_7909() instanceof SledgehammerItem) {
            outputStack.method_57379(class_9334.field_49639, (Object)0);
            if (this.field_7770.method_17407() >= 40) {
                this.field_7770.method_17404(39);
            }
        }
        class_5455 registryManager = this.field_22482.method_73183().method_30349();
        class_6880<class_1887> colorPaletteEntry = this.getEnchantment((class_7225.class_7874)registryManager, ModEnchantments.COLOR_PALETTE);
        class_6880<class_1887> masterBuilderEntry = this.getEnchantment((class_7225.class_7874)registryManager, ModEnchantments.MASTER_BUILDER);
        if (colorPaletteEntry != null && masterBuilderEntry != null) {
            int colorPaletteLevel = class_1890.method_8225(colorPaletteEntry, (class_1799)outputStack);
            int masterBuilderLevel = class_1890.method_8225(masterBuilderEntry, (class_1799)outputStack);
            if (colorPaletteLevel > 0 && masterBuilderLevel <= 0) {
                this.field_22479.method_5447(0, class_1799.field_8037);
                this.field_7770.method_17404(0);
            }
        }
    }

    @Unique
    private boolean handleRenaming(class_1799 original, class_1799 result) {
        boolean renamed = false;
        if (this.field_7774 != null && !class_3544.method_57181((String)this.field_7774)) {
            if (!this.field_7774.equals(original.method_7964().getString())) {
                result.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)this.field_7774));
                renamed = true;
            }
        } else if (original.method_57826(class_9334.field_49631)) {
            result.method_57381(class_9334.field_49631);
            renamed = true;
        }
        return renamed;
    }

    @Unique
    private class_6880<class_1887> getEnchantment(class_7225.class_7874 registry, class_5321<class_1887> key) {
        Optional optional = registry.method_46762(class_7924.field_41265).method_46746(key);
        return optional.orElse(null);
    }

    @Inject(method={"method_24928"}, at={@At(value="HEAD")}, cancellable=true)
    private void simplebuilding$createStructureCompass(CallbackInfo ci) {
        class_1799 leftStack = this.field_22480.method_5438(0);
        class_1799 rightStack = this.field_22480.method_5438(1);
        if (!leftStack.method_31574(class_1802.field_8251)) {
            return;
        }
        if (STRUCTURE_RECIPES.containsKey(rightStack.method_7909())) {
            class_1937 class_19372 = this.field_22482.method_73183();
            if (class_19372 instanceof class_3218) {
                Pair foundPair;
                class_3218 serverWorld = (class_3218)class_19372;
                StructureConfig config = STRUCTURE_RECIPES.get(rightStack.method_7909());
                Optional structureListOptional = serverWorld.method_27056().method_41036().method_30530(class_7924.field_41246).method_46733(config.tag());
                class_2338 foundPos = null;
                if (structureListOptional.isPresent() && (foundPair = serverWorld.method_14178().method_12129().method_12103(serverWorld, (class_6885)structureListOptional.get(), this.field_22482.method_24515(), 300, false)) != null) {
                    foundPos = (class_2338)foundPair.getFirst();
                }
                if (foundPos != null) {
                    class_1799 outputStack = new class_1799((class_1935)class_1802.field_8251);
                    class_4208 targetPos = class_4208.method_19443((class_5321)serverWorld.method_27983(), foundPos);
                    outputStack.method_57379(class_9334.field_49614, (Object)new class_9291(Optional.of(targetPos), true));
                    if (this.field_7774 != null && !this.field_7774.isBlank()) {
                        outputStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)this.field_7774));
                    } else {
                        outputStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)config.name()).method_27692(config.color()));
                    }
                    outputStack.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(class_2561.method_43470((String)("Dimension: " + serverWorld.method_27983().method_29177().method_12832())).method_27692(class_124.field_1063))));
                    outputStack.method_57379(class_9334.field_49641, (Object)true);
                    this.field_22479.method_5447(0, outputStack);
                    this.field_7770.method_17404(29);
                    this.field_7776 = 1;
                } else {
                    class_1799 failStack = new class_1799((class_1935)class_1802.field_8251);
                    failStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Kein Signal in Reichweite").method_27692(class_124.field_1061));
                    failStack.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(class_2561.method_43470((String)"Struktur zu weit entfernt oder").method_27692(class_124.field_1080), class_2561.method_43470((String)"falsche Dimension.").method_27692(class_124.field_1080))));
                    this.field_22479.method_5447(0, failStack);
                    this.field_7770.method_17404(0);
                    this.field_7776 = 0;
                }
                ci.cancel();
            } else {
                ci.cancel();
            }
        }
    }
}

