/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding.mixin.client;

import com.simplebuilding.config.SimplebuildingConfig;
import com.simplebuilding.items.custom.ChiselItem;
import com.simplebuilding.items.custom.SledgehammerItem;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_742;
import net.minecraft.class_759;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_759.class})
public class HeldItemRendererMixin {
    @Shadow
    @Final
    private class_310 field_4050;
    @Unique
    private float mainHandChiselProgress = 0.0f;
    @Unique
    private float offHandChiselProgress = 0.0f;

    @Inject(method={"method_3228"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_759;method_3233(Lnet/minecraft/class_1309;Lnet/minecraft/class_1799;Lnet/minecraft/class_811;Lnet/minecraft/class_4587;Lnet/minecraft/class_11659;I)V")})
    private void onRenderFirstPersonItem(class_742 player, float tickProgress, float pitch, class_1268 hand, float swingProgress, class_1799 item, float equipProgress, class_4587 matrices, class_11659 orderedRenderCommandQueue, int light, CallbackInfo ci) {
        class_239 hit;
        SimplebuildingConfig config = (SimplebuildingConfig)AutoConfig.getConfigHolder(SimplebuildingConfig.class).getConfig();
        boolean animationsEnabled = config.tools.enableToolAnimations && config.tools.enableChiselAnimation;
        float targetProgress = 0.0f;
        if (animationsEnabled && (hit = this.field_4050.field_1765) instanceof class_3965) {
            class_3965 blockHit = (class_3965)hit;
            class_1792 class_17922 = item.method_7909();
            if (class_17922 instanceof ChiselItem) {
                ChiselItem chiselItem = (ChiselItem)class_17922;
                if (chiselItem.canChisel((class_1937)this.field_4050.field_1687, blockHit.method_17777(), item, (class_1657)player)) {
                    targetProgress = 1.0f;
                }
            } else {
                class_17922 = item.method_7909();
                if (class_17922 instanceof SledgehammerItem) {
                    SledgehammerItem sledgehammerItem = (SledgehammerItem)class_17922;
                    class_243 relativeHit = blockHit.method_17784().method_1020(class_243.method_24954((class_2382)blockHit.method_17777()));
                    if (sledgehammerItem.getTransformationState(this.field_4050.field_1687.method_8320(blockHit.method_17777()), blockHit.method_17780(), relativeHit, (class_1657)player, item) != null) {
                        targetProgress = 1.0f;
                    }
                }
            }
        }
        float smoothingSpeed = 0.15f;
        if (hand == class_1268.field_5808) {
            this.mainHandChiselProgress += (targetProgress - this.mainHandChiselProgress) * smoothingSpeed;
            if (this.mainHandChiselProgress > 0.001f) {
                this.applyChiselTransform(matrices, this.mainHandChiselProgress);
            }
        } else {
            this.offHandChiselProgress += (targetProgress - this.offHandChiselProgress) * smoothingSpeed;
            if (this.offHandChiselProgress > 0.001f) {
                this.applyChiselTransform(matrices, this.offHandChiselProgress);
            }
        }
    }

    @Unique
    private void applyChiselTransform(class_4587 matrices, float progress) {
        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-15.0f * progress));
        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-10.0f * progress));
        matrices.method_22904(0.05 * (double)progress, 0.05 * (double)progress, 0.05 * (double)progress);
    }
}

