/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding.mixin.client;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.simplebuilding.client.render.BlockHighlightRenderer;
import com.simplebuilding.enchantment.ModEnchantments;
import com.simplebuilding.items.custom.SledgehammerItem;
import com.simplebuilding.util.MiningUtils;
import com.simplebuilding.util.SledgehammerUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1088;
import net.minecraft.class_11658;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3191;
import net.minecraft.class_3489;
import net.minecraft.class_4184;
import net.minecraft.class_4583;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_761;
import net.minecraft.class_7924;
import net.minecraft.class_9779;
import net.minecraft.class_9922;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_761.class})
public class WorldRendererMixin {
    @Shadow
    @Final
    private Long2ObjectMap<SortedSet<class_3191>> field_20950;
    @Shadow
    private class_638 field_4085;
    @Unique
    private class_2338 simplebuilding$lastMainPos = null;
    @Unique
    private List<class_2338> simplebuilding$cachedConnectedBlocks = new ArrayList<class_2338>();
    @Unique
    private class_1799 simplebuilding$lastToolStack = class_1799.field_8037;

    @Inject(method={"method_22710"}, at={@At(value="RETURN")})
    private void onRender(class_9922 allocator, class_9779 tickCounter, boolean renderBlockOutline, class_4184 camera, Matrix4f positionMatrix, Matrix4f matrix4f, Matrix4f projectionMatrix, GpuBufferSlice fogBuffer, Vector4f fogColor, boolean renderSky, CallbackInfo ci) {
        BlockHighlightRenderer.render(positionMatrix, camera);
    }

    @Inject(method={"method_62206"}, at={@At(value="TAIL")})
    private void renderAdditionalBlockDamage(class_4587 matrices, class_4597.class_4598 vertexConsumers, class_11658 renderStates, CallbackInfo ci) {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null || this.field_4085 == null) {
            return;
        }
        class_1799 stack = player.method_6047();
        class_5455 registryManager = this.field_4085.method_30349();
        class_2378 enchantLookup = registryManager.method_30530(class_7924.field_41265);
        Optional stripMinerKey = enchantLookup.method_46746(ModEnchantments.STRIP_MINER);
        Optional veinMinerKey = enchantLookup.method_46746(ModEnchantments.VEIN_MINER);
        boolean hasStripMiner = stripMinerKey.isPresent() && class_1890.method_8225((class_6880)((class_6880)stripMinerKey.get()), (class_1799)stack) > 0;
        boolean hasVeinMiner = veinMinerKey.isPresent() && class_1890.method_8225((class_6880)((class_6880)veinMinerKey.get()), (class_1799)stack) > 0;
        boolean isSledgehammer = stack.method_7909() instanceof SledgehammerItem;
        if (!(isSledgehammer || hasStripMiner || hasVeinMiner)) {
            this.simplebuilding$lastMainPos = null;
            return;
        }
        boolean foundActiveBreak = false;
        for (Long2ObjectMap.Entry entry : this.field_20950.long2ObjectEntrySet()) {
            for (class_3191 info : (SortedSet)entry.getValue()) {
                List<class_2338> connectedBlocks;
                boolean isCacheValid;
                if (info.method_34868() != player.method_5628()) continue;
                class_2338 mainPos = info.method_13991();
                int stage = info.method_13988();
                if (stage < 0 || stage >= 10) continue;
                foundActiveBreak = true;
                class_2680 mainState = this.field_4085.method_8320(mainPos);
                boolean bl = isCacheValid = mainPos.equals((Object)this.simplebuilding$lastMainPos) && class_1799.method_7984((class_1799)stack, (class_1799)this.simplebuilding$lastToolStack);
                if (isCacheValid) {
                    connectedBlocks = this.simplebuilding$cachedConnectedBlocks;
                } else {
                    connectedBlocks = new ArrayList<class_2338>();
                    if (isSledgehammer) {
                        connectedBlocks.addAll(SledgehammerItem.getBlocksToBeDestroyed(1, mainPos, (class_1657)player));
                    } else if (hasStripMiner && stack.method_31573(class_3489.field_42614) && player.method_5715()) {
                        int level = class_1890.method_8225((class_6880)((class_6880)stripMinerKey.get()), (class_1799)stack);
                        connectedBlocks.addAll(MiningUtils.getStripMinerBlocks((class_1937)this.field_4085, mainPos, (class_1657)player, stack, level));
                    } else if (hasVeinMiner && (stack.method_31573(class_3489.field_42614) || stack.method_31573(class_3489.field_42612)) && player.method_5715()) {
                        int level = class_1890.method_8225((class_6880)((class_6880)veinMinerKey.get()), (class_1799)stack);
                        connectedBlocks.addAll(MiningUtils.getVeinMinerBlocks((class_1937)this.field_4085, mainPos, mainState, level, stack));
                    }
                    this.simplebuilding$lastMainPos = mainPos;
                    this.simplebuilding$lastToolStack = stack;
                    this.simplebuilding$cachedConnectedBlocks = connectedBlocks;
                }
                class_243 cameraPos = renderStates.field_63082.field_63078;
                double camX = cameraPos.field_1352;
                double camY = cameraPos.field_1351;
                double camZ = cameraPos.field_1350;
                for (class_2338 targetPos : connectedBlocks) {
                    class_2680 state;
                    if (targetPos.equals((Object)mainPos) || isSledgehammer && !SledgehammerUtils.shouldBreak((class_1937)this.field_4085, targetPos, mainPos, stack) || !isSledgehammer && this.field_4085.method_8320(targetPos).method_26215() || (state = this.field_4085.method_8320(targetPos)).method_26215()) continue;
                    matrices.method_22903();
                    matrices.method_22904((double)targetPos.method_10263() - camX, (double)targetPos.method_10264() - camY, (double)targetPos.method_10260() - camZ);
                    class_1921 layer = (class_1921)class_1088.field_21772.get(stage);
                    class_4588 consumer = vertexConsumers.method_73477(layer);
                    class_4583 overlayConsumer = new class_4583(consumer, matrices.method_23760(), 1.0f);
                    client.method_1541().method_23071(state, targetPos, (class_1920)this.field_4085, matrices, (class_4588)overlayConsumer);
                    matrices.method_22909();
                }
            }
        }
        if (!foundActiveBreak) {
            this.simplebuilding$lastMainPos = null;
            this.simplebuilding$cachedConnectedBlocks = Collections.emptyList();
        }
    }
}

