/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3489;

public class MiningUtils {
    public static List<class_2338> getStripMinerBlocks(class_1937 world, class_2338 startPos, class_1657 player, class_1799 stack, int level) {
        class_2338 targetPos;
        class_2680 targetState;
        ArrayList<class_2338> found = new ArrayList<class_2338>();
        int depth = level == 3 ? 4 : level;
        class_2350 miningDirection = MiningUtils.getMiningDirection(player);
        for (int i = 1; i <= depth && !(targetState = world.method_8320(targetPos = startPos.method_10079(miningDirection, i))).method_26215() && !(targetState.method_26214((class_1922)world, targetPos) < 0.0f) && stack.method_7909().method_58405(stack, targetState); ++i) {
            found.add(targetPos);
        }
        return found;
    }

    public static List<class_2338> getVeinMinerBlocks(class_1937 world, class_2338 startPos, class_2680 targetState, int level, class_1799 stack) {
        boolean isPickaxe = stack.method_31573(class_3489.field_42614);
        boolean isAxe = stack.method_31573(class_3489.field_42612);
        if (isPickaxe && !MiningUtils.isOre(targetState)) {
            return Collections.emptyList();
        }
        if (isAxe && !targetState.method_26164(class_3481.field_15475)) {
            return Collections.emptyList();
        }
        int maxBlocks = switch (level) {
            case 1 -> 3;
            case 2 -> 6;
            case 3 -> 9;
            case 4 -> 12;
            case 5 -> 18;
            default -> 18;
        };
        ArrayList<class_2338> found = new ArrayList<class_2338>();
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        queue.add(startPos);
        visited.add(startPos);
        found.add(startPos);
        block7: while (!queue.isEmpty() && found.size() < maxBlocks) {
            class_2338 current = (class_2338)queue.poll();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        class_2338 neighbor;
                        if (x == 0 && y == 0 && z == 0 || visited.contains(neighbor = current.method_10069(x, y, z))) continue;
                        visited.add(neighbor);
                        class_2680 neighborState = world.method_8320(neighbor);
                        if (neighborState.method_26204() != targetState.method_26204()) continue;
                        queue.add(neighbor);
                        found.add(neighbor);
                        if (found.size() >= maxBlocks) break;
                    }
                    if (found.size() >= maxBlocks) break;
                }
                if (found.size() >= maxBlocks) continue block7;
            }
        }
        found.remove(startPos);
        return found;
    }

    public static class_2350 getMiningDirection(class_1657 player) {
        float pitch = player.method_36455();
        if (pitch < -60.0f) {
            return class_2350.field_11036;
        }
        if (pitch > 60.0f) {
            return class_2350.field_11033;
        }
        return player.method_5735();
    }

    public static boolean isOre(class_2680 state) {
        return state.method_26164(class_3481.field_29193) || state.method_26164(class_3481.field_28988) || state.method_26164(class_3481.field_29195) || state.method_26164(class_3481.field_23062) || state.method_26164(class_3481.field_28990) || state.method_26164(class_3481.field_28991) || state.method_26164(class_3481.field_28989) || state.method_26164(class_3481.field_29194) || state.method_27852(class_2246.field_10213) || state.method_27852(class_2246.field_22109);
    }
}

