/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding.util;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simplebuilding.enchantment.ModEnchantments;
import com.simplebuilding.items.ModItems;
import com.simplebuilding.items.custom.SledgehammerItem;
import com.simplebuilding.networking.DoubleJumpPayload;
import com.simplebuilding.recipe.ReinforcedBundleRecipe;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8957;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class ModRegistries {
    public static final class_1865<ReinforcedBundleRecipe> REINFORCED_BUNDLE_SERIALIZER = new class_1865<ReinforcedBundleRecipe>(){
        private static final MapCodec<ReinforcedBundleRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(class_1869::method_8112), (App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(class_1869::method_45441), (App)class_8957.field_47321.forGetter(recipe -> recipe.getRaw()), (App)class_1799.field_24671.fieldOf("result").forGetter(ReinforcedBundleRecipe::getResultStack)).apply((Applicative)instance, ReinforcedBundleRecipe::new));
        public static final class_9139<class_9129, ReinforcedBundleRecipe> PACKET_CODEC = class_9139.method_56437((buf, recipe) -> {
            buf.method_10814(recipe.method_8112());
            buf.method_10817((Enum)recipe.method_45441());
            class_8957.field_48359.encode(buf, (Object)recipe.getRaw());
            class_1799.field_48349.encode(buf, (Object)recipe.getResultStack());
        }, buf -> new ReinforcedBundleRecipe(buf.method_19772(), (class_7710)buf.method_10818(class_7710.class), (class_8957)class_8957.field_48359.decode(buf), (class_1799)class_1799.field_48349.decode(buf)));

        public MapCodec<ReinforcedBundleRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, ReinforcedBundleRecipe> method_56104() {
            return PACKET_CODEC;
        }
    };

    public static void registerModStuffs() {
        ModRegistries.registerEvents();
        ModRegistries.registerNetworking();
        class_2378.method_10230((class_2378)class_7923.field_41189, (class_2960)class_2960.method_60655((String)"simplebuilding", (String)"reinforced_bundle"), REINFORCED_BUNDLE_SERIALIZER);
    }

    private static void registerNetworking() {
        PayloadTypeRegistry.playC2S().register(DoubleJumpPayload.ID, DoubleJumpPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(DoubleJumpPayload.ID, (payload, context) -> context.server().execute(() -> {
            class_3222 player = context.player();
            class_5455 registry = player.method_51469().method_30349();
            class_2378 enchantments = registry.method_30530(class_7924.field_41265);
            Optional doubleJump = enchantments.method_46746(ModEnchantments.DOUBLE_JUMP);
            if (doubleJump.isPresent()) {
                class_1799 bootStack = player.method_6118(class_1304.field_6166);
                if (class_1890.method_8225((class_6880)((class_6880)doubleJump.get()), (class_1799)bootStack) > 0) {
                    player.field_6017 = 0.0;
                    if (!player.method_68878()) {
                        bootStack.method_7970(1, (class_1309)player, class_1304.field_6166);
                    }
                }
            }
        }));
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_2680 state;
            class_1799 stack = player.method_5998(hand);
            if (stack.method_7909() instanceof SledgehammerItem && (state = world.method_8320(hitResult.method_17777())).method_27852(class_2246.field_10201)) {
                if (!world.method_8608()) {
                    int batch;
                    world.method_22352(hitResult.method_17777(), false);
                    for (int totalPebbles = 81; totalPebbles > 0; totalPebbles -= batch) {
                        batch = Math.min(totalPebbles, 64);
                        class_1542 itemEntity = new class_1542(world, hitResult.method_17784().field_1352, hitResult.method_17784().field_1351, hitResult.method_17784().field_1350, new class_1799((class_1935)ModItems.DIAMOND_PEBBLE, batch));
                        world.method_8649((class_1297)itemEntity);
                    }
                    world.method_8396(null, hitResult.method_17777(), class_3417.field_15044, class_3419.field_15245, 1.0f, 1.0f);
                    if (!player.method_68878()) {
                        stack.method_7970(1, (class_1309)player, class_1304.field_6173);
                    }
                }
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
    }

    private static void registerEvents() {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_1799 stack = player.method_5998(hand);
            class_5455 registry = world.method_30349();
            class_2378 enchantments = registry.method_30530(class_7924.field_41265);
            Optional constructorsTouch = enchantments.method_46746(ModEnchantments.CONSTRUCTORS_TOUCH);
            if (constructorsTouch.isPresent() && class_1890.method_8225((class_6880)((class_6880)constructorsTouch.get()), (class_1799)stack) > 0 && stack.method_31574(class_1802.field_8600)) {
                class_2680 state;
                Collection properties;
                if (!world.method_8608() && !(properties = (state = world.method_8320(hitResult.method_17777())).method_28501()).isEmpty()) {
                    class_2769 property = (class_2769)properties.iterator().next();
                    class_2680 newState = ModRegistries.cycleState(state, property, player.method_5715());
                    world.method_8652(hitResult.method_17777(), newState, 18);
                    player.method_7353(class_2561.method_30163((String)("\u00a77" + property.method_11899() + ": \u00a7f" + newState.method_11654(property).toString())), true);
                }
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
    }

    private static <T extends Comparable<T>> class_2680 cycleState(class_2680 state, class_2769<T> property, boolean inverse) {
        return (class_2680)state.method_11657(property, ModRegistries.cycle(property.method_11898(), state.method_11654(property), inverse));
    }

    private static <T> T cycle(Iterable<T> elements, T current, boolean inverse) {
        if (inverse) {
            return (T)Iterables.getLast(elements);
        }
        Iterator<T> it = elements.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(current) || !it.hasNext()) continue;
            return it.next();
        }
        return elements.iterator().next();
    }
}

