/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding;

import com.simplebuilding.component.ModDataComponentTypes;
import com.simplebuilding.config.SimplebuildingConfig;
import com.simplebuilding.datagen.ModLootTableProvider;
import com.simplebuilding.datagen.ModTradeOffers;
import com.simplebuilding.enchantment.ModEnchantmentEffects;
import com.simplebuilding.items.ModItemGroups;
import com.simplebuilding.items.ModItems;
import com.simplebuilding.items.custom.OctantItem;
import com.simplebuilding.util.ModRegistries;
import com.simplebuilding.util.SledgehammerUsageEvent;
import com.simplebuilding.util.StripMinerUsageEvent;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1269;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3468;
import net.minecraft.class_5556;
import net.minecraft.class_5620;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Simplebuilding
implements ModInitializer {
    public static final String MOD_ID = "simplebuilding";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"simplebuilding");
    private static SimplebuildingConfig CONFIG;

    public void onInitialize() {
        LOGGER.info("Starting Simplebuilding initialization...");
        AutoConfig.register(SimplebuildingConfig.class, GsonConfigSerializer::new);
        CONFIG = (SimplebuildingConfig)AutoConfig.getConfigHolder(SimplebuildingConfig.class).getConfig();
        ModItems.registerModItems();
        ModItemGroups.registerItemGroups();
        ModLootTableProvider.modifyLootTables();
        ModTradeOffers.registerModTradeOffers();
        ModDataComponentTypes.registerDataComponentTypes();
        ModEnchantmentEffects.registerEnchantmentEffects();
        ModRegistries.registerModStuffs();
        this.registerCauldronBehavior();
        PlayerBlockBreakEvents.BEFORE.register((Object)new SledgehammerUsageEvent());
        PlayerBlockBreakEvents.BEFORE.register((Object)new StripMinerUsageEvent());
    }

    private void registerCauldronBehavior() {
        class_5620 cleanRangefinder = (state, world, pos, player, hand, stack) -> {
            class_1792 item = stack.method_7909();
            if (!(item instanceof OctantItem) || item == ModItems.OCTANT) {
                return class_1269.field_5811;
            }
            if (!world.method_8608()) {
                class_1799 newStack = new class_1799((class_1935)ModItems.OCTANT);
                if (stack.method_57826(class_9334.field_49628)) {
                    newStack.method_57379(class_9334.field_49628, (Object)((class_9279)stack.method_58694(class_9334.field_49628)));
                }
                player.method_6122(hand, newStack);
                player.method_7281(class_3468.field_15382);
                class_5556.method_31650((class_2680)state, (class_1937)world, (class_2338)pos);
            }
            return class_1269.field_5812;
        };
        for (class_1767 color : class_1767.values()) {
            class_1792 coloredItem = ModItems.COLORED_OCTANT_ITEMS.get(color);
            if (coloredItem == null) continue;
            class_5620.field_27776.comp_1982().put(coloredItem, cleanRangefinder);
        }
    }

    public static SimplebuildingConfig getConfig() {
        return CONFIG;
    }
}

