/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding.client.gui;

import com.simplebuilding.items.ModItems;
import com.simplebuilding.items.custom.OctantItem;
import java.util.ArrayList;
import java.util.Objects;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9779;

public class SpeedometerHudOverlay
implements HudRenderCallback {
    private static final int BACKGROUND_COLOR = -267386864;
    private static final int BORDER_COLOR_START = -264306573;
    private static final int BORDER_COLOR_END = -266010527;
    private static final int COLOR_SPEED = 16744268;
    private static final int COLOR_STATS = -5592406;
    private static final int COLOR_DANGER = -43691;
    private static final int COLOR_SAFE = -11141291;
    private static double topSpeed = 0.0;
    private static double speedSum = 0.0;
    private static long tickCount = 0L;
    private static boolean wasHoldingSpeedometer = false;

    public void onHudRender(class_332 context, class_9779 tickCounter) {
        boolean hasSpeedometer;
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        class_1799 main = client.field_1724.method_6047();
        class_1799 off = client.field_1724.method_6079();
        boolean bl = hasSpeedometer = main.method_31574(ModItems.VELOCITY_GAUGE) || off.method_31574(ModItems.VELOCITY_GAUGE);
        if (!hasSpeedometer) {
            if (wasHoldingSpeedometer) {
                topSpeed = 0.0;
                speedSum = 0.0;
                tickCount = 0L;
                wasHoldingSpeedometer = false;
            }
            return;
        }
        wasHoldingSpeedometer = true;
        boolean hasOctant = main.method_7909() instanceof OctantItem || off.method_7909() instanceof OctantItem;
        double velX = client.field_1724.method_18798().field_1352;
        double velY = client.field_1724.method_18798().field_1351;
        double velZ = client.field_1724.method_18798().field_1350;
        double speedPerTick = Math.sqrt(velX * velX + velY * velY + velZ * velZ);
        double speedBps = speedPerTick * 20.0;
        if (speedBps > topSpeed) {
            topSpeed = speedBps;
        }
        if (speedBps > 0.1) {
            speedSum += speedBps;
            ++tickCount;
        }
        double avgSpeed = tickCount > 0L ? speedSum / (double)tickCount : 0.0;
        ArrayList<class_5250> lines = new ArrayList<class_5250>();
        class_1799 activeStack = main.method_31574(ModItems.VELOCITY_GAUGE) ? main : off;
        boolean isEnchanted = activeStack.method_7942();
        class_124 titleColor = isEnchanted ? class_124.field_1075 : class_124.field_1068;
        lines.add(class_2561.method_43470((String)"Speedometer").method_27692(titleColor));
        lines.add(class_2561.method_43470((String)String.format("%.1f b/s", speedBps)).method_10862(class_2583.field_24360.method_36139(16744268)));
        if (isEnchanted) {
            boolean isFlying = client.field_1724.method_6128();
            if (isFlying) {
                boolean danger = speedBps > 15.0;
                class_5250 symbol = class_2561.method_43470((String)(danger ? "\u26a0 " : "\u2714 ")).method_10862(class_2583.field_24360.method_36139(danger ? -43691 : -11141291).method_10982(Boolean.valueOf(true)));
                class_5250 stats = class_2561.method_43470((String)String.format("Top: %.1f  Avg: %.1f", topSpeed, avgSpeed)).method_10862(class_2583.field_24360.method_36139(-5592406));
                lines.add(class_2561.method_43473().method_10852((class_2561)symbol).method_10852((class_2561)stats));
            } else {
                lines.add(class_2561.method_43470((String)String.format("Top: %.1f  Avg: %.1f", topSpeed, avgSpeed)).method_10862(class_2583.field_24360.method_36139(-5592406)));
                double xBps = Math.abs(velX * 20.0);
                double zBps = Math.abs(velZ * 20.0);
                String vecText = String.format("X: %.1f  Z: %.1f", xBps, zBps);
                lines.add(class_2561.method_43470((String)vecText).method_27692(class_124.field_1080));
            }
        }
        if (lines.isEmpty()) {
            return;
        }
        class_327 textRenderer = client.field_1772;
        int screenHeight = context.method_51443();
        int actualTextWidth = 0;
        for (class_2561 class_25612 : lines) {
            int w = textRenderer.method_27525((class_5348)class_25612);
            if (w <= actualTextWidth) continue;
            actualTextWidth = w;
        }
        int minSafeWidth = 90;
        int n = Math.max(actualTextWidth, minSafeWidth);
        int paddingX = 6;
        int paddingY = 6;
        int lineSpacing = 2;
        int titleSpacing = 4;
        int n2 = lines.size();
        Objects.requireNonNull(textRenderer);
        int totalTextHeight = n2 * 9 + (lines.size() - 1) * lineSpacing + titleSpacing;
        int boxWidth = n + paddingX * 2;
        int boxHeight = totalTextHeight + paddingY * 2;
        int x = 10;
        int y = screenHeight / 2 - boxHeight / 2;
        if (hasOctant) {
            y += 35;
        }
        context.method_25294(x + 1, y + 1, x + boxWidth - 1, y + boxHeight - 1, -267386864);
        context.method_25294(x + 1, y, x + boxWidth - 1, y + 1, -267386864);
        context.method_25294(x + 1, y - 1, x + boxWidth - 1, y, -267386864);
        context.method_25294(x + 1, y + boxHeight, x + boxWidth - 1, y + boxHeight + 1, -267386864);
        context.method_25294(x - 1, y + 1, x, y + boxHeight - 1, -267386864);
        context.method_25294(x + boxWidth, y + 1, x + boxWidth + 1, y + boxHeight - 1, -267386864);
        context.method_25296(x + boxWidth - 1, y, x + boxWidth, y + 1, -267386864, -267386864);
        context.method_25296(x, y, x + 1, y + 1, -267386864, -267386864);
        context.method_25296(x + boxWidth - 1, y + boxHeight - 1, x + boxWidth, y + boxHeight, -267386864, -267386864);
        context.method_25296(x, y + boxHeight - 1, x + 1, y + boxHeight, -267386864, -267386864);
        context.method_25296(x + 1, y, x + boxWidth - 1, y + 1, -264306573, -264306573);
        context.method_25296(x + 1, y + boxHeight - 1, x + boxWidth - 1, y + boxHeight, -266010527, -266010527);
        context.method_25296(x, y + 1, x + 1, y + boxHeight - 1, -264306573, -266010527);
        context.method_25296(x + boxWidth - 1, y + 1, x + boxWidth, y + boxHeight - 1, -264306573, -266010527);
        int textY = y + paddingY;
        for (int i = 0; i < lines.size(); ++i) {
            class_2561 line = (class_2561)lines.get(i);
            context.method_27535(textRenderer, line, x + paddingX, textY, -1);
            Objects.requireNonNull(textRenderer);
            textY += 9 + lineSpacing;
            if (i != 0) continue;
            textY += titleSpacing;
        }
    }
}

