/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding.client.render;

import com.simplebuilding.Simplebuilding;
import com.simplebuilding.enchantment.ModEnchantments;
import com.simplebuilding.items.custom.OctantItem;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.class_9799;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class BlockHighlightRenderer {
    public static void render(Matrix4f positionMatrix, class_4184 camera) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        class_1799 stack = client.field_1724.method_6047();
        boolean isRangefinder = stack.method_7909() instanceof OctantItem;
        if (!isRangefinder) {
            stack = client.field_1724.method_6079();
            isRangefinder = stack.method_7909() instanceof OctantItem;
        }
        if (isRangefinder) {
            BlockHighlightRenderer.renderHighlights(positionMatrix, camera, stack, client.field_1724.method_5715());
        }
    }

    private static void renderHighlights(Matrix4f positionMatrix, class_4184 camera, class_1799 stack, boolean isSneaking) {
        class_9279 nbtData = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 nbt = nbtData.method_57461();
        class_2338 pos1 = BlockHighlightRenderer.getPos(nbt, "Pos1");
        class_2338 pos2 = BlockHighlightRenderer.getPos(nbt, "Pos2");
        if (pos1 == null && pos2 == null) {
            return;
        }
        boolean hasConstructorsTouch = BlockHighlightRenderer.hasEnchantment(stack, class_310.method_1551(), ModEnchantments.CONSTRUCTORS_TOUCH);
        boolean isInverted = Simplebuilding.getConfig().tools.invertOctantSneak;
        int opacityPercent = Simplebuilding.getConfig().tools.buildingHighlightOpacity;
        opacityPercent = Math.max(0, Math.min(100, opacityPercent));
        float baseAlpha = (float)opacityPercent / 100.0f;
        boolean showFill = hasConstructorsTouch ? (isInverted ? isSneaking : !isSneaking) : false;
        double camX = camera.method_19326().field_1352;
        double camY = camera.method_19326().field_1351;
        double camZ = camera.method_19326().field_1350;
        class_4587 matrices = new class_4587();
        matrices.method_22903();
        matrices.method_34425((Matrix4fc)positionMatrix);
        matrices.method_22904(-camX, -camY, -camZ);
        class_9799 allocator = new class_9799(1536);
        class_4597.class_4598 consumers = class_4597.method_22991((class_9799)allocator);
        float r1 = 1.0f;
        float g1 = 0.5f;
        float b1 = 0.3f;
        float r2 = 1.0f;
        float g2 = 0.85f;
        float b2 = 0.4f;
        float r3 = 0.8f;
        float g3 = 0.6f;
        float b3 = 0.4f;
        class_4588 lines = consumers.method_73477(class_1921.method_23594());
        float lineAlpha = 0.6f;
        if (pos1 != null) {
            BlockHighlightRenderer.drawBoxOutline(matrices, lines, new class_238(pos1).method_1014(0.02), r1, g1, b1, lineAlpha);
        }
        if (pos2 != null) {
            BlockHighlightRenderer.drawBoxOutline(matrices, lines, new class_238(pos2).method_1014(0.02), r2, g2, b2, lineAlpha);
        }
        if (pos1 != null && pos2 != null && showFill) {
            BlockHighlightRenderer.drawBoxOutline(matrices, lines, BlockHighlightRenderer.getFullArea(pos1, pos2).method_1014(0.02), r3, g3, b3, lineAlpha);
        }
        consumers.method_22994(class_1921.method_23594());
        if (showFill) {
            class_4588 fill = consumers.method_73477(class_1921.method_49042());
            float alpha = 0.5f * baseAlpha;
            if (pos1 != null) {
                BlockHighlightRenderer.drawBoxFill(matrices, fill, new class_238(pos1).method_1014(0.003), r1, g1, b1, alpha);
            }
            if (pos2 != null) {
                BlockHighlightRenderer.drawBoxFill(matrices, fill, new class_238(pos2).method_1014(0.006), r2, g2, b2, alpha);
            }
            if (pos1 != null && pos2 != null) {
                BlockHighlightRenderer.drawBoxFill(matrices, fill, BlockHighlightRenderer.getFullArea(pos1, pos2).method_1014(0.009), r3, g3, b3, alpha);
            }
            consumers.method_22994(class_1921.method_49042());
        }
        matrices.method_22909();
    }

    private static boolean hasEnchantment(class_1799 stack, class_310 client, class_5321<class_1887> key) {
        if (client.field_1687 == null) {
            return false;
        }
        class_5455 registry = client.field_1687.method_30349();
        class_2378 enchantments = registry.method_30530(class_7924.field_41265);
        Optional entry = enchantments.method_46746(key);
        return entry.isPresent() && class_1890.method_8225((class_6880)((class_6880)entry.get()), (class_1799)stack) > 0;
    }

    private static void drawBoxFill(class_4587 matrices, class_4588 builder, class_238 box, float r, float g, float b, float a) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        float x1 = (float)box.field_1323;
        float y1 = (float)box.field_1322;
        float z1 = (float)box.field_1321;
        float x2 = (float)box.field_1320;
        float y2 = (float)box.field_1325;
        float z2 = (float)box.field_1324;
        BlockHighlightRenderer.addQuad(builder, matrix, x1, y1, z1, x2, y1, z1, x2, y1, z2, x1, y1, z2, r, g, b, a);
        BlockHighlightRenderer.addQuad(builder, matrix, x1, y2, z2, x2, y2, z2, x2, y2, z1, x1, y2, z1, r, g, b, a);
        BlockHighlightRenderer.addQuad(builder, matrix, x1, y1, z1, x1, y2, z1, x2, y2, z1, x2, y1, z1, r, g, b, a);
        BlockHighlightRenderer.addQuad(builder, matrix, x2, y1, z2, x2, y2, z2, x1, y2, z2, x1, y1, z2, r, g, b, a);
        BlockHighlightRenderer.addQuad(builder, matrix, x1, y1, z2, x1, y2, z2, x1, y2, z1, x1, y1, z1, r, g, b, a);
        BlockHighlightRenderer.addQuad(builder, matrix, x2, y1, z1, x2, y2, z1, x2, y2, z2, x2, y1, z2, r, g, b, a);
    }

    private static void addQuad(class_4588 builder, Matrix4f matrix, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float r, float g, float b, float a) {
        builder.method_22918(matrix, x1, y1, z1).method_22915(r, g, b, a);
        builder.method_22918(matrix, x2, y2, z2).method_22915(r, g, b, a);
        builder.method_22918(matrix, x3, y3, z3).method_22915(r, g, b, a);
        builder.method_22918(matrix, x4, y4, z4).method_22915(r, g, b, a);
    }

    private static class_238 getFullArea(class_2338 p1, class_2338 p2) {
        int minX = Math.min(p1.method_10263(), p2.method_10263());
        int minY = Math.min(p1.method_10264(), p2.method_10264());
        int minZ = Math.min(p1.method_10260(), p2.method_10260());
        int maxX = Math.max(p1.method_10263(), p2.method_10263()) + 1;
        int maxY = Math.max(p1.method_10264(), p2.method_10264()) + 1;
        int maxZ = Math.max(p1.method_10260(), p2.method_10260()) + 1;
        return new class_238((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    private static void drawBoxOutline(class_4587 matrices, class_4588 builder, class_238 box, float r, float g, float b, float a) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        double x1 = box.field_1323;
        double y1 = box.field_1322;
        double z1 = box.field_1321;
        double x2 = box.field_1320;
        double y2 = box.field_1325;
        double z2 = box.field_1324;
        BlockHighlightRenderer.drawLineWithNormal(builder, matrix, x1, y1, z1, x2, y1, z1, r, g, b, a);
        BlockHighlightRenderer.drawLineWithNormal(builder, matrix, x2, y1, z1, x2, y1, z2, r, g, b, a);
        BlockHighlightRenderer.drawLineWithNormal(builder, matrix, x2, y1, z2, x1, y1, z2, r, g, b, a);
        BlockHighlightRenderer.drawLineWithNormal(builder, matrix, x1, y1, z2, x1, y1, z1, r, g, b, a);
        BlockHighlightRenderer.drawLineWithNormal(builder, matrix, x1, y2, z1, x2, y2, z1, r, g, b, a);
        BlockHighlightRenderer.drawLineWithNormal(builder, matrix, x2, y2, z1, x2, y2, z2, r, g, b, a);
        BlockHighlightRenderer.drawLineWithNormal(builder, matrix, x2, y2, z2, x1, y2, z2, r, g, b, a);
        BlockHighlightRenderer.drawLineWithNormal(builder, matrix, x1, y2, z2, x1, y2, z1, r, g, b, a);
        BlockHighlightRenderer.drawLineWithNormal(builder, matrix, x1, y1, z1, x1, y2, z1, r, g, b, a);
        BlockHighlightRenderer.drawLineWithNormal(builder, matrix, x2, y1, z1, x2, y2, z1, r, g, b, a);
        BlockHighlightRenderer.drawLineWithNormal(builder, matrix, x2, y1, z2, x2, y2, z2, r, g, b, a);
        BlockHighlightRenderer.drawLineWithNormal(builder, matrix, x1, y1, z2, x1, y2, z2, r, g, b, a);
    }

    private static void drawLineWithNormal(class_4588 builder, Matrix4f matrix, double x1, double y1, double z1, double x2, double y2, double z2, float r, float g, float b, float a) {
        float nx = (float)(x2 - x1);
        float ny = (float)(y2 - y1);
        float nz = (float)(z2 - z1);
        float len = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        if (len > 0.0f) {
            nx /= len;
            ny /= len;
            nz /= len;
        }
        builder.method_22918(matrix, (float)x1, (float)y1, (float)z1).method_22915(r, g, b, a).method_22914(nx, ny, nz);
        builder.method_22918(matrix, (float)x2, (float)y2, (float)z2).method_22915(r, g, b, a).method_22914(nx, ny, nz);
    }

    private static class_2338 getPos(class_2487 nbt, String key) {
        int[] arr;
        if (nbt.method_10545(key) && (arr = nbt.method_10561(key).orElse(new int[0])).length == 3) {
            return new class_2338(arr[0], arr[1], arr[2]);
        }
        return null;
    }
}

