/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding.client.render;

import com.simplebuilding.Simplebuilding;
import com.simplebuilding.items.custom.BuildingWandItem;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderEvents;
import net.minecraft.class_12074;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_746;
import org.joml.Matrix4f;

public class BuildingWandOutlineRenderer {
    private static final double SHRINK_AMOUNT = 0.25;

    public static void register() {
        WorldRenderEvents.BEFORE_BLOCK_OUTLINE.register(BuildingWandOutlineRenderer::onBlockOutline);
    }

    private static boolean onBlockOutline(WorldRenderContext context, class_12074 outlineRenderState) {
        int diameter;
        class_2350 face;
        class_3965 blockHit;
        BuildingWandItem wandItem;
        class_1799 stack;
        class_746 player;
        class_310 client;
        block11: {
            block10: {
                client = class_310.method_1551();
                player = client.field_1724;
                if (player == null || client.field_1687 == null) {
                    return true;
                }
                stack = player.method_6047();
                class_1792 class_17922 = stack.method_7909();
                if (!(class_17922 instanceof BuildingWandItem)) {
                    return true;
                }
                wandItem = (BuildingWandItem)class_17922;
                class_239 hit = client.field_1765;
                if (!(hit instanceof class_3965)) break block10;
                blockHit = (class_3965)hit;
                if (hit.method_17783() == class_239.class_240.field_1332) break block11;
            }
            return true;
        }
        class_2338 centerPos = blockHit.method_17777();
        List<class_2338> targetPositions = BuildingWandItem.getBuildingPositions((class_1937)client.field_1687, (class_1657)player, stack, centerPos, face = blockHit.method_17780(), diameter = wandItem.getWandSquareDiameter(), blockHit);
        if (targetPositions.isEmpty()) {
            return true;
        }
        class_2680 stateToCopy = client.field_1687.method_8320(centerPos);
        if (stateToCopy.method_26215()) {
            return true;
        }
        class_265 baseShape = stateToCopy.method_26218((class_1922)client.field_1687, centerPos);
        if (baseShape.method_1110()) {
            return true;
        }
        class_4587 matrices = context.matrices();
        class_4184 camera = client.field_1773.method_19418();
        class_243 camPos = camera.method_19326();
        double camX = camPos.field_1352;
        double camY = camPos.field_1351;
        double camZ = camPos.field_1350;
        class_4588 lines = context.consumers().method_73477(class_1921.method_23594());
        class_4588 fill = context.consumers().method_73477(class_1921.method_49042());
        matrices.method_22903();
        int opacityPercent = Simplebuilding.getConfig().tools.buildingHighlightOpacity;
        opacityPercent = Math.max(0, Math.min(100, opacityPercent));
        float baseAlpha = (float)opacityPercent / 100.0f;
        float r = 0.1f;
        float g = 0.1f;
        float b = 0.1f;
        float a = 0.3f;
        float r1 = 1.0f;
        float g1 = 0.5f;
        float b1 = 0.3f;
        float a1 = 0.2f * baseAlpha;
        for (class_2338 pos : targetPositions) {
            class_2680 targetState = client.field_1687.method_8320(pos);
            if (!targetState.method_45474()) continue;
            for (class_238 box : baseShape.method_1090()) {
                class_238 shrunkBox = box.method_1011(0.25);
                matrices.method_22903();
                matrices.method_22904((double)pos.method_10263() - camX, (double)pos.method_10264() - camY, (double)pos.method_10260() - camZ);
                BuildingWandOutlineRenderer.drawBoxOutline(matrices, lines, shrunkBox, r, g, b, a);
                BuildingWandOutlineRenderer.drawBoxFill(matrices, fill, shrunkBox.method_1014(-0.003), r1, g1, b1, a1);
                matrices.method_22909();
            }
        }
        matrices.method_22909();
        return false;
    }

    private static void drawBoxOutline(class_4587 matrices, class_4588 builder, class_238 box, float r, float g, float b, float a) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        double x1 = box.field_1323;
        double y1 = box.field_1322;
        double z1 = box.field_1321;
        double x2 = box.field_1320;
        double y2 = box.field_1325;
        double z2 = box.field_1324;
        BuildingWandOutlineRenderer.drawLineWithNormal(builder, matrix, x1, y1, z1, x2, y1, z1, r, g, b, a);
        BuildingWandOutlineRenderer.drawLineWithNormal(builder, matrix, x2, y1, z1, x2, y1, z2, r, g, b, a);
        BuildingWandOutlineRenderer.drawLineWithNormal(builder, matrix, x2, y1, z2, x1, y1, z2, r, g, b, a);
        BuildingWandOutlineRenderer.drawLineWithNormal(builder, matrix, x1, y1, z2, x1, y1, z1, r, g, b, a);
        BuildingWandOutlineRenderer.drawLineWithNormal(builder, matrix, x1, y2, z1, x2, y2, z1, r, g, b, a);
        BuildingWandOutlineRenderer.drawLineWithNormal(builder, matrix, x2, y2, z1, x2, y2, z2, r, g, b, a);
        BuildingWandOutlineRenderer.drawLineWithNormal(builder, matrix, x2, y2, z2, x1, y2, z2, r, g, b, a);
        BuildingWandOutlineRenderer.drawLineWithNormal(builder, matrix, x1, y2, z2, x1, y2, z1, r, g, b, a);
        BuildingWandOutlineRenderer.drawLineWithNormal(builder, matrix, x1, y1, z1, x1, y2, z1, r, g, b, a);
        BuildingWandOutlineRenderer.drawLineWithNormal(builder, matrix, x2, y1, z1, x2, y2, z1, r, g, b, a);
        BuildingWandOutlineRenderer.drawLineWithNormal(builder, matrix, x2, y1, z2, x2, y2, z2, r, g, b, a);
        BuildingWandOutlineRenderer.drawLineWithNormal(builder, matrix, x1, y1, z2, x1, y2, z2, r, g, b, a);
    }

    private static void drawBoxFill(class_4587 matrices, class_4588 builder, class_238 box, float r, float g, float b, float a) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        float x1 = (float)box.field_1323;
        float y1 = (float)box.field_1322;
        float z1 = (float)box.field_1321;
        float x2 = (float)box.field_1320;
        float y2 = (float)box.field_1325;
        float z2 = (float)box.field_1324;
        BuildingWandOutlineRenderer.addQuad(builder, matrix, x1, y1, z1, x2, y1, z1, x2, y1, z2, x1, y1, z2, r, g, b, a);
        BuildingWandOutlineRenderer.addQuad(builder, matrix, x1, y2, z2, x2, y2, z2, x2, y2, z1, x1, y2, z1, r, g, b, a);
        BuildingWandOutlineRenderer.addQuad(builder, matrix, x1, y1, z1, x1, y2, z1, x2, y2, z1, x2, y1, z1, r, g, b, a);
        BuildingWandOutlineRenderer.addQuad(builder, matrix, x2, y1, z2, x2, y2, z2, x1, y2, z2, x1, y1, z2, r, g, b, a);
        BuildingWandOutlineRenderer.addQuad(builder, matrix, x1, y1, z2, x1, y2, z2, x1, y2, z1, x1, y1, z1, r, g, b, a);
        BuildingWandOutlineRenderer.addQuad(builder, matrix, x2, y1, z1, x2, y2, z1, x2, y2, z2, x2, y1, z2, r, g, b, a);
    }

    private static void addQuad(class_4588 builder, Matrix4f matrix, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float r, float g, float b, float a) {
        builder.method_22918(matrix, x1, y1, z1).method_22915(r, g, b, a);
        builder.method_22918(matrix, x2, y2, z2).method_22915(r, g, b, a);
        builder.method_22918(matrix, x3, y3, z3).method_22915(r, g, b, a);
        builder.method_22918(matrix, x4, y4, z4).method_22915(r, g, b, a);
    }

    private static void drawLineWithNormal(class_4588 builder, Matrix4f matrix, double x1, double y1, double z1, double x2, double y2, double z2, float r, float g, float b, float a) {
        float nx = (float)(x2 - x1);
        float ny = (float)(y2 - y1);
        float nz = (float)(z2 - z1);
        float len = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        if (len > 0.0f) {
            nx /= len;
            ny /= len;
            nz /= len;
        }
        builder.method_22918(matrix, (float)x1, (float)y1, (float)z1).method_22915(r, g, b, a).method_22914(nx, ny, nz);
        builder.method_22918(matrix, (float)x2, (float)y2, (float)z2).method_22915(r, g, b, a).method_22914(nx, ny, nz);
    }
}

