/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding.client.render;

import com.simplebuilding.Simplebuilding;
import com.simplebuilding.items.custom.SledgehammerItem;
import com.simplebuilding.util.SledgehammerUtils;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderEvents;
import net.minecraft.class_12074;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_746;
import org.joml.Matrix4f;

public class SledgehammerOutlineRenderer {
    public static void register() {
        WorldRenderEvents.BEFORE_BLOCK_OUTLINE.register(SledgehammerOutlineRenderer::onBlockOutline);
    }

    private static boolean onBlockOutline(WorldRenderContext context, class_12074 outlineRenderState) {
        class_3965 blockHit;
        class_1799 stack;
        class_746 player;
        class_310 client;
        block9: {
            block8: {
                client = class_310.method_1551();
                player = client.field_1724;
                if (player == null || client.field_1687 == null) {
                    return true;
                }
                stack = player.method_6047();
                if (!(stack.method_7909() instanceof SledgehammerItem)) {
                    return true;
                }
                class_239 hit = client.field_1765;
                if (!(hit instanceof class_3965)) break block8;
                blockHit = (class_3965)hit;
                if (hit.method_17783() == class_239.class_240.field_1332) break block9;
            }
            return true;
        }
        class_2338 centerPos = blockHit.method_17777();
        List<class_2338> targetPositions = SledgehammerItem.getBlocksToBeDestroyed(1, centerPos, (class_1657)player);
        if (targetPositions.isEmpty()) {
            return true;
        }
        class_4587 matrices = context.matrices();
        class_4184 camera = client.field_1773.method_19418();
        double camX = camera.method_19326().field_1352;
        double camY = camera.method_19326().field_1351;
        double camZ = camera.method_19326().field_1350;
        class_4588 lines = context.consumers().method_73477(class_1921.method_23594());
        class_4588 fill = context.consumers().method_73477(class_1921.method_49042());
        matrices.method_22903();
        int opacityPercent = Simplebuilding.getConfig().tools.buildingHighlightOpacity;
        opacityPercent = Math.max(0, Math.min(100, opacityPercent));
        float baseAlpha = (float)opacityPercent / 100.0f;
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float a = 0.3f;
        float r1 = 1.0f;
        float g1 = 0.5f;
        float b1 = 0.3f;
        float a1 = 0.2f * baseAlpha;
        class_238 totalBounds = null;
        for (class_2338 pos : targetPositions) {
            class_265 shape;
            class_2680 state;
            if (!SledgehammerUtils.shouldBreak((class_1937)client.field_1687, pos, centerPos, stack)) continue;
            class_238 blockBox = new class_238(pos);
            totalBounds = totalBounds == null ? blockBox : totalBounds.method_991(blockBox);
            if (pos.equals((Object)centerPos) || (state = client.field_1687.method_8320(pos)).method_26215() || (shape = state.method_26218((class_1922)client.field_1687, pos)).method_1110()) continue;
            for (class_238 box : shape.method_1090()) {
                matrices.method_22903();
                matrices.method_22904((double)pos.method_10263() - camX, (double)pos.method_10264() - camY, (double)pos.method_10260() - camZ);
                SledgehammerOutlineRenderer.drawBoxOutline(matrices, lines, box, r, g, b, a);
                SledgehammerOutlineRenderer.drawBoxFill(matrices, fill, box.method_1014(0.003), r1, g1, b1, a1);
                matrices.method_22909();
            }
        }
        matrices.method_22909();
        return true;
    }

    private static void drawBoxFill(class_4587 matrices, class_4588 builder, class_238 box, float r, float g, float b, float a) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        float x1 = (float)box.field_1323;
        float y1 = (float)box.field_1322;
        float z1 = (float)box.field_1321;
        float x2 = (float)box.field_1320;
        float y2 = (float)box.field_1325;
        float z2 = (float)box.field_1324;
        SledgehammerOutlineRenderer.addQuad(builder, matrix, x1, y1, z1, x2, y1, z1, x2, y1, z2, x1, y1, z2, r, g, b, a);
        SledgehammerOutlineRenderer.addQuad(builder, matrix, x1, y2, z2, x2, y2, z2, x2, y2, z1, x1, y2, z1, r, g, b, a);
        SledgehammerOutlineRenderer.addQuad(builder, matrix, x1, y1, z1, x1, y2, z1, x2, y2, z1, x2, y1, z1, r, g, b, a);
        SledgehammerOutlineRenderer.addQuad(builder, matrix, x2, y1, z2, x2, y2, z2, x1, y2, z2, x1, y1, z2, r, g, b, a);
        SledgehammerOutlineRenderer.addQuad(builder, matrix, x1, y1, z2, x1, y2, z2, x1, y2, z1, x1, y1, z1, r, g, b, a);
        SledgehammerOutlineRenderer.addQuad(builder, matrix, x2, y1, z1, x2, y2, z1, x2, y2, z2, x2, y1, z2, r, g, b, a);
    }

    private static void addQuad(class_4588 builder, Matrix4f matrix, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float r, float g, float b, float a) {
        builder.method_22918(matrix, x1, y1, z1).method_22915(r, g, b, a);
        builder.method_22918(matrix, x2, y2, z2).method_22915(r, g, b, a);
        builder.method_22918(matrix, x3, y3, z3).method_22915(r, g, b, a);
        builder.method_22918(matrix, x4, y4, z4).method_22915(r, g, b, a);
    }

    private static void drawBoxOutline(class_4587 matrices, class_4588 builder, class_238 box, float r, float g, float b, float a) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        double x1 = box.field_1323;
        double y1 = box.field_1322;
        double z1 = box.field_1321;
        double x2 = box.field_1320;
        double y2 = box.field_1325;
        double z2 = box.field_1324;
        SledgehammerOutlineRenderer.drawLineWithNormal(builder, matrix, x1, y1, z1, x2, y1, z1, r, g, b, a);
        SledgehammerOutlineRenderer.drawLineWithNormal(builder, matrix, x2, y1, z1, x2, y1, z2, r, g, b, a);
        SledgehammerOutlineRenderer.drawLineWithNormal(builder, matrix, x2, y1, z2, x1, y1, z2, r, g, b, a);
        SledgehammerOutlineRenderer.drawLineWithNormal(builder, matrix, x1, y1, z2, x1, y1, z1, r, g, b, a);
        SledgehammerOutlineRenderer.drawLineWithNormal(builder, matrix, x1, y2, z1, x2, y2, z1, r, g, b, a);
        SledgehammerOutlineRenderer.drawLineWithNormal(builder, matrix, x2, y2, z1, x2, y2, z2, r, g, b, a);
        SledgehammerOutlineRenderer.drawLineWithNormal(builder, matrix, x2, y2, z2, x1, y2, z2, r, g, b, a);
        SledgehammerOutlineRenderer.drawLineWithNormal(builder, matrix, x1, y2, z2, x1, y2, z1, r, g, b, a);
        SledgehammerOutlineRenderer.drawLineWithNormal(builder, matrix, x1, y1, z1, x1, y2, z1, r, g, b, a);
        SledgehammerOutlineRenderer.drawLineWithNormal(builder, matrix, x2, y1, z1, x2, y2, z1, r, g, b, a);
        SledgehammerOutlineRenderer.drawLineWithNormal(builder, matrix, x2, y1, z2, x2, y2, z2, r, g, b, a);
        SledgehammerOutlineRenderer.drawLineWithNormal(builder, matrix, x1, y1, z2, x1, y2, z2, r, g, b, a);
    }

    private static void drawLineWithNormal(class_4588 builder, Matrix4f matrix, double x1, double y1, double z1, double x2, double y2, double z2, float r, float g, float b, float a) {
        float nx = (float)(x2 - x1);
        float ny = (float)(y2 - y1);
        float nz = (float)(z2 - z1);
        float len = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        if (len > 0.0f) {
            nx /= len;
            ny /= len;
            nz /= len;
        }
        builder.method_22918(matrix, (float)x1, (float)y1, (float)z1).method_22915(r, g, b, a).method_22914(nx, ny, nz);
        builder.method_22918(matrix, (float)x2, (float)y2, (float)z2).method_22915(r, g, b, a).method_22914(nx, ny, nz);
    }
}

