/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding.datagen;

import com.simplebuilding.Simplebuilding;
import com.simplebuilding.enchantment.ModEnchantments;
import com.simplebuilding.items.ModItems;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9306;
import net.minecraft.class_9334;

public class ModTradeOffers {
    public static void registerModTradeOffers() {
        Simplebuilding.LOGGER.info("Registering Custom Trade Offers for simplebuilding");
        ModTradeOffers.registerVillagerTrades();
        ModTradeOffers.registerWanderingTraderTrades();
    }

    public static void registerVillagerTrades() {
        if (Simplebuilding.getConfig().worldGen.enableVillagerTrades) {
            TradeOfferHelper.registerVillagerOffers((class_5321)class_3852.field_17060, (int)3, factories -> {
                List<WeightedEnchantment> buildingPool = List.of(new WeightedEnchantment(ModEnchantments.COLOR_PALETTE, 1, 30), new WeightedEnchantment(ModEnchantments.FAST_CHISELING, 1, 30), new WeightedEnchantment(ModEnchantments.LINEAR, 1, 25));
                factories.add((entity, random) -> new class_1914(new class_9306((class_1935)class_1802.field_8687, 25), ModTradeOffers.createRandomEnchantedBook(entity, random, buildingPool, 0), 3, 15, 0.3f));
            });
            TradeOfferHelper.registerVillagerOffers((class_5321)class_3852.field_17060, (int)4, factories -> {
                List<WeightedEnchantment> advancedPool = List.of(new WeightedEnchantment(ModEnchantments.LINEAR, 1, 25), new WeightedEnchantment(ModEnchantments.OVERRIDE, 1, 20));
                factories.add((entity, random) -> new class_1914(new class_9306((class_1935)class_1802.field_8687, 25), ModTradeOffers.createRandomEnchantedBook(entity, random, advancedPool, 0), 2, 25, 0.5f));
            });
            TradeOfferHelper.registerVillagerOffers((class_5321)class_3852.field_17060, (int)5, factories -> {
                List<WeightedEnchantment> masterPool = List.of(new WeightedEnchantment(ModEnchantments.MASTER_BUILDER, 1, 10), new WeightedEnchantment(ModEnchantments.RANGE, 1, 10), new WeightedEnchantment(ModEnchantments.FUNNEL, 1, 30), new WeightedEnchantment(ModEnchantments.STRIP_MINER, 1, 20));
                factories.add((entity, random) -> new class_1914(new class_9306((class_1935)class_1802.field_8687, 25), ModTradeOffers.createRandomEnchantedBook(entity, random, masterPool, 0), 1, 100, 1.0f));
            });
            TradeOfferHelper.registerVillagerOffers((class_5321)class_3852.field_17061, (int)2, factories -> {
                factories.add((entity, random) -> new class_1914(new class_9306((class_1935)class_1802.field_8687, 25), new class_1799((class_1935)ModItems.COPPER_CORE, 1), 2, 10, 0.1f));
                factories.add((entity, random) -> new class_1914(new class_9306((class_1935)class_1802.field_22020, 6), new class_1799((class_1935)ModItems.DIAMOND_CORE, 1), 2, 15, 0.1f));
            });
            TradeOfferHelper.registerVillagerOffers((class_5321)class_3852.field_17061, (int)4, factories -> factories.add((entity, random) -> new class_1914(new class_9306((class_1935)class_1802.field_8687, 62), new class_1799((class_1935)ModItems.COPPER_BUILDING_WAND, 1), 1, 20, 0.2f)));
            TradeOfferHelper.registerVillagerOffers((class_5321)class_3852.field_17064, (int)3, factories -> {
                List<WeightedEnchantment> chiselEnchants = List.of(new WeightedEnchantment(ModEnchantments.FAST_CHISELING, 1, 50), new WeightedEnchantment(ModEnchantments.FAST_CHISELING, 2, 30));
                factories.add((entity, random) -> new class_1914(new class_9306((class_1935)class_1802.field_8687, 6), ModTradeOffers.createRandomEnchantedItem(entity, random, ModItems.IRON_CHISEL, chiselEnchants, 0), 2, 10, 0.2f));
                factories.add((entity, random) -> new class_1914(new class_9306((class_1935)class_1802.field_8687, 6), ModTradeOffers.createRandomEnchantedItem(entity, random, ModItems.COPPER_CHISEL, chiselEnchants, 0), 2, 10, 0.2f));
                factories.add((entity, random) -> new class_1914(new class_9306((class_1935)class_1802.field_8687, 6), ModTradeOffers.createRandomEnchantedItem(entity, random, ModItems.GOLD_CHISEL, chiselEnchants, 0), 2, 10, 0.2f));
            });
            TradeOfferHelper.registerVillagerOffers((class_5321)class_3852.field_17064, (int)4, factories -> {
                List<WeightedEnchantment> hammerEnchants = List.of(new WeightedEnchantment(ModEnchantments.BREAK_THROUGH, 1, 5), new WeightedEnchantment(ModEnchantments.OVERRIDE, 1, 15), new WeightedEnchantment(ModEnchantments.RANGE, 1, 10), new WeightedEnchantment((class_5321<class_1887>)class_1893.field_9119, 2, 50), new WeightedEnchantment((class_5321<class_1887>)class_1893.field_9131, 3, 50));
                factories.add((entity, random) -> new class_1914(new class_9306((class_1935)class_1802.field_8687, 28), Optional.of(new class_9306((class_1935)class_1802.field_8377, 1)), ModTradeOffers.createRandomEnchantedItem(entity, random, ModItems.DIAMOND_SLEDGEHAMMER, hammerEnchants, 10), 1, 30, 0.5f));
                factories.add((entity, random) -> new class_1914(new class_9306((class_1935)class_1802.field_8687, 16), Optional.of(new class_9306((class_1935)class_1802.field_8403, 1)), ModTradeOffers.createRandomEnchantedItem(entity, random, ModItems.IRON_SLEDGEHAMMER, hammerEnchants, 10), 1, 30, 0.5f));
            });
            TradeOfferHelper.registerVillagerOffers((class_5321)class_3852.field_17064, (int)5, factories -> {
                List<WeightedEnchantment> stripMinerPool = List.of(new WeightedEnchantment(ModEnchantments.STRIP_MINER, 1, 40), new WeightedEnchantment(ModEnchantments.STRIP_MINER, 2, 30), new WeightedEnchantment(ModEnchantments.STRIP_MINER, 3, 10));
                factories.add((entity, random) -> new class_1914(new class_9306((class_1935)class_1802.field_8687, 15), ModTradeOffers.createRandomEnchantedItem(entity, random, class_1802.field_8377, stripMinerPool, 10), 1, 50, 0.8f));
            });
        }
    }

    public static void registerWanderingTraderTrades() {
        if (Simplebuilding.getConfig().worldGen.enableWanderingTrades) {
            TradeOfferHelper.registerWanderingTraderOffers(factory -> {
                factory.addOffersToPool(TradeOfferHelper.WanderingTraderOffersBuilder.BUY_ITEMS_POOL, new class_3853.class_1652[]{(entity, random) -> new class_1914(new class_9306((class_1935)ModItems.REINFORCED_BUNDLE, 1), new class_1799((class_1935)class_1802.field_8687, 12), 1, 10, 0.1f)});
                factory.addOffersToPool(TradeOfferHelper.WanderingTraderOffersBuilder.BUY_ITEMS_POOL, new class_3853.class_1652[]{(entity, random) -> new class_1914(new class_9306((class_1935)ModItems.OCTANT, 1), new class_1799((class_1935)class_1802.field_8687, 8), 3, 5, 0.1f)});
                factory.addOffersToPool(TradeOfferHelper.WanderingTraderOffersBuilder.SELL_SPECIAL_ITEMS_POOL, new class_3853.class_1652[]{(entity, random) -> new class_1914(new class_9306((class_1935)class_1802.field_8687, 10), new class_1799((class_1935)ModItems.OCTANT, 1), 1, 15, 0.1f)});
                factory.addOffersToPool(TradeOfferHelper.WanderingTraderOffersBuilder.SELL_SPECIAL_ITEMS_POOL, new class_3853.class_1652[]{(entity, random) -> new class_1914(new class_9306((class_1935)class_1802.field_8687, 16), new class_1799((class_1935)ModItems.REINFORCED_BUNDLE, 1), 1, 15, 0.1f)});
                factory.addOffersToPool(TradeOfferHelper.WanderingTraderOffersBuilder.SELL_COMMON_ITEMS_POOL, new class_3853.class_1652[]{(entity, random) -> new class_1914(new class_9306((class_1935)class_1802.field_8687, 46), new class_1799((class_1935)ModItems.COPPER_CORE, 2), 4, 10, 0.1f)});
                factory.addOffersToPool(TradeOfferHelper.WanderingTraderOffersBuilder.SELL_COMMON_ITEMS_POOL, new class_3853.class_1652[]{(entity, random) -> new class_1914(new class_9306((class_1935)class_1802.field_8687, 56), new class_1799((class_1935)ModItems.IRON_CORE, 2), 4, 10, 0.1f)});
                factory.addOffersToPool(TradeOfferHelper.WanderingTraderOffersBuilder.SELL_SPECIAL_ITEMS_POOL, new class_3853.class_1652[]{(entity, random) -> new class_1914(new class_9306((class_1935)class_1802.field_8687, 30), new class_1799((class_1935)ModItems.GOLD_CORE, 1), 1, 5, 0.1f)});
                factory.addOffersToPool(TradeOfferHelper.WanderingTraderOffersBuilder.SELL_SPECIAL_ITEMS_POOL, new class_3853.class_1652[]{(entity, random) -> {
                    List<WeightedEnchantment> wandPool = List.of(new WeightedEnchantment(ModEnchantments.BRIDGE, 1, 30), new WeightedEnchantment(ModEnchantments.RADIUS, 1, 20), new WeightedEnchantment(ModEnchantments.QUIVER, 1, 20));
                    return new class_1914(new class_9306((class_1935)class_1802.field_8687, 60), ModTradeOffers.createRandomEnchantedBook(entity, random, wandPool, 0), 1, 10, 0.2f);
                }});
            });
        }
    }

    private static WeightedEnchantment pickWeighted(List<WeightedEnchantment> pool, class_5819 random) {
        int totalWeight = 0;
        for (WeightedEnchantment e : pool) {
            totalWeight += e.weight();
        }
        if (totalWeight == 0) {
            return null;
        }
        int pick = random.method_43048(totalWeight);
        int currentWeight = 0;
        for (WeightedEnchantment e : pool) {
            if (pick >= (currentWeight += e.weight())) continue;
            return e;
        }
        return pool.get(0);
    }

    private static class_1799 createRandomEnchantedItem(class_1297 entity, class_5819 random, class_1792 item, List<WeightedEnchantment> pool, int chanceForSecond) {
        class_1799 stack = new class_1799((class_1935)item);
        class_9304.class_9305 builder = new class_9304.class_9305(class_9304.field_49385);
        WeightedEnchantment firstPick = ModTradeOffers.pickWeighted(pool, random);
        ModTradeOffers.addEnchantmentToBuilder(entity, builder, firstPick);
        if (pool.size() > 1 && random.method_43048(100) < chanceForSecond) {
            WeightedEnchantment secondPick = ModTradeOffers.pickWeighted(pool, random);
            for (int attempts = 0; secondPick.key().equals(firstPick.key()) && attempts < 10; ++attempts) {
                secondPick = ModTradeOffers.pickWeighted(pool, random);
            }
            if (!secondPick.key().equals(firstPick.key())) {
                ModTradeOffers.addEnchantmentToBuilder(entity, builder, secondPick);
            }
        }
        stack.method_57379(class_9334.field_49633, (Object)builder.method_57549());
        return stack;
    }

    private static void addEnchantmentToBuilder(class_1297 entity, class_9304.class_9305 builder, WeightedEnchantment selection) {
        class_6880.class_6883 enchantmentEntry = entity.method_56673().method_30530(class_7924.field_41265).method_46747(selection.key());
        builder.method_57550((class_6880)enchantmentEntry, selection.level());
    }

    private static class_1799 createRandomEnchantedBook(class_1297 entity, class_5819 random, List<WeightedEnchantment> pool, int chanceForSecond) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8598);
        class_9304.class_9305 builder = new class_9304.class_9305(class_9304.field_49385);
        WeightedEnchantment firstPick = ModTradeOffers.pickWeighted(pool, random);
        ModTradeOffers.addEnchantmentToBuilder(entity, builder, firstPick);
        if (pool.size() > 1 && random.method_43048(100) < chanceForSecond) {
            WeightedEnchantment secondPick = ModTradeOffers.pickWeighted(pool, random);
            for (int attempts = 0; secondPick.key().equals(firstPick.key()) && attempts < 10; ++attempts) {
                secondPick = ModTradeOffers.pickWeighted(pool, random);
            }
            if (!secondPick.key().equals(firstPick.key())) {
                ModTradeOffers.addEnchantmentToBuilder(entity, builder, secondPick);
            }
        }
        stack.method_57379(class_9334.field_49643, (Object)builder.method_57549());
        return stack;
    }

    public record WeightedEnchantment(class_5321<class_1887> key, int level, int weight) {
    }
}

