/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding.items.custom;

import com.simplebuilding.enchantment.ModEnchantments;
import com.simplebuilding.items.custom.ReinforcedBundleItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9276;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class BuildingWandItem
extends class_1792 {
    public static final int BUILDING_WAND_SQUARE_COPPER = 3;
    public static final int BUILDING_WAND_SQUARE_IRON = 5;
    public static final int BUILDING_WAND_SQUARE_GOLD = 7;
    public static final int BUILDING_WAND_SQUARE_DIAMOND = 7;
    public static final int BUILDING_WAND_SQUARE_NETHERITE = 9;
    public static final int DURABILITY_MULTIPLAYER_WAND = 8;
    public static final int DELAY_TICKS = 6;
    public static final int DELAY_TICKS_LINE = 3;
    private int wandSquareDiameter = 1;
    private class_3414 placeSound = class_3417.field_14574;

    public BuildingWandItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7884(class_1838 context) {
        if (context.method_20287() != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        class_1937 world = context.method_8045();
        class_1657 player = context.method_8036();
        class_2338 clickedPos = context.method_8037();
        class_2350 clickedFace = context.method_8038();
        class_1799 wandStack = context.method_8041();
        if (world.method_8608() || player == null) {
            return class_1269.field_5812;
        }
        class_2487 nbt = this.getOrInitNbt(wandStack);
        nbt.method_10556("Active", true);
        nbt.method_10569("CurrentRadius", 0);
        nbt.method_10569("Timer", 0);
        nbt.method_10569("OriginX", clickedPos.method_10263());
        nbt.method_10569("OriginY", clickedPos.method_10264());
        nbt.method_10569("OriginZ", clickedPos.method_10260());
        nbt.method_10569("Face", clickedFace.ordinal());
        nbt.method_10569("PlayerFacing", player.method_5735().ordinal());
        class_243 hitPos = context.method_17698().method_1023((double)clickedPos.method_10263(), (double)clickedPos.method_10264(), (double)clickedPos.method_10260());
        nbt.method_10548("HitX", (float)hitPos.field_1352);
        nbt.method_10548("HitY", (float)hitPos.field_1351);
        nbt.method_10548("HitZ", (float)hitPos.field_1350);
        this.setNbt(wandStack, nbt);
        return class_1269.field_21466;
    }

    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, class_1304 slot) {
        class_1792 class_17922;
        class_2248 patternBlock;
        if (!(entity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)entity;
        class_2487 nbt = this.getOrInitNbt(stack);
        if (!this.getBlockBoolean(nbt)) {
            return;
        }
        if (slot != class_1304.field_6173 && slot != class_1304.field_6171) {
            nbt.method_10556("Active", false);
            this.setNbt(stack, nbt);
            return;
        }
        int timer = this.getBlockInt(nbt, "Timer");
        if (timer > 0) {
            nbt.method_10569("Timer", timer - 1);
            this.setNbt(stack, nbt);
            return;
        }
        int currentRadius = this.getBlockInt(nbt, "CurrentRadius");
        int maxRadius = (this.wandSquareDiameter - 1) / 2;
        boolean isBridge = BuildingWandItem.hasEnchantment(stack, (class_1937)world, ModEnchantments.BRIDGE);
        boolean isLinePlace = BuildingWandItem.hasEnchantment(stack, (class_1937)world, ModEnchantments.LINEAR);
        boolean isCover = BuildingWandItem.hasEnchantment(stack, (class_1937)world, ModEnchantments.COVER);
        if ((isBridge || isLinePlace) && isBridge) {
            maxRadius = this.wandSquareDiameter;
        }
        int ox = this.getBlockInt(nbt, "OriginX");
        int oy = this.getBlockInt(nbt, "OriginY");
        int oz = this.getBlockInt(nbt, "OriginZ");
        class_2338 originPos = new class_2338(ox, oy, oz);
        int faceInt = this.getBlockInt(nbt, "Face");
        if (faceInt < 0 || faceInt >= class_2350.values().length) {
            faceInt = 0;
        }
        class_2350 face = class_2350.values()[faceInt];
        class_2350 playerFacing = class_2350.values()[this.getBlockInt(nbt, "PlayerFacing")];
        double hitX = nbt.method_10583("HitX").orElse(Float.valueOf(0.5f)).floatValue();
        double hitY = nbt.method_10583("HitY").orElse(Float.valueOf(0.5f)).floatValue();
        double hitZ = nbt.method_10583("HitZ").orElse(Float.valueOf(0.5f)).floatValue();
        class_2680 originState = world.method_8320(originPos);
        class_2248 materialBlock = patternBlock = originState.method_26204();
        class_2680 materialState = originState;
        class_1799 offHandStack = player.method_6079();
        if (!offHandStack.method_7960() && (class_17922 = offHandStack.method_7909()) instanceof class_1747) {
            class_1747 bi = (class_1747)class_17922;
            materialBlock = bi.method_7711();
            materialState = bi.method_7711().method_9564();
        }
        List<class_2338> stepPositions = BuildingWandItem.calculatePositions((class_1937)world, stack, originPos, face, currentRadius, playerFacing, hitX, hitY, hitZ, this.wandSquareDiameter);
        boolean hasMasterBuilder = BuildingWandItem.hasEnchantment(stack, (class_1937)world, ModEnchantments.MASTER_BUILDER);
        boolean placedAny = false;
        for (class_2338 rawPos : stepPositions) {
            class_2338 targetPos = null;
            if (isCover) {
                int maxDeviation = currentRadius;
                for (int depth = 1; depth <= maxDeviation + 1; ++depth) {
                    class_2338 checkPos = rawPos.method_10079(face.method_10153(), depth);
                    class_2680 checkState = world.method_8320(checkPos);
                    if (!this.isValidSupport(checkState, patternBlock, true)) continue;
                    targetPos = checkPos.method_10093(face);
                    break;
                }
            } else {
                targetPos = rawPos;
            }
            if (targetPos == null || !world.method_8320(targetPos).method_45474()) continue;
            MaterialResult material = this.findMaterial((class_1657)player, stack, materialBlock, hasMasterBuilder);
            if (material == null && !player.method_31549().field_7477) {
                nbt.method_10556("Active", false);
                this.setNbt(stack, nbt);
                return;
            }
            class_2680 stateToPlace = material != null ? material.stateToPlace : materialState;
            if (!world.method_8652(targetPos, stateToPlace, 3)) continue;
            class_2498 soundGroup = stateToPlace.method_26231();
            world.method_8396(null, targetPos, soundGroup.method_10598(), class_3419.field_15245, (soundGroup.method_10597() + 1.0f) / 2.0f, soundGroup.method_10599() * 0.8f);
            if (!player.method_31549().field_7477 && material != null) {
                material.consume();
                stack.method_7970(1, (class_1309)player, class_1304.field_6173);
            }
            placedAny = true;
        }
        if (currentRadius < maxRadius) {
            nbt.method_10569("CurrentRadius", currentRadius + 1);
            nbt.method_10569("Timer", isLinePlace ? 3 : 6);
        } else {
            nbt.method_10556("Active", false);
        }
        this.setNbt(stack, nbt);
    }

    public static List<class_2338> getBuildingPositions(class_1937 world, class_1657 player, class_1799 wandStack, class_2338 originPos, class_2350 face, int diameter, class_3965 hitResult) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        class_1792 class_17922 = wandStack.method_7909();
        if (!(class_17922 instanceof BuildingWandItem)) {
            return positions;
        }
        BuildingWandItem wandItem = (BuildingWandItem)class_17922;
        int radius = (diameter - 1) / 2;
        boolean isBridge = BuildingWandItem.hasEnchantment(wandStack, world, ModEnchantments.BRIDGE);
        boolean isLinePlace = BuildingWandItem.hasEnchantment(wandStack, world, ModEnchantments.LINEAR);
        boolean isCover = BuildingWandItem.hasEnchantment(wandStack, world, ModEnchantments.COVER);
        int maxSteps = isBridge || isLinePlace ? diameter : radius;
        class_243 vec = hitResult.method_17784().method_1023((double)originPos.method_10263(), (double)originPos.method_10264(), (double)originPos.method_10260());
        double hitX = vec.field_1352;
        double hitY = vec.field_1351;
        double hitZ = vec.field_1350;
        class_2680 originState = world.method_8320(originPos);
        class_2248 patternBlock = originState.method_26204();
        for (int r = 0; r <= maxSteps; ++r) {
            List<class_2338> stepPositions = BuildingWandItem.calculatePositions(world, wandStack, originPos, face, r, player.method_5735(), hitX, hitY, hitZ, diameter);
            for (class_2338 rawPos : stepPositions) {
                class_2338 targetPos = null;
                if (isCover) {
                    int maxDeviation = r;
                    for (int depth = 1; depth <= maxDeviation + 1; ++depth) {
                        class_2338 checkPos = rawPos.method_10079(face.method_10153(), depth);
                        class_2680 checkState = world.method_8320(checkPos);
                        if (!wandItem.isValidSupport(checkState, patternBlock, true)) continue;
                        targetPos = checkPos.method_10093(face);
                        break;
                    }
                } else {
                    targetPos = rawPos;
                }
                if (targetPos == null || !world.method_8320(targetPos).method_45474()) continue;
                positions.add(targetPos);
            }
        }
        return positions;
    }

    private static List<class_2338> calculatePositions(class_1937 world, class_1799 wandStack, class_2338 originPos, class_2350 face, int r, class_2350 playerFacing, double hitX, double hitY, double hitZ, int diameter) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        boolean isBridge = BuildingWandItem.hasEnchantment(wandStack, world, ModEnchantments.BRIDGE);
        boolean isLinePlace = BuildingWandItem.hasEnchantment(wandStack, world, ModEnchantments.LINEAR);
        if (isBridge) {
            class_2350 buildDir = face;
            if (face == class_2350.field_11036 || face == class_2350.field_11033) {
                if (hitX < 0.2) {
                    buildDir = class_2350.field_11039;
                } else if (hitX > 0.8) {
                    buildDir = class_2350.field_11034;
                } else if (hitZ < 0.2) {
                    buildDir = class_2350.field_11043;
                } else if (hitZ > 0.8) {
                    buildDir = class_2350.field_11035;
                }
            }
            class_2338 stepCenter = originPos.method_10079(buildDir, r + 1);
            if (isLinePlace) {
                positions.add(stepCenter);
            } else {
                int widthRadius = (diameter - 1) / 2;
                class_2350.class_2351 widthAxis = buildDir.method_10166() == class_2350.class_2351.field_11052 ? (playerFacing.method_10166() == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048) : (buildDir.method_10166() == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048);
                for (int u = -widthRadius; u <= widthRadius; ++u) {
                    class_2338 pos = null;
                    if (widthAxis == class_2350.class_2351.field_11048) {
                        pos = stepCenter.method_10069(u, 0, 0);
                    } else if (widthAxis == class_2350.class_2351.field_11051) {
                        pos = stepCenter.method_10069(0, 0, u);
                    } else if (widthAxis == class_2350.class_2351.field_11052) {
                        pos = stepCenter.method_10069(0, u, 0);
                    }
                    if (pos == null) continue;
                    positions.add(pos);
                }
            }
            return positions;
        }
        class_2338 centerPos = originPos.method_10093(face);
        if (isLinePlace) {
            class_2350.class_2351 axis;
            if (face.method_10166() == class_2350.class_2351.field_11052) {
                boolean nearEdgeX;
                boolean nearEdgeZ = hitZ < 0.2 || hitZ > 0.8;
                boolean bl = nearEdgeX = hitX < 0.2 || hitX > 0.8;
                axis = nearEdgeZ ? class_2350.class_2351.field_11051 : (nearEdgeX ? class_2350.class_2351.field_11048 : (playerFacing.method_10166() == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048));
            } else if (hitY < 0.2 || hitY > 0.8) {
                axis = class_2350.class_2351.field_11052;
            } else {
                class_2350.class_2351 class_23512 = axis = face.method_10166() == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
            }
            if (r == 0) {
                positions.add(centerPos);
            } else {
                positions.add(BuildingWandItem.getPosOnAxis(centerPos, axis, r));
                positions.add(BuildingWandItem.getPosOnAxis(centerPos, axis, -r));
            }
            return positions;
        }
        if (r == 0) {
            positions.add(centerPos);
            return positions;
        }
        for (int u = -r; u <= r; ++u) {
            for (int v = -r; v <= r; ++v) {
                if (Math.abs(u) != r && Math.abs(v) != r) continue;
                class_2338 targetPos = null;
                if (face.method_10166() == class_2350.class_2351.field_11052) {
                    targetPos = centerPos.method_10069(u, 0, v);
                } else if (face.method_10166() == class_2350.class_2351.field_11051) {
                    targetPos = centerPos.method_10069(u, v, 0);
                } else if (face.method_10166() == class_2350.class_2351.field_11048) {
                    targetPos = centerPos.method_10069(0, v, u);
                }
                if (targetPos == null) continue;
                positions.add(targetPos);
            }
        }
        return positions;
    }

    private MaterialResult findMaterial(class_1657 player, class_1799 wandStack, class_2248 targetBlock, boolean hasMasterBuilder) {
        class_1799 stack;
        class_1937 world = player.method_73183();
        class_1799 offHand = player.method_6079();
        if (!offHand.method_7960()) {
            if (hasMasterBuilder && offHand.method_7909() instanceof ReinforcedBundleItem) {
                res = this.findInBundle(offHand, targetBlock, wandStack, world);
                if (res != null) {
                    return res;
                }
            } else {
                class_1747 bi;
                res = offHand.method_7909();
                if (res instanceof class_1747 && (bi = (class_1747)res).method_7711() == targetBlock) {
                    res = new MaterialResult();
                    res.sourceStack = offHand;
                    res.fromBundle = false;
                    res.stateToPlace = bi.method_7711().method_9564();
                    return res;
                }
            }
        }
        if (hasMasterBuilder) {
            for (int i = 0; i < 9; ++i) {
                MaterialResult res;
                stack = player.method_31548().method_5438(i);
                if (!(stack.method_7909() instanceof ReinforcedBundleItem) || (res = this.findInBundle(stack, targetBlock, wandStack, world)) == null) continue;
                return res;
            }
        }
        for (int i = 0; i < 9; ++i) {
            class_1747 bi;
            stack = player.method_31548().method_5438(i);
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof class_1747) || (bi = (class_1747)class_17922).method_7711() != targetBlock) continue;
            MaterialResult res = new MaterialResult();
            res.sourceStack = stack;
            res.fromBundle = false;
            res.stateToPlace = bi.method_7711().method_9564();
            return res;
        }
        return null;
    }

    private MaterialResult findInBundle(class_1799 bundle, class_2248 targetBlock, class_1799 wand, class_1937 world) {
        boolean hasColorPalette = BuildingWandItem.hasEnchantment(wand, world, ModEnchantments.COLOR_PALETTE);
        class_9276 contents = (class_9276)bundle.method_58694(class_9334.field_49650);
        if (contents == null || contents.method_57429()) {
            return null;
        }
        if (hasColorPalette) {
            ArrayList<Integer> validIndices = new ArrayList<Integer>();
            int i = 0;
            for (Object s : contents.method_57421()) {
                if (!s.method_7960() && s.method_7909() instanceof class_1747) {
                    validIndices.add(i);
                }
                ++i;
            }
            if (validIndices.isEmpty()) {
                return null;
            }
            int randomIndex = (Integer)validIndices.get(world.field_9229.method_43048(validIndices.size()));
            i = 0;
            for (class_1799 s : contents.method_57421()) {
                class_1792 class_17922;
                if (i == randomIndex && (class_17922 = s.method_7909()) instanceof class_1747) {
                    class_1747 bi = (class_1747)class_17922;
                    MaterialResult res = new MaterialResult();
                    res.sourceStack = bundle;
                    res.fromBundle = true;
                    res.bundleIndex = randomIndex;
                    res.stateToPlace = bi.method_7711().method_9564();
                    return res;
                }
                ++i;
            }
        } else {
            int i = 0;
            int firstValidIndex = -1;
            class_1747 firstValidBlock = null;
            for (class_1799 s : contents.method_57421()) {
                Object res;
                if (!s.method_7960() && (res = s.method_7909()) instanceof class_1747) {
                    class_1747 bi = (class_1747)res;
                    if (bi.method_7711() == targetBlock) {
                        res = new MaterialResult();
                        res.sourceStack = bundle;
                        res.fromBundle = true;
                        res.bundleIndex = i;
                        res.stateToPlace = bi.method_7711().method_9564();
                        return res;
                    }
                    if (firstValidIndex == -1) {
                        firstValidIndex = i;
                        firstValidBlock = bi;
                    }
                }
                ++i;
            }
            if (firstValidIndex != -1) {
                MaterialResult res = new MaterialResult();
                res.sourceStack = bundle;
                res.fromBundle = true;
                res.bundleIndex = firstValidIndex;
                res.stateToPlace = firstValidBlock.method_7711().method_9564();
                return res;
            }
        }
        return null;
    }

    private static void removeOneFromBundle(class_1799 bundle, int indexToRemove) {
        class_9276 contents = (class_9276)bundle.method_58694(class_9334.field_49650);
        if (contents == null) {
            return;
        }
        ArrayList<class_1799> newItems = new ArrayList<class_1799>();
        int i = 0;
        for (class_1799 s : contents.method_57421()) {
            if (i == indexToRemove) {
                class_1799 copy = s.method_7972();
                copy.method_7934(1);
                if (!copy.method_7960()) {
                    newItems.add(copy);
                }
            } else {
                newItems.add(s.method_7972());
            }
            ++i;
        }
        bundle.method_57379(class_9334.field_49650, (Object)new class_9276(newItems));
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type) {
        Optional linePlaceEntry;
        Optional registry;
        boolean isLinePlace = false;
        if (context.method_59527() != null && (registry = context.method_59527().method_46759(class_7924.field_41265)).isPresent() && (linePlaceEntry = ((class_7225.class_7226)registry.get()).method_46746(ModEnchantments.LINEAR)).isPresent()) {
            boolean bl = isLinePlace = class_1890.method_8225((class_6880)((class_6880)linePlaceEntry.get()), (class_1799)stack) > 0;
        }
        if (isLinePlace) {
            textConsumer.accept((class_2561)class_2561.method_43469((String)"tooltip.simplebuilding.building_wand.line_size", (Object[])new Object[]{this.wandSquareDiameter}).method_27692(class_124.field_1080));
        } else {
            textConsumer.accept((class_2561)class_2561.method_43469((String)"tooltip.simplebuilding.building_wand.size", (Object[])new Object[]{this.wandSquareDiameter, this.wandSquareDiameter}).method_27692(class_124.field_1080));
        }
        super.method_67187(stack, context, displayComponent, textConsumer, type);
    }

    private static boolean hasEnchantment(class_1799 stack, class_1937 world, class_5321<class_1887> key) {
        if (world == null) {
            return false;
        }
        class_5455 registry = world.method_30349();
        class_2378 lookup = registry.method_30530(class_7924.field_41265);
        Optional entry = lookup.method_46746(key);
        return entry.isPresent() && class_1890.method_8225((class_6880)((class_6880)entry.get()), (class_1799)stack) > 0;
    }

    public boolean isValidSupport(class_2680 supportState, class_2248 patternBlock, boolean isCover) {
        if (supportState.method_26215() || supportState.method_51176()) {
            return false;
        }
        if (isCover) {
            return true;
        }
        return supportState.method_26204() == patternBlock;
    }

    public int getWandSquareDiameter() {
        return this.wandSquareDiameter;
    }

    public void setWandSquareDiameter(int wandSquareDiameter) {
        this.wandSquareDiameter = wandSquareDiameter;
    }

    private static class_2338 getPosOnAxis(class_2338 center, class_2350.class_2351 axis, int offset) {
        if (axis == class_2350.class_2351.field_11048) {
            return center.method_10069(offset, 0, 0);
        }
        if (axis == class_2350.class_2351.field_11052) {
            return center.method_10069(0, offset, 0);
        }
        if (axis == class_2350.class_2351.field_11051) {
            return center.method_10069(0, 0, offset);
        }
        return center;
    }

    private boolean getBlockBoolean(class_2487 nbt) {
        if (!nbt.method_10545("Active")) {
            return false;
        }
        return nbt.method_10577("Active").orElse(false);
    }

    private int getBlockInt(class_2487 nbt, String key) {
        if (!nbt.method_10545(key)) {
            return 0;
        }
        return nbt.method_10550(key).orElse(0);
    }

    private class_2487 getOrInitNbt(class_1799 stack) {
        class_9279 component = (class_9279)stack.method_58694(class_9334.field_49628);
        return component != null ? component.method_57461() : new class_2487();
    }

    private void setNbt(class_1799 stack, class_2487 nbt) {
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
    }

    public class_3414 getPlaceSound() {
        return this.placeSound;
    }

    public void setPlaceSound(class_3414 placeSound) {
        this.placeSound = placeSound;
    }

    private static class MaterialResult {
        class_1799 sourceStack;
        int bundleIndex;
        boolean fromBundle;
        class_2680 stateToPlace;

        private MaterialResult() {
        }

        public void consume() {
            if (this.fromBundle) {
                BuildingWandItem.removeOneFromBundle(this.sourceStack, this.bundleIndex);
            } else {
                this.sourceStack.method_7934(1);
            }
        }
    }
}

