/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding.items.custom;

import com.simplebuilding.enchantment.ModEnchantments;
import com.simplebuilding.items.ModItems;
import com.simplebuilding.items.tooltip.ReinforcedBundleTooltipData;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5536;
import net.minecraft.class_5537;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9276;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.apache.commons.lang3.math.Fraction;

public class ReinforcedBundleItem
extends class_5537 {
    public ReinforcedBundleItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public boolean method_31568() {
        return false;
    }

    public boolean method_31565(class_1799 bundle, class_1735 slot, class_5536 clickType, class_1657 player) {
        int added;
        if (clickType != class_5536.field_27014 && clickType != class_5536.field_27013) {
            return false;
        }
        class_9276 contents = (class_9276)bundle.method_58694(class_9334.field_49650);
        if (contents == null) {
            contents = class_9276.field_49289;
        }
        class_1799 itemInSlot = slot.method_7677();
        if (clickType == class_5536.field_27014 && itemInSlot.method_7960()) {
            class_1799 removed = this.removeSelectedOrFirstItem(bundle, contents);
            if (!removed.method_7960()) {
                this.playRemoveOneSound(player);
                slot.method_32756(removed);
                return true;
            }
        } else if (clickType == class_5536.field_27013 && !itemInSlot.method_7960() && itemInSlot.method_7909().method_31568() && (added = this.insertItemIntoBundle(bundle, contents, itemInSlot, this.getMaxCapacity(bundle, player))) > 0) {
            this.playInsertSound(player);
            itemInSlot.method_7934(added);
            return true;
        }
        return false;
    }

    public boolean method_31566(class_1799 bundle, class_1799 cursorStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        int added;
        if (clickType != class_5536.field_27014 && clickType != class_5536.field_27013) {
            return false;
        }
        class_9276 contents = (class_9276)bundle.method_58694(class_9334.field_49650);
        if (contents == null) {
            contents = class_9276.field_49289;
        }
        if (clickType == class_5536.field_27014 && cursorStack.method_7960()) {
            class_1799 removed = this.removeSelectedOrFirstItem(bundle, contents);
            if (!removed.method_7960()) {
                this.playRemoveOneSound(player);
                cursorStackReference.method_32332(removed);
                return true;
            }
        } else if (clickType == class_5536.field_27013 && !cursorStack.method_7960() && cursorStack.method_7909().method_31568() && (added = this.insertItemIntoBundle(bundle, contents, cursorStack, this.getMaxCapacity(bundle, player))) > 0) {
            this.playInsertSound(player);
            cursorStack.method_7934(added);
            return true;
        }
        return false;
    }

    public class_1269 method_7884(class_1838 context) {
        class_9276 contents;
        class_1657 player = context.method_8036();
        class_1799 bundleStack = context.method_8041();
        assert (player != null);
        if (this.hasMasterBuilder(bundleStack, player.method_73183()) && (contents = (class_9276)bundleStack.method_58694(class_9334.field_49650)) != null && !contents.method_57429()) {
            class_1838 blockContext;
            class_1747 blockItem;
            class_1269 result;
            class_1799 blockToPlace;
            class_1792 class_17922;
            int index = contents.method_61668();
            if (index == -1 || index >= contents.method_57426()) {
                index = 0;
            }
            if (this.hasColorPalette(bundleStack, player.method_73183())) {
                index = player.method_73183().method_8409().method_43048(contents.method_57426());
            }
            if ((class_17922 = (blockToPlace = contents.method_57422(index).method_7972()).method_7909()) instanceof class_1747 && (result = (blockItem = (class_1747)class_17922).method_7884(blockContext = new class_1838(context.method_8045(), context.method_8036(), context.method_20287(), blockToPlace, new class_3965(context.method_17698(), context.method_8038(), context.method_8037(), false)))).method_23665()) {
                if (!player.method_31549().field_7477) {
                    this.removeOneItemFromBundle(bundleStack, contents, index);
                }
                return result;
            }
        }
        return super.method_7884(context);
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        class_9276 contents = (class_9276)stack.method_58694(class_9334.field_49650);
        if (contents != null && !contents.method_57429()) {
            class_1799 itemToDrop;
            int index = contents.method_61668();
            if (index == -1 || index >= contents.method_57426()) {
                index = 0;
            }
            if ((itemToDrop = contents.method_57422(index)).method_7909() instanceof class_1747) {
                return class_1269.field_5814;
            }
            if (!world.method_8608()) {
                class_1799 removed = this.removeSelectedOrFirstItem(stack, contents);
                user.method_7328(removed, true);
                this.playRemoveOneSound(user);
            }
            return class_1269.field_5812;
        }
        return super.method_7836(world, user, hand);
    }

    public boolean method_31567(class_1799 stack) {
        class_9276 contents = (class_9276)stack.method_58694(class_9334.field_49650);
        return contents != null && !contents.method_57429();
    }

    public int method_31569(class_1799 stack) {
        class_9276 data = (class_9276)stack.method_58694(class_9334.field_49650);
        if (data == null) {
            return 0;
        }
        Fraction current = data.method_57428();
        Fraction max = this.getMaxCapacityForVisuals(stack);
        float fillLevel = Math.min(1.0f, current.divideBy(max).floatValue());
        return Math.round(fillLevel * 13.0f);
    }

    public int method_31571(class_1799 stack) {
        class_9276 data = (class_9276)stack.method_58694(class_9334.field_49650);
        if (data == null) {
            return super.method_31571(stack);
        }
        Fraction current = data.method_57428();
        Fraction max = this.getMaxCapacityForVisuals(stack);
        float fillLevel = Math.min(1.0f, current.divideBy(max).floatValue());
        return class_3532.method_15369((float)(Math.max(0.0f, 1.0f - fillLevel) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type) {
        super.method_67187(stack, context, displayComponent, textConsumer, type);
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        class_9276 contents = (class_9276)stack.method_58694(class_9334.field_49650);
        if (contents == null) {
            return Optional.empty();
        }
        Fraction frac = this.getMaxCapacityForVisuals(stack);
        int maxCapacity = (int)(frac.doubleValue() * 64.0);
        return Optional.of(new ReinforcedBundleTooltipData(contents, maxCapacity));
    }

    private boolean hasColorPalette(class_1799 stack, class_1937 world) {
        class_5455 registry = world.method_30349();
        class_2378 enchantments = registry.method_30530(class_7924.field_41265);
        Optional cp = enchantments.method_46746(ModEnchantments.COLOR_PALETTE);
        return cp.isPresent() && class_1890.method_8225((class_6880)((class_6880)cp.get()), (class_1799)stack) > 0;
    }

    private boolean hasMasterBuilder(class_1799 stack, class_1937 world) {
        class_5455 registry = world.method_30349();
        class_2378 enchantments = registry.method_30530(class_7924.field_41265);
        Optional mb = enchantments.method_46746(ModEnchantments.MASTER_BUILDER);
        return mb.isPresent() && class_1890.method_8225((class_6880)((class_6880)mb.get()), (class_1799)stack) > 0;
    }

    private int insertItemIntoBundle(class_1799 bundle, class_9276 contents, class_1799 stackToAdd, Fraction maxCap) {
        if (stackToAdd.method_7960()) {
            return 0;
        }
        Fraction currentOccupancy = contents.method_57428();
        Fraction itemWeight = Fraction.getFraction((int)1, (int)stackToAdd.method_7914());
        Fraction remainingSpace = maxCap.subtract(currentOccupancy);
        if (remainingSpace.compareTo(itemWeight) < 0) {
            return 0;
        }
        int maxStackSize = stackToAdd.method_7914();
        int countThatFits = (int)remainingSpace.multiplyBy(Fraction.getFraction((int)maxStackSize, (int)1)).doubleValue();
        int countToAdd = Math.min(stackToAdd.method_7947(), countThatFits);
        if (countToAdd <= 0) {
            return 0;
        }
        ArrayList<class_1799> newItems = new ArrayList<class_1799>();
        for (class_1799 s : contents.method_57421()) {
            newItems.add(s.method_7972());
        }
        class_1799 toAdd = stackToAdd.method_7972();
        toAdd.method_7939(countToAdd);
        this.addToBundleList(newItems, toAdd);
        class_5537.method_61637((class_1799)bundle, (int)-1);
        bundle.method_57379(class_9334.field_49650, (Object)new class_9276(newItems));
        return countToAdd;
    }

    private void addToBundleList(List<class_1799> list, class_1799 stackToAdd) {
        int available;
        int toMerge;
        class_1799 topStack;
        if (!list.isEmpty() && class_1799.method_31577((class_1799)(topStack = list.getFirst()), (class_1799)stackToAdd) && (toMerge = Math.min(available = topStack.method_7914() - topStack.method_7947(), stackToAdd.method_7947())) > 0) {
            topStack.method_7933(toMerge);
            stackToAdd.method_7934(toMerge);
        }
        if (!stackToAdd.method_7960()) {
            list.addFirst(stackToAdd);
        }
    }

    private class_1799 removeSelectedOrFirstItem(class_1799 bundle, class_9276 contents) {
        if (contents.method_57429()) {
            return class_1799.field_8037;
        }
        int selectedIndex = contents.method_61668();
        if (selectedIndex == -1) {
            selectedIndex = 0;
        }
        if (selectedIndex >= contents.method_57426()) {
            selectedIndex = 0;
        }
        class_1799 itemToRemove = contents.method_57422(selectedIndex).method_7972();
        ArrayList<class_1799> newItems = new ArrayList<class_1799>();
        int i = 0;
        for (class_1799 s : contents.method_57421()) {
            if (i != selectedIndex) {
                newItems.add(s.method_7972());
            }
            ++i;
        }
        class_5537.method_61637((class_1799)bundle, (int)-1);
        bundle.method_57379(class_9334.field_49650, (Object)new class_9276(newItems));
        return itemToRemove;
    }

    private void removeOneItemFromBundle(class_1799 bundle, class_9276 contents, int targetIndex) {
        if (contents.method_57429()) {
            return;
        }
        ArrayList<class_1799> newItems = new ArrayList<class_1799>();
        for (class_1799 s : contents.method_57421()) {
            newItems.add(s.method_7972());
        }
        if (targetIndex < newItems.size()) {
            class_1799 targetStack = (class_1799)newItems.get(targetIndex);
            targetStack.method_7934(1);
            if (targetStack.method_7960()) {
                newItems.remove(targetIndex);
            }
        }
        bundle.method_57379(class_9334.field_49650, (Object)new class_9276(newItems));
    }

    public boolean tryInsertStackFromWorld(class_1799 bundle, class_1799 stackToInsert, class_1657 player) {
        Fraction maxCap;
        int added;
        if (!stackToInsert.method_7909().method_31568()) {
            return false;
        }
        class_9276 contents = (class_9276)bundle.method_58694(class_9334.field_49650);
        if (contents == null) {
            contents = class_9276.field_49289;
        }
        if ((added = this.insertItemIntoBundle(bundle, contents, stackToInsert, maxCap = this.getMaxCapacity(bundle, player))) > 0) {
            stackToInsert.method_7934(added);
            this.playInsertSound(player);
            return true;
        }
        return false;
    }

    protected Fraction getMaxCapacity(class_1799 stack, class_1657 player) {
        Fraction capacity;
        Fraction fraction = capacity = stack.method_31574(ModItems.NETHERITE_BUNDLE) ? Fraction.getFraction((int)2, (int)1) : Fraction.getFraction((int)1, (int)1);
        if (player == null || player.method_73183() == null) {
            return capacity;
        }
        class_5455 registry = player.method_73183().method_30349();
        class_2378 enchantments = registry.method_30530(class_7924.field_41265);
        Optional deepPockets = enchantments.method_46746(ModEnchantments.DEEP_POCKETS);
        if (deepPockets.isPresent()) {
            int level = class_1890.method_8225((class_6880)((class_6880)deepPockets.get()), (class_1799)stack);
            if (level == 1) {
                capacity = capacity.multiplyBy(Fraction.getFraction((int)2, (int)1));
            }
            if (level >= 2) {
                capacity = capacity.multiplyBy(Fraction.getFraction((int)4, (int)1));
            }
        }
        return capacity;
    }

    protected Fraction getMaxCapacityForVisuals(class_1799 stack) {
        Fraction capacity = stack.method_31574(ModItems.NETHERITE_BUNDLE) ? Fraction.getFraction((int)2, (int)1) : Fraction.getFraction((int)1, (int)1);
        class_9304 enchantments = stack.method_58657();
        for (Object2IntMap.Entry entry : enchantments.method_57539()) {
            String id;
            if (!((class_6880)entry.getKey()).method_40230().isPresent() || !(id = ((class_5321)((class_6880)entry.getKey()).method_40230().get()).method_29177().toString()).contains("deep_pockets")) continue;
            int level = entry.getIntValue();
            if (level == 1) {
                capacity = capacity.multiplyBy(Fraction.getFraction((int)2, (int)1));
            }
            if (level < 2) continue;
            capacity = capacity.multiplyBy(Fraction.getFraction((int)4, (int)1));
        }
        return capacity;
    }

    private void playRemoveOneSound(class_1657 entity) {
        entity.method_5783(class_3417.field_34377, 0.8f, 0.8f + entity.method_73183().method_8409().method_43057() * 0.4f);
    }

    private void playInsertSound(class_1657 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_73183().method_8409().method_43057() * 0.4f);
    }
}

