/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding.items.custom;

import com.simplebuilding.enchantment.ModEnchantments;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9886;

public class SledgehammerItem
extends class_1792 {
    public static final int STONE_ATTACK_DAMAGE = 3;
    public static final int COPPER_ATTACK_DAMAGE = 4;
    public static final int IRON_ATTACK_DAMAGE = 5;
    public static final int GOLD_ATTACK_DAMAGE = 4;
    public static final int DIAMOND_ATTACK_DAMAGE = 6;
    public static final int NETHERITE_ATTACK_DAMAGE = 7;
    public static final float ATTACK_SPEED_OFFSET = 1.2f;
    public static final float STONE_ATTACK_SPEED = -4.2f;
    public static final float COPPER_ATTACK_SPEED = -4.0f;
    public static final float IRON_ATTACK_SPEED = -4.2f;
    public static final float GOLD_ATTACK_SPEED = -4.0f;
    public static final float DIAMOND_ATTACK_SPEED = -4.0f;
    public static final float NETHERITE_ATTACK_SPEED = -3.8f;

    public SledgehammerItem(class_9886 material, float attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(settings.method_66330(material, attackDamage, attackSpeed));
    }

    public float method_58404(class_1799 stack, class_2680 state) {
        float baseSpeed = super.method_58404(stack, state);
        if (baseSpeed > 1.0f) {
            class_9304 enchantments = stack.method_58657();
            boolean hasRadius = false;
            boolean hasBreakThrough = false;
            for (Object2IntMap.Entry entry : enchantments.method_57539()) {
                if (((class_6880)entry.getKey()).method_40225(ModEnchantments.RADIUS)) {
                    hasRadius = true;
                }
                if (!((class_6880)entry.getKey()).method_40225(ModEnchantments.BREAK_THROUGH)) continue;
                hasBreakThrough = true;
            }
            float divisor = 6.0f;
            if (hasRadius && hasBreakThrough) {
                divisor = 33.0f;
            } else if (hasRadius) {
                divisor = 16.0f;
            } else if (hasBreakThrough) {
                divisor = 11.0f;
            }
            return baseSpeed / divisor;
        }
        return baseSpeed;
    }

    public static List<class_2338> getBlocksToBeDestroyed(int baseRange, class_2338 initialPos, class_1657 player) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        class_1937 world = player.method_73183();
        class_1799 stack = player.method_6047();
        class_2680 initialState = world.method_8320(initialPos);
        if (!stack.method_7909().method_58405(stack, initialState)) {
            return positions;
        }
        class_2350 sideHit = SledgehammerItem.getHitSideFromPlayer(player);
        class_5455 registry = world.method_30349();
        class_2378 enchantLookup = registry.method_30530(class_7924.field_41265);
        Optional radiusKey = enchantLookup.method_46746(ModEnchantments.RADIUS);
        int range = baseRange;
        if (radiusKey.isPresent() && class_1890.method_8225((class_6880)((class_6880)radiusKey.get()), (class_1799)stack) > 0) {
            ++range;
        }
        Optional breakThroughKey = enchantLookup.method_46746(ModEnchantments.BREAK_THROUGH);
        int depth = 0;
        if (breakThroughKey.isPresent() && class_1890.method_8225((class_6880)((class_6880)breakThroughKey.get()), (class_1799)stack) > 0) {
            depth = 1;
        }
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = 0; z <= depth; ++z) {
                    if (x == 0 && y == 0 && z == 0) {
                        positions.add(initialPos);
                        continue;
                    }
                    class_2338 targetPos = null;
                    if (sideHit == class_2350.field_11033 || sideHit == class_2350.field_11036) {
                        depthOffset = sideHit == class_2350.field_11036 ? -z : z;
                        targetPos = initialPos.method_10069(x, depthOffset, y);
                    } else if (sideHit == class_2350.field_11043 || sideHit == class_2350.field_11035) {
                        depthOffset = sideHit == class_2350.field_11043 ? z : -z;
                        targetPos = initialPos.method_10069(x, y, depthOffset);
                    } else if (sideHit == class_2350.field_11034 || sideHit == class_2350.field_11039) {
                        depthOffset = sideHit == class_2350.field_11039 ? z : -z;
                        targetPos = initialPos.method_10069(depthOffset, y, x);
                    }
                    if (targetPos == null) continue;
                    positions.add(targetPos);
                }
            }
        }
        return positions;
    }

    private static class_2350 getHitSideFromPlayer(class_1657 player) {
        float pitch = player.method_36455();
        if (pitch < -60.0f) {
            return class_2350.field_11033;
        }
        if (pitch > 60.0f) {
            return class_2350.field_11036;
        }
        return player.method_5735().method_10153();
    }
}

