/*
 * Decompiled with CFR 0.152.
 */
package com.simplebuilding.mixin;

import com.simplebuilding.enchantment.ModEnchantments;
import com.simplebuilding.items.custom.ReinforcedBundleItem;
import com.simplebuilding.util.BundleUtil;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_3489;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin {
    @Shadow
    public abstract class_1661 method_31548();

    @Inject(method={"method_18808(Lnet/minecraft/class_1799;)Lnet/minecraft/class_1799;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getProjectileTypeFromBundle(class_1799 stack, CallbackInfoReturnable<class_1799> cir) {
        if (!(stack.method_7909() instanceof class_1753)) {
            return;
        }
        class_1657 player = (class_1657)this;
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 arrowStack;
            class_1799 slotStack = player.method_31548().method_5438(i);
            if (!(slotStack.method_7909() instanceof ReinforcedBundleItem) || !this.hasQuiverEnchantment(slotStack, player) || (arrowStack = BundleUtil.findArrow(slotStack)).method_7960()) continue;
            cir.setReturnValue((Object)arrowStack.method_7972());
            return;
        }
    }

    @Inject(method={"method_7351(Lnet/minecraft/class_2680;)F"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyMiningSpeedForStripMiner(class_2680 state, CallbackInfoReturnable<Float> cir) {
        class_1657 player = (class_1657)this;
        class_1799 stack = player.method_6047();
        if (!stack.method_31573(class_3489.field_42614)) {
            return;
        }
        if (!stack.method_7909().method_58405(stack, state)) {
            return;
        }
        class_5455 registry = player.method_73183().method_30349();
        class_2378 enchantLookup = registry.method_30530(class_7924.field_41265);
        Optional stripMinerKey = enchantLookup.method_46746(ModEnchantments.STRIP_MINER);
        if (stripMinerKey.isEmpty()) {
            return;
        }
        int level = class_1890.method_8225((class_6880)((class_6880)stripMinerKey.get()), (class_1799)stack);
        if (level > 0) {
            float originalSpeed = ((Float)cir.getReturnValue()).floatValue();
            float divisor = 1.0f;
            switch (level) {
                case 1: {
                    divisor = 2.0f;
                    break;
                }
                case 2: {
                    divisor = 3.0f;
                    break;
                }
                case 3: {
                    divisor = 4.0f;
                }
            }
            cir.setReturnValue((Object)Float.valueOf(originalSpeed / divisor));
        }
    }

    @Unique
    private boolean hasQuiverEnchantment(class_1799 stack, class_1657 player) {
        class_5455 registry = player.method_73183().method_30349();
        class_2378 enchantments = registry.method_30530(class_7924.field_41265);
        Optional quiver = enchantments.method_46746(ModEnchantments.QUIVER);
        return quiver.isPresent() && class_1890.method_8225((class_6880)((class_6880)quiver.get()), (class_1799)stack) > 0;
    }
}

