/*
 * Decompiled with CFR 0.152.
 */
package com.luzyvert.timetick;

import com.luzyvert.timetick.CachedChunkData;
import com.luzyvert.timetick.TimeTickComponents;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1928;
import net.minecraft.class_2248;
import net.minecraft.class_2266;
import net.minecraft.class_2282;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2397;
import net.minecraft.class_2473;
import net.minecraft.class_2513;
import net.minecraft.class_2523;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3194;
import net.minecraft.class_3218;
import net.minecraft.class_3830;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeTick
implements ModInitializer {
    public static final String MOD_ID = "timetick";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"timetick");
    private static final Queue<Runnable> TASK_QUEUE = new ConcurrentLinkedQueue<Runnable>();

    public void onInitialize() {
        LOGGER.info("TimeTick initializing");
        ServerChunkEvents.CHUNK_LEVEL_TYPE_CHANGE.register((world, chunk, oldLevelType, newLevelType) -> {
            if (this.IsBlockTicking(newLevelType)) {
                if (!this.IsBlockTicking(oldLevelType)) {
                    this.TickChunk(world, chunk);
                }
                return;
            }
            this.SaveChunkTime(world, chunk);
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (TASK_QUEUE.isEmpty()) {
                return;
            }
            long startTime = System.nanoTime();
            long MAX_TIME_NS = 35000000L;
            while (!TASK_QUEUE.isEmpty()) {
                Runnable task = TASK_QUEUE.poll();
                if (task != null) {
                    try {
                        task.run();
                    }
                    catch (Exception e) {
                        LOGGER.error("Error processing growth task", (Throwable)e);
                    }
                }
                if (System.nanoTime() - startTime <= MAX_TIME_NS) continue;
                break;
            }
        });
    }

    private void SaveChunkTime(class_3218 world, class_2818 chunk) {
        if (this.IsBlockTicking(chunk.method_12225())) {
            return;
        }
        CachedChunkData data = (CachedChunkData)TimeTickComponents.CHUNK_DATA.get((Object)chunk);
        if (data.tickTime > 0L) {
            return;
        }
        ArrayList<class_2338> growingBlocks = new ArrayList<class_2338>();
        class_2826[] sections = chunk.method_12006();
        for (int i = 0; i < sections.length; ++i) {
            class_2826 section = sections[i];
            if (section == null || section.method_38292() || !section.method_12262()) continue;
            int startY = chunk.method_31607() + i * 16;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < 16; ++y) {
                        class_2680 state = section.method_12254(x, y, z);
                        class_2248 block = state.method_26204();
                        if (!this.shouldTrackBlock(block)) continue;
                        class_2338 absolutePos = new class_2338(chunk.method_12004().method_8326() + x, startY + y, chunk.method_12004().method_8328() + z);
                        if (block instanceof class_2344) {
                            growingBlocks.addFirst(absolutePos);
                            continue;
                        }
                        growingBlocks.add(absolutePos);
                    }
                }
            }
        }
        if (!growingBlocks.isEmpty()) {
            data.tickTime = world.method_75260();
            data.positions.clear();
            data.positions.addAll(growingBlocks);
            TimeTickComponents.CHUNK_DATA.sync((Object)chunk);
        }
    }

    private void TickChunk(class_3218 world, class_2818 chunk) {
        CachedChunkData data = (CachedChunkData)TimeTickComponents.CHUNK_DATA.get((Object)chunk);
        long currentTick = world.method_75260();
        long lastSavedTime = data.tickTime;
        if (lastSavedTime <= 0L) {
            return;
        }
        long ticksPassed = currentTick - lastSavedTime;
        if (ticksPassed > 0L && !data.positions.isEmpty()) {
            int randomTickSpeed = (Integer)world.method_64395().method_76185(class_1928.field_19399);
            float expectedTicks = (float)ticksPassed * ((float)randomTickSpeed / 4096.0f);
            int baseCalls = (int)expectedTicks;
            float chanceForExtra = expectedTicks - (float)baseCalls;
            ArrayList<class_2338> blocksToTick = new ArrayList<class_2338>(data.positions);
            for (class_2338 pos : blocksToTick) {
                TASK_QUEUE.add(() -> {
                    class_2680 currentState = world.method_8320(pos);
                    if (this.shouldTrackBlock(currentState.method_26204())) {
                        class_2680 stateInLoop;
                        int calls = baseCalls;
                        if (world.field_9229.method_43057() < chanceForExtra) {
                            ++calls;
                        }
                        for (int i = 0; i < calls && this.shouldTrackBlock((stateInLoop = world.method_8320(pos)).method_26204()); ++i) {
                            stateInLoop.method_26199(world, pos, world.field_9229);
                        }
                    }
                });
            }
        }
        data.positions.clear();
        data.tickTime = -1L;
    }

    private boolean IsBlockTicking(class_3194 type) {
        return switch (type) {
            case class_3194.field_13877, class_3194.field_44856 -> true;
            default -> false;
        };
    }

    private boolean shouldTrackBlock(class_2248 block) {
        return block instanceof class_2302 || block instanceof class_2473 || block instanceof class_2513 || block instanceof class_2282 || block instanceof class_2523 || block instanceof class_2266 || block instanceof class_3830 || block instanceof class_2397 || block instanceof class_2344;
    }
}

