/*
 * Decompiled with CFR 0.152.
 */
package com.luzyvert.timetick;

import com.luzyvert.timetick.CachedChunkData;
import com.luzyvert.timetick.ChunkLevelEvents;
import com.luzyvert.timetick.TimeTickComponents;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_2248;
import net.minecraft.class_2266;
import net.minecraft.class_2282;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2397;
import net.minecraft.class_2473;
import net.minecraft.class_2513;
import net.minecraft.class_2523;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3194;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3830;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeTick
implements ModInitializer {
    public static final String MOD_ID = "timetick";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"timetick");
    private static final Queue<Runnable> TASK_QUEUE = new ConcurrentLinkedQueue<Runnable>();
    private static final Map<Long, Boolean> SPAWN_CHUNK_MAP = new HashMap<Long, Boolean>();
    private final int spawnChunkRadius = 11;
    private int tickCounter = 0;

    public void onInitialize() {
        LOGGER.info("TimeTick initializing");
        ServerChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            if (this.isSpawnChunk(world, chunk.method_12004()) && !this.isSpawnChunkTicking(world, chunk.method_12004())) {
                return;
            }
            this.TickChunk(world, chunk);
        });
        ChunkLevelEvents.CHUNK_LEVEL_TYPE_CHANGE.register((world, chunk, oldLevelType, newLevelType) -> {
            if (chunk == null) {
                return;
            }
            if (this.IsBlockTicking(newLevelType)) {
                if (!this.IsBlockTicking(oldLevelType)) {
                    this.TickChunk(world, chunk);
                }
                return;
            }
            this.SaveChunkTime(world, chunk);
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (this.tickCounter++ % 20 == 0) {
                this.SpawnChunkLogic(server);
            }
            if (TASK_QUEUE.isEmpty()) {
                return;
            }
            long startTime = System.nanoTime();
            long MAX_TIME_NS = 35000000L;
            while (!TASK_QUEUE.isEmpty()) {
                Runnable task = TASK_QUEUE.poll();
                if (task != null) {
                    try {
                        task.run();
                    }
                    catch (Exception e) {
                        LOGGER.error("Error processing growth task", (Throwable)e);
                    }
                }
                if (System.nanoTime() - startTime <= MAX_TIME_NS) continue;
                break;
            }
        });
    }

    public boolean isSpawnChunk(class_3218 world, class_1923 chunkPos) {
        class_1923 spawnChunk = new class_1923(world.method_43126());
        int dx = Math.abs(chunkPos.field_9181 - spawnChunk.field_9181);
        int dz = Math.abs(chunkPos.field_9180 - spawnChunk.field_9180);
        return dx <= 11 && dz <= 11;
    }

    public boolean isSpawnChunkTicking(class_3218 world, class_1923 chunkPos) {
        List players = world.method_18456();
        for (class_3222 player : players) {
            if (!(player.method_5649((double)chunkPos.field_9181, player.method_23318(), (double)chunkPos.field_9180) < 16384.0)) continue;
            return true;
        }
        return false;
    }

    private void SpawnChunkLogic(MinecraftServer server) {
        class_3218 world = server.method_30002();
        class_1923 spawnCenter = new class_1923(world.method_43126());
        List players = world.method_18456();
        for (int x = -11; x <= 11; ++x) {
            for (int z = -11; z <= 11; ++z) {
                long chunkPosLong = class_1923.method_8331((int)(spawnCenter.field_9181 + x), (int)(spawnCenter.field_9180 + z));
                if (!world.method_39425(chunkPosLong)) continue;
                boolean isRandomTicking = false;
                boolean prevRandomTicking = SPAWN_CHUNK_MAP.getOrDefault(chunkPosLong, false);
                double chunkX = (spawnCenter.field_9181 + x) * 16 + 8;
                double chunkZ = (spawnCenter.field_9180 + z) * 16 + 8;
                for (class_3222 player : players) {
                    if (!(player.method_5649(chunkX, player.method_23318(), chunkZ) < 16384.0)) continue;
                    isRandomTicking = true;
                    break;
                }
                if (prevRandomTicking == isRandomTicking) continue;
                class_1923 pos = new class_1923(chunkPosLong);
                if (isRandomTicking) {
                    this.TickChunk(world, world.method_8497(pos.field_9181, pos.field_9180));
                } else {
                    this.SaveChunkTime(world, world.method_8497(pos.field_9181, pos.field_9180));
                }
                SPAWN_CHUNK_MAP.put(chunkPosLong, isRandomTicking);
            }
        }
    }

    private void SaveChunkTime(class_3218 world, class_2818 chunk) {
        if (!this.isSpawnChunk(world, chunk.method_12004()) && this.IsBlockTicking(chunk.method_12225())) {
            return;
        }
        CachedChunkData data = (CachedChunkData)TimeTickComponents.CHUNK_DATA.get((Object)chunk);
        ArrayList<class_2338> growingBlocks = new ArrayList<class_2338>();
        class_2826[] sections = chunk.method_12006();
        for (int i = 0; i < sections.length; ++i) {
            class_2826 section = sections[i];
            if (section == null || section.method_38292() || !section.method_12262()) continue;
            int startY = chunk.method_31607() + i * 16;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < 16; ++y) {
                        class_2680 state = section.method_12254(x, y, z);
                        class_2248 block = state.method_26204();
                        if (!this.shouldTrackBlock(block)) continue;
                        class_2338 absolutePos = new class_2338(chunk.method_12004().method_8326() + x, startY + y, chunk.method_12004().method_8328() + z);
                        if (block instanceof class_2344) {
                            growingBlocks.add(0, absolutePos);
                            continue;
                        }
                        growingBlocks.add(absolutePos);
                    }
                }
            }
        }
        if (!growingBlocks.isEmpty()) {
            data.tickTime = world.method_8510();
            data.positions.clear();
            data.positions.addAll(growingBlocks);
            TimeTickComponents.CHUNK_DATA.sync((Object)chunk);
        }
    }

    private void TickChunk(class_3218 world, class_2818 chunk) {
        CachedChunkData data = (CachedChunkData)TimeTickComponents.CHUNK_DATA.get((Object)chunk);
        long currentTick = world.method_8510();
        long lastSavedTime = data.tickTime;
        if (lastSavedTime <= 0L) {
            return;
        }
        long ticksPassed = currentTick - lastSavedTime;
        if (ticksPassed > 0L && !data.positions.isEmpty()) {
            int randomTickSpeed = world.method_8450().method_8356(class_1928.field_19399);
            float expectedTicks = (float)ticksPassed * ((float)randomTickSpeed / 4096.0f);
            int baseCalls = (int)expectedTicks;
            float chanceForExtra = expectedTicks - (float)baseCalls;
            ArrayList<class_2338> blocksToTick = new ArrayList<class_2338>(data.positions);
            for (class_2338 pos : blocksToTick) {
                TASK_QUEUE.add(() -> {
                    class_2680 currentState = world.method_8320(pos);
                    if (this.shouldTrackBlock(currentState.method_26204())) {
                        class_2680 stateInLoop;
                        int calls = baseCalls;
                        if (world.field_9229.method_43057() < chanceForExtra) {
                            ++calls;
                        }
                        for (int i = 0; i < calls && this.shouldTrackBlock((stateInLoop = world.method_8320(pos)).method_26204()); ++i) {
                            stateInLoop.method_26199(world, pos, world.field_9229);
                        }
                    }
                });
            }
        }
        data.positions.clear();
        data.tickTime = -1L;
    }

    private boolean IsBlockTicking(class_3194 type) {
        return switch (type) {
            case class_3194.field_13877, class_3194.field_44856 -> true;
            default -> false;
        };
    }

    private boolean shouldTrackBlock(class_2248 block) {
        return block instanceof class_2302 || block instanceof class_2473 || block instanceof class_2513 || block instanceof class_2282 || block instanceof class_2523 || block instanceof class_2266 || block instanceof class_3830 || block instanceof class_2397 || block instanceof class_2344;
    }
}

