/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.client;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;

public class PartyHudClientState {
    private static PartyState CURRENT_PARTY;
    private static final List<PartyMemberClient> MEMBERS;

    public static PartyState getPartyState() {
        return CURRENT_PARTY;
    }

    public static boolean isLocalLeader() {
        PartyState state = PartyHudClientState.getPartyState();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || state == null || state.leaderId() == null) {
            return false;
        }
        return state.leaderId().equals(mc.f_91074_.m_20148_());
    }

    public static void setPartyState(UUID partyId, UUID leaderId, List<UUID> members, Map<UUID, String> names) {
        if (partyId == null || leaderId == null || members == null || members.isEmpty()) {
            CURRENT_PARTY = null;
        } else {
            HashMap<UUID, String> copyNames = names != null ? new HashMap<UUID, String>(names) : new HashMap();
            CURRENT_PARTY = new PartyState(partyId, leaderId, List.copyOf(members), copyNames);
        }
    }

    public static void clearParty() {
        CURRENT_PARTY = null;
    }

    public static List<PartyMemberClient> getMembers() {
        return MEMBERS;
    }

    public static void clear() {
        MEMBERS.clear();
    }

    static {
        MEMBERS = new ArrayList<PartyMemberClient>();
    }

    public record PartyState(UUID partyId, UUID leaderId, List<UUID> members, Map<UUID, String> names) {
    }

    public record PartyMemberClient(UUID uuid, GameProfile profile, Vec3 pos, double distance) {
    }
}

