/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.client;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;

public class PartyHudHealthRegistry {
    private static final Map<UUID, PlayerHudData> DATA = new HashMap<UUID, PlayerHudData>();

    public static void setData(UUID uuid, PlayerHudData data) {
        if (data == null) {
            DATA.remove(uuid);
            return;
        }
        data.lastUpdate = System.currentTimeMillis();
        DATA.put(uuid, data);
    }

    public static PlayerHudData getData(UUID uuid) {
        PlayerHudData d = DATA.get(uuid);
        if (d == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        if (now - d.lastUpdate > 15000L) {
            DATA.remove(uuid);
            return null;
        }
        return d;
    }

    public static void updateAllTrails() {
        DATA.replaceAll((uuid, data) -> {
            if (data != null && data.maxHp > 0.0f) {
                data.updateTrail(data.hp);
            }
            return data;
        });
    }

    public static void removeIf(Predicate<UUID> predicate) {
        DATA.keySet().removeIf(predicate);
    }

    public static void cleanGhosts() {
        Minecraft mc = Minecraft.m_91087_();
        ClientPacketListener connection = mc.m_91403_();
        if (connection == null) {
            return;
        }
        HashSet<UUID> onlineUuids = new HashSet<UUID>();
        for (PlayerInfo info : connection.m_105142_()) {
            onlineUuids.add(info.m_105312_().getId());
        }
        DATA.keySet().removeIf(uuid -> !onlineUuids.contains(uuid));
    }

    public static void clear() {
        DATA.clear();
    }

    public static class PlayerHudData {
        public float hp;
        public float maxHp;
        public float absorption;
        public boolean poison;
        public boolean regen;
        public boolean wither;
        public boolean freezing;
        public float trailHp;
        public long lastUpdate;

        public PlayerHudData(float hp, float maxHp, float absorption, boolean poison, boolean regen, boolean wither, boolean freezing) {
            this.hp = hp;
            this.maxHp = maxHp;
            this.absorption = absorption;
            this.poison = poison;
            this.regen = regen;
            this.wither = wither;
            this.freezing = freezing;
            this.trailHp = hp;
            this.lastUpdate = System.currentTimeMillis();
        }

        public void updateTrail(float targetHp) {
            float lerpSpeed = 0.08f;
            this.trailHp += lerpSpeed * (targetHp - this.trailHp);
        }
    }
}

