/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.client;

import com.everydayxp.partyhud.client.ClientHooks;
import com.everydayxp.partyhud.client.PartyHudHealthRegistry;
import com.everydayxp.partyhud.client.hud.HudCommon;
import com.everydayxp.partyhud.client.hud.SkinCache;
import com.everydayxp.partyhud.config.ClientConfig;
import com.everydayxp.partyhud.network.PartyHudNetwork;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffects;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="partyhud", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class PartyHudKeys {
    public static final KeyMapping OPEN_PARTY_HUD_SCREEN = new KeyMapping("key.partyhud.open_screen", 72, "key.categories.partyhud");

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(OPEN_PARTY_HUD_SCREEN);
    }

    @Mod.EventBusSubscriber(modid="partyhud", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ClientTickHandler {
        private static int tickCounter = 0;

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer local = mc.f_91074_;
            if (++tickCounter % 40 == 0) {
                SkinCache.updateAllSkins();
            }
            PartyHudHealthRegistry.updateAllTrails();
            boolean devMode = (Boolean)ClientConfig.DEV_SHOW_SELF.get();
            if (local != null && devMode) {
                UUID selfId = local.m_20148_();
                PartyHudHealthRegistry.PlayerHudData selfData = PartyHudHealthRegistry.getData(selfId);
                if (selfData == null) {
                    selfData = new PartyHudHealthRegistry.PlayerHudData(local.m_21223_(), local.m_21233_(), local.m_6103_(), local.m_21023_(MobEffects.f_19614_), local.m_21023_(MobEffects.f_19605_), local.m_21023_(MobEffects.f_19615_), HudCommon.isFreezing((AbstractClientPlayer)local));
                } else {
                    selfData.hp = local.m_21223_();
                    selfData.maxHp = local.m_21233_();
                    selfData.absorption = local.m_6103_();
                    selfData.poison = local.m_21023_(MobEffects.f_19614_);
                    selfData.regen = local.m_21023_(MobEffects.f_19605_);
                    selfData.wither = local.m_21023_(MobEffects.f_19615_);
                    selfData.freezing = HudCommon.isFreezing((AbstractClientPlayer)local);
                }
                PartyHudHealthRegistry.setData(selfId, selfData);
            }
            while (OPEN_PARTY_HUD_SCREEN.m_90859_()) {
                if (local == null) {
                    return;
                }
                ClientHooks.openPartyHudPlayersScreen();
                PartyHudNetwork.CHANNEL.sendToServer((Object)new PartyHudNetwork.RequestPlayersListC2SPacket());
                mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            }
        }
    }
}

