/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.client;

import com.everydayxp.partyhud.network.PlayerEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class PartyHudPlayerRegistry {
    private static final Map<UUID, String> NAMES = new HashMap<UUID, String>();
    private static final List<PlayerEntry> PLAYERS = new ArrayList<PlayerEntry>();

    public static void setPlayers(List<PlayerEntry> list) {
        PLAYERS.clear();
        PLAYERS.addAll(list);
        for (PlayerEntry e : list) {
            NAMES.put(e.uuid(), e.name());
        }
    }

    public static void registerDevName(UUID uuid, String name) {
        NAMES.put(uuid, name);
    }

    public static List<PlayerEntry> getPlayers() {
        return Collections.unmodifiableList(PLAYERS);
    }

    public static String getName(UUID uuid) {
        return NAMES.get(uuid);
    }

    public static boolean isOnline(UUID uuid) {
        for (PlayerEntry e : PLAYERS) {
            if (!e.uuid().equals(uuid)) continue;
            return true;
        }
        return false;
    }
}

