/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.client.hud;

import java.util.Collection;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;

public class HudCommon {
    public static int getHealthBarColor(AbstractClientPlayer target) {
        MobEffect type;
        int color = -3407872;
        Collection effects = target.m_21220_();
        for (MobEffectInstance effect : effects) {
            type = effect.m_19544_();
            if (type != MobEffects.f_19615_) continue;
            return -14675936;
        }
        for (MobEffectInstance effect : effects) {
            type = effect.m_19544_();
            if (type == MobEffects.f_19614_) {
                color = -16733696;
                continue;
            }
            if (type != MobEffects.f_19605_ || color != -3407872) continue;
            color = -13312;
        }
        return color;
    }

    public static String buildHpText(AbstractClientPlayer target, float hp, float maxHp) {
        int hpInt = hp > 0.0f ? (int)Math.ceil(hp) : 0;
        int maxInt = (int)Math.ceil(maxHp);
        String hpText = hpInt + "/" + maxInt;
        float absorption = target.m_6103_();
        if (absorption > 0.0f) {
            int extraHearts = Math.round(absorption / 2.0f);
            hpText = hpText + " +" + extraHearts;
        }
        return hpText;
    }

    public static String buildHpPercentText(float hp, float maxHp) {
        if (maxHp <= 0.0f) {
            return "0%";
        }
        int pct = Math.round(hp / maxHp * 100.0f);
        return pct + "%";
    }

    public static boolean isFreezing(AbstractClientPlayer player) {
        int frozen = player.m_146888_();
        int required = player.m_146891_();
        return frozen > 0 && frozen >= required / 4;
    }

    public static void renderHead(GuiGraphics g, ResourceLocation skin, int x, int y, int size) {
        g.m_280411_(skin, x, y, size, size, 8.0f, 8.0f, 8, 8, 64, 64);
        g.m_280411_(skin, x, y, size, size, 40.0f, 8.0f, 8, 8, 64, 64);
    }

    public static void fillRect(GuiGraphics g, int x, int y, int w, int h, int color) {
        g.m_280509_(x, y, x + w, y + h, color);
    }
}

