/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.client.hud;

import com.everydayxp.partyhud.client.PartyHudClientState;
import com.everydayxp.partyhud.client.PartyHudHealthRegistry;
import com.everydayxp.partyhud.client.PartyHudPlayerRegistry;
import com.everydayxp.partyhud.client.hud.CompactHudOverlay;
import com.everydayxp.partyhud.client.hud.ModernHudOverlay;
import com.everydayxp.partyhud.client.hud.RpgHudOverlay;
import com.everydayxp.partyhud.client.hud.SkinCache;
import com.everydayxp.partyhud.client.hud.StandardHudOverlay;
import com.everydayxp.partyhud.config.ClientConfig;
import com.everydayxp.partyhud.config.OverlayPosition;
import com.everydayxp.partyhud.config.OverlayStyle;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;

public class PartyHudRenderer {
    private static final List<UUID> ORDERED_PARTY = new ArrayList<UUID>();

    public static void render(GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer local = mc.f_91074_;
        if (local == null) {
            return;
        }
        int maxTracked = (Integer)ClientConfig.MAX_TRACKED_PLAYERS.get();
        PartyHudClientState.PartyState state = PartyHudClientState.getPartyState();
        LinkedHashSet<UUID> partyMembers = new LinkedHashSet<UUID>();
        UUID localUuid = local.m_20148_();
        if (state != null && !state.members().isEmpty()) {
            partyMembers.addAll(state.members());
            partyMembers.remove(localUuid);
        } else if (((Boolean)ClientConfig.DEV_SHOW_SELF.get()).booleanValue()) {
            for (int i = 0; i < maxTracked; ++i) {
                UUID uUID = new UUID(0L, 1000L + (long)i);
                String fakeName = "DevPlayer" + (i + 1);
                PartyHudPlayerRegistry.registerDevName(uUID, fakeName);
                PartyHudHealthRegistry.PlayerHudData data = new PartyHudHealthRegistry.PlayerHudData(10.0f + (float)i * 2.0f, 20.0f, 0.0f, false, false, false, false);
                PartyHudHealthRegistry.setData(uUID, data);
                SkinCache.assignDefaultSkin(uUID);
                partyMembers.add(uUID);
            }
        } else {
            return;
        }
        for (UUID uUID : partyMembers) {
            if (ORDERED_PARTY.contains(uUID)) continue;
            ORDERED_PARTY.add(uUID);
        }
        ORDERED_PARTY.removeIf(id -> !partyMembers.contains(id));
        ArrayList<UUID> visibleUuids = new ArrayList<UUID>();
        for (UUID id3 : ORDERED_PARTY) {
            if (visibleUuids.size() >= maxTracked) break;
            visibleUuids.add(id3);
        }
        if (visibleUuids.isEmpty()) {
            return;
        }
        float f = (float)((Integer)ClientConfig.BAR_SCALE.get()).intValue() / 100.0f;
        int baseFrameHeight = 16;
        int faceBaseSize = Math.round((float)baseFrameHeight * 1.25f);
        int faceSize = Math.round((float)faceBaseSize * f);
        int barWidth = 96;
        int frameWidth = faceSize + barWidth;
        int effectiveHeight = faceSize;
        int baseGap = 4;
        int gap = Math.max(2, Math.round((float)baseGap * f));
        OverlayPosition pos = (OverlayPosition)((Object)ClientConfig.OVERLAY_POSITION.get());
        OverlayStyle style = (OverlayStyle)((Object)ClientConfig.OVERLAY_STYLE.get());
        int[] base = PartyHudRenderer.computeBasePos(pos, screenWidth, screenHeight, frameWidth, effectiveHeight, visibleUuids.size(), gap);
        int baseX = base[0];
        int baseY = base[1];
        for (int i = 0; i < visibleUuids.size(); ++i) {
            UUID uuid = (UUID)visibleUuids.get(i);
            int x = baseX;
            int y = baseY + i * (effectiveHeight + gap);
            PartyHudRenderer.renderPartyEntry(graphics, uuid, x, y, frameWidth, baseFrameHeight, style);
        }
    }

    private static void renderPartyEntry(GuiGraphics g, UUID uuid, int x, int y, int width, int height, OverlayStyle style) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer local = mc.f_91074_;
        PartyHudHealthRegistry.PlayerHudData data = PartyHudHealthRegistry.getData(uuid);
        if (data == null && ((Boolean)ClientConfig.DEV_SHOW_SELF.get()).booleanValue() && local != null && local.m_20148_().equals(uuid)) {
            data = new PartyHudHealthRegistry.PlayerHudData(local.m_21223_(), local.m_21233_(), local.m_6103_(), false, false, false, false);
            PartyHudHealthRegistry.setData(uuid, data);
        }
        if (data == null || data.maxHp <= 0.0f) {
            return;
        }
        String name = null;
        PartyHudClientState.PartyState state = PartyHudClientState.getPartyState();
        if (state != null && state.names() != null) {
            name = state.names().get(uuid);
        }
        if (name == null || name.isEmpty()) {
            name = PartyHudPlayerRegistry.getName(uuid);
        }
        if (name == null || name.isEmpty()) {
            name = Component.m_237115_((String)"partyhud.player.unknown").getString();
        }
        float hp = data.hp;
        float maxHp = data.maxHp;
        float ratio = maxHp > 0.0f ? hp / maxHp : 0.0f;
        switch (style) {
            case MODERN: {
                ModernHudOverlay.renderFar(g, uuid, name, data, x, y, width, height, ratio);
                break;
            }
            case COMPACT: {
                CompactHudOverlay.renderFar(g, uuid, name, data, x, y, width, height, ratio);
                break;
            }
            case STANDARD: {
                StandardHudOverlay.renderFar(g, uuid, name, data, x, y, width, height, ratio);
                break;
            }
            case RPG: {
                RpgHudOverlay.renderFar(g, uuid, name, data, x, y, width, height, ratio);
            }
        }
    }

    private static int[] computeBasePos(OverlayPosition pos, int screenWidth, int screenHeight, int frameWidth, int frameHeight, int frameCount, int gap) {
        int totalHeight = frameCount * frameHeight + (frameCount - 1) * gap;
        int x = 0;
        int y = 0;
        switch (pos) {
            case TOP_LEFT: {
                x = 10;
                y = 10;
                break;
            }
            case TOP_RIGHT: {
                x = screenWidth - frameWidth - 10;
                y = 10;
                break;
            }
            case BOTTOM_LEFT: {
                x = 10;
                y = screenHeight - totalHeight - 10;
                break;
            }
            case BOTTOM_RIGHT: {
                x = screenWidth - frameWidth - 10;
                y = screenHeight - totalHeight - 10;
                break;
            }
            case CENTER_LEFT: {
                x = 10;
                y = (screenHeight - totalHeight) / 2;
                break;
            }
            case CENTER_RIGHT: {
                x = screenWidth - frameWidth - 10;
                y = (screenHeight - totalHeight) / 2;
                break;
            }
            case TOP_CENTER: {
                x = (screenWidth - frameWidth) / 2;
                y = 10;
                break;
            }
            case BOTTOM_CENTER: {
                x = (screenWidth - frameWidth) / 2;
                y = screenHeight - totalHeight - 10;
            }
        }
        return new int[]{x, y};
    }
}

