/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.client.hud;

import com.everydayxp.partyhud.client.PartyHudClientState;
import com.everydayxp.partyhud.client.PartyHudPositionRegistry;
import com.everydayxp.partyhud.client.hud.HudCommon;
import com.everydayxp.partyhud.client.hud.SkinCache;
import com.everydayxp.partyhud.config.ClientConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class PartyTrackerRenderer {
    public static void render(GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight, Matrix4f projectionMatrix, Matrix4f modelViewMatrix) {
        if (!((Boolean)ClientConfig.ENABLE_TRACKER.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer local = mc.f_91074_;
        if (local == null || mc.f_91073_ == null) {
            return;
        }
        PartyHudClientState.PartyState state = PartyHudClientState.getPartyState();
        if (state == null || state.members().isEmpty()) {
            return;
        }
        HashSet<UUID> members = new HashSet<UUID>(state.members());
        Camera camera = mc.f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        PoseStack matrixStackWorld = new PoseStack();
        Vector4f origin4f = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        for (UUID uuid : members) {
            double distance;
            PartyHudPositionRegistry.PosData posData;
            if (uuid.equals(local.m_20148_()) || (posData = PartyHudPositionRegistry.get(uuid)) == null) continue;
            Vec3 playerPos = new Vec3(posData.x, posData.y, posData.z);
            double offX = playerPos.f_82479_ - cameraPos.f_82479_;
            double offY = playerPos.f_82480_ - cameraPos.f_82480_ + 0.5;
            double offZ = playerPos.f_82481_ - cameraPos.f_82481_;
            Vector3f lookVector = camera.m_253058_();
            double depth = offX * (double)lookVector.x() + offY * (double)lookVector.y() + offZ * (double)lookVector.z();
            if (depth < 0.05 || (distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ)) < 16.0) continue;
            if (distance > 100000.0) {
                double scaler = 100000.0 / distance;
                offX *= scaler;
                offY *= scaler;
                offZ *= scaler;
            }
            matrixStackWorld.m_85836_();
            matrixStackWorld.m_85850_().m_252922_().mul((Matrix4fc)modelViewMatrix);
            matrixStackWorld.m_85837_(offX, offY, offZ);
            origin4f.set(0.0f, 0.0f, 0.0f, 1.0f);
            origin4f.mul((Matrix4fc)matrixStackWorld.m_85850_().m_252922_());
            matrixStackWorld.m_85849_();
            origin4f.mul((Matrix4fc)projectionMatrix);
            float screenX = (1.0f + origin4f.x() / origin4f.w()) / 2.0f * (float)screenWidth;
            float screenY = (1.0f - origin4f.y() / origin4f.w()) / 2.0f * (float)screenHeight;
            int x = Math.round(screenX);
            int y = Math.round(screenY);
            if (x < 8 || y < 8 || x >= screenWidth - 8 || y >= screenHeight - 8) continue;
            PartyTrackerRenderer.renderTrackerIcon(graphics, uuid, x, y, (int)distance);
        }
    }

    private static void renderTrackerIcon(GuiGraphics g, UUID uuid, int x, int y, int distance) {
        Minecraft mc = Minecraft.m_91087_();
        int size = 8;
        int half = size / 2;
        ResourceLocation skin = SkinCache.getSkin(uuid);
        if (skin != null) {
            g.m_280168_().m_85836_();
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
            HudCommon.renderHead(g, skin, x - half, y - half, size);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            g.m_280168_().m_85849_();
        } else {
            HudCommon.fillRect(g, x - half, y - half, size, size, -12303292);
        }
        String distText = distance + "m";
        g.m_280168_().m_85836_();
        g.m_280168_().m_85841_(0.7f, 0.7f, 1.0f);
        int scaledX = (int)((float)x / 0.7f);
        int scaledY = (int)((float)(y + half + 2) / 0.7f);
        int textWidth = mc.f_91062_.m_92895_(distText);
        int textX = scaledX - textWidth / 2;
        g.m_280056_(mc.f_91062_, distText, textX, scaledY, -1, true);
        g.m_280168_().m_85849_();
    }
}

