/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.client.hud;

import com.everydayxp.partyhud.client.PartyHudHealthRegistry;
import com.everydayxp.partyhud.client.hud.HudCommon;
import com.everydayxp.partyhud.client.hud.SkinCache;
import com.everydayxp.partyhud.config.ClientConfig;
import com.everydayxp.partyhud.config.HealthTextMode;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class StandardHudOverlay {
    public static void renderFar(GuiGraphics g, UUID uuid, String name, PartyHudHealthRegistry.PlayerHudData data, int x, int y, int width, int height, float ratio) {
        float trailRatio;
        int trailFilled;
        if (data == null || data.maxHp <= 0.0f) {
            return;
        }
        float barScale = (float)((Integer)ClientConfig.BAR_SCALE.get()).intValue() / 100.0f;
        g.m_280168_().m_85836_();
        g.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        g.m_280168_().m_85841_(barScale, barScale, 1.0f);
        int alpha = (Integer)ClientConfig.HUD_ALPHA.get() & 0xFF;
        int textColor = alpha << 24 | 0xFFFFFF;
        int faceSize = (int)((float)height * 1.25f);
        int faceX = -2;
        int faceY = -2;
        int barHeight = height / 2;
        int barWidth = 48;
        int barX = faceX + faceSize + 2;
        int faceBottom = faceY + faceSize;
        int barY = faceBottom - barHeight - 1;
        ResourceLocation skin = SkinCache.getSkin(uuid);
        if (skin != null) {
            HudCommon.renderHead(g, skin, faceX, faceY, faceSize);
        } else {
            HudCommon.fillRect(g, faceX, faceY, faceSize, faceSize, -12303292);
        }
        int bgColor = alpha << 24 | 0x202020;
        int bgX1 = barX - 1;
        int bgY1 = barY - 1;
        int bgX2 = barX + barWidth + 1;
        int bgY2 = barY + barHeight + 1;
        g.m_280509_(bgX1, bgY1, bgX2, bgY2, bgColor);
        int barInnerY = barY;
        int emptyBarColor = alpha << 24 | 0x303030;
        g.m_280509_(barX, barInnerY, barX + barWidth, barInnerY + barHeight, emptyBarColor);
        if (data.trailHp > 0.0f && data.maxHp > 0.0f && (trailFilled = (int)((float)barWidth * (trailRatio = data.trailHp / data.maxHp))) > 0) {
            int trailColorRgb = 0x660000;
            int trailColor = alpha << 24 | trailColorRgb;
            g.m_280509_(barX, barInnerY, barX + trailFilled, barInnerY + barHeight, trailColor);
        }
        int filled = (int)((float)barWidth * ratio);
        int barColorRgb = 0xCC0000;
        if (data.wither) {
            barColorRgb = 0x201020;
        } else if (data.poison) {
            barColorRgb = 43520;
        } else if (data.regen) {
            barColorRgb = 0xFFCC00;
        }
        if (data.freezing) {
            barColorRgb = 10543359;
        }
        int barColor = alpha << 24 | barColorRgb;
        g.m_280509_(barX, barInnerY, barX + filled, barInnerY + barHeight, barColor);
        Font font = Minecraft.m_91087_().f_91062_;
        float textScale = 0.75f;
        HealthTextMode mode = (HealthTextMode)((Object)ClientConfig.HEALTH_TEXT_MODE.get());
        String hpTextToDraw = switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case HealthTextMode.VALUE -> {
                int hpInt = data.hp > 0.0f ? (int)Math.ceil(data.hp) : 0;
                int maxInt = (int)Math.ceil(data.maxHp);
                String t = hpInt + "/" + maxInt;
                if (data.absorption > 0.0f) {
                    int extraHealth = Math.round(data.absorption);
                    t = t + " +" + extraHealth;
                }
                yield t;
            }
            case HealthTextMode.PERCENT -> {
                int pct = data.maxHp > 0.0f ? Math.round(data.hp / data.maxHp * 100.0f) : 0;
                yield pct + "%";
            }
            case HealthTextMode.NONE -> "";
        };
        g.m_280168_().m_85836_();
        g.m_280168_().m_85841_(textScale, textScale, 1.0f);
        int scaledBarX = (int)((float)barX / textScale);
        int scaledBarWidth = (int)((float)barWidth / textScale);
        int scaledBarY = (int)((float)barInnerY / textScale);
        int centerY = scaledBarY + (int)((float)(barHeight - 8) / 2.0f / textScale) + 2;
        if (!hpTextToDraw.isEmpty()) {
            int textWidth = font.m_92895_(hpTextToDraw);
            int textX = scaledBarX + (scaledBarWidth - textWidth) / 2;
            g.m_280056_(font, hpTextToDraw, textX, centerY, textColor, false);
        }
        if (((Boolean)ClientConfig.SHOW_NAMES.get()).booleanValue()) {
            int nameX = scaledBarX + 2;
            int nameY = scaledBarY - 10;
            g.m_280056_(font, name, nameX, nameY, textColor, true);
        }
        g.m_280168_().m_85849_();
        g.m_280168_().m_85849_();
    }
}

