/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.config;

import com.everydayxp.partyhud.config.HealthTextMode;
import com.everydayxp.partyhud.config.OverlayPosition;
import com.everydayxp.partyhud.config.OverlayStyle;
import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.EnumValue<OverlayPosition> OVERLAY_POSITION;
    public static final ForgeConfigSpec.EnumValue<OverlayStyle> OVERLAY_STYLE;
    public static final ForgeConfigSpec.IntValue MAX_TRACKED_PLAYERS;
    public static final ForgeConfigSpec.IntValue HUD_ALPHA;
    public static final ForgeConfigSpec.BooleanValue SHOW_NAMES;
    public static final ForgeConfigSpec.EnumValue<HealthTextMode> HEALTH_TEXT_MODE;
    public static final ForgeConfigSpec.IntValue BAR_SCALE;
    public static final ForgeConfigSpec.BooleanValue ENABLE_TRACKER;
    public static final ForgeConfigSpec.BooleanValue DEV_SHOW_SELF;

    static {
        BUILDER.push("Party HUD Client");
        OVERLAY_POSITION = BUILDER.comment("Position of the party HUD overlay").defineEnum("overlayPosition", (Enum)OverlayPosition.CENTER_LEFT);
        OVERLAY_STYLE = BUILDER.comment("Overlay style: STANDARD, MODERN, COMPACT or RPG").defineEnum("overlayStyle", (Enum)OverlayStyle.STANDARD);
        MAX_TRACKED_PLAYERS = BUILDER.comment("Maximum number of nearby players to show in the HUD (1-6).").defineInRange("maxTrackedPlayers", 4, 1, 6);
        HUD_ALPHA = BUILDER.comment("HUD opacity (0 = invisible, 255 = fully opaque).").defineInRange("hudAlpha", 200, 0, 255);
        SHOW_NAMES = BUILDER.comment("Show player names on the party HUD.").define("showNames", true);
        HEALTH_TEXT_MODE = BUILDER.comment("Health text mode: NONE, VALUE, PERCENT.").defineEnum("healthTextMode", (Enum)HealthTextMode.VALUE);
        BAR_SCALE = BUILDER.comment("Global scale for party HUD bars (50-100, as percent of default size).").defineInRange("barScale", 100, 50, 100);
        ENABLE_TRACKER = BUILDER.comment("Enable 3D tracker overlay: shows player head icons floating at their position in world with distance").define("enableTracker", true);
        BUILDER.pop();
        BUILDER.push("Development");
        DEV_SHOW_SELF = BUILDER.comment("DEV: Show local player in HUD for overlay testing").define("dev_show_self", false);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

