/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.network;

import com.everydayxp.partyhud.server.PartyHudCommands;
import com.everydayxp.partyhud.server.PartyHudServerData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class KickFromPartyC2SPacket {
    private final UUID targetId;

    public KickFromPartyC2SPacket(UUID targetId) {
        this.targetId = targetId;
    }

    public static void encode(KickFromPartyC2SPacket msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.targetId);
    }

    public static KickFromPartyC2SPacket decode(FriendlyByteBuf buf) {
        return new KickFromPartyC2SPacket(buf.m_130259_());
    }

    public static void handle(KickFromPartyC2SPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            if (sender == null) {
                return;
            }
            UUID leaderId = PartyHudServerData.getLeader(sender.m_20148_(), sender);
            if (leaderId == null || !leaderId.equals(sender.m_20148_())) {
                sender.m_213846_((Component)Component.m_237115_((String)"partyhud.chat.only_leader_can_kick"));
                return;
            }
            MinecraftServer server = sender.m_20194_();
            if (server == null) {
                return;
            }
            ServerPlayer kicked = server.m_6846_().m_11259_(msg.targetId);
            if (kicked == null) {
                return;
            }
            PartyHudCommands.forceLeave(kicked);
            kicked.m_213846_((Component)Component.m_237110_((String)"partyhud.chat.kicked_from_party", (Object[])new Object[]{sender.m_7755_()}));
            sender.m_213846_((Component)Component.m_237110_((String)"partyhud.chat.you_kicked_player", (Object[])new Object[]{kicked.m_7755_()}));
        });
        ctx.setPacketHandled(true);
    }
}

