/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.network;

import com.everydayxp.partyhud.network.PartyHudNetwork;
import com.everydayxp.partyhud.network.SyncFavoritesS2CPacket;
import com.everydayxp.partyhud.server.PartyFavoritesSavedData;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class MarkFavoriteC2SPacket {
    private final UUID targetId;
    private final boolean add;

    public MarkFavoriteC2SPacket(UUID targetId, boolean add) {
        this.targetId = targetId;
        this.add = add;
    }

    public static void encode(MarkFavoriteC2SPacket msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.targetId);
        buf.writeBoolean(msg.add);
    }

    public static MarkFavoriteC2SPacket decode(FriendlyByteBuf buf) {
        UUID id = buf.m_130259_();
        boolean add = buf.readBoolean();
        return new MarkFavoriteC2SPacket(id, add);
    }

    public static void handle(MarkFavoriteC2SPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            if (sender == null) {
                return;
            }
            ServerLevel level = sender.m_284548_();
            PartyFavoritesSavedData data = PartyFavoritesSavedData.get(level);
            data.setFavorite(sender.m_20148_(), msg.targetId, msg.add);
            ArrayList<UUID> favList = new ArrayList<UUID>(data.getFavorites(sender.m_20148_()));
            PartyHudNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new SyncFavoritesS2CPacket(favList));
        });
        ctx.setPacketHandled(true);
    }
}

