/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.network;

import com.everydayxp.partyhud.client.PartyHudHealthRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public class PlayerHealthSyncS2CPacket {
    public final List<Entry> entries;

    public PlayerHealthSyncS2CPacket(List<Entry> entries) {
        this.entries = entries;
    }

    public static void encode(PlayerHealthSyncS2CPacket msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.entries.size());
        for (Entry e : msg.entries) {
            buf.m_130077_(e.uuid);
            buf.writeFloat(e.hp);
            buf.writeFloat(e.maxHp);
            buf.writeFloat(e.absorption);
            buf.writeBoolean(e.poison);
            buf.writeBoolean(e.regen);
            buf.writeBoolean(e.wither);
            buf.writeBoolean(e.freezing);
        }
    }

    public static PlayerHealthSyncS2CPacket decode(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        ArrayList<Entry> list = new ArrayList<Entry>();
        for (int i = 0; i < size; ++i) {
            UUID id = buf.m_130259_();
            float hp = buf.readFloat();
            float maxHp = buf.readFloat();
            float absorption = buf.readFloat();
            boolean poison = buf.readBoolean();
            boolean regen = buf.readBoolean();
            boolean wither = buf.readBoolean();
            boolean freezing = buf.readBoolean();
            list.add(new Entry(id, hp, maxHp, absorption, poison, regen, wither, freezing));
        }
        return new PlayerHealthSyncS2CPacket(list);
    }

    public static void handle(PlayerHealthSyncS2CPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            if (FMLEnvironment.dist.isClient()) {
                for (Entry e : msg.entries) {
                    PartyHudHealthRegistry.PlayerHudData data = new PartyHudHealthRegistry.PlayerHudData(e.hp, e.maxHp, e.absorption, e.poison, e.regen, e.wither, e.freezing);
                    PartyHudHealthRegistry.setData(e.uuid, data);
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public static class Entry {
        public UUID uuid;
        public float hp;
        public float maxHp;
        public float absorption;
        public boolean poison;
        public boolean regen;
        public boolean wither;
        public boolean freezing;

        public Entry(UUID uuid, float hp, float maxHp, float absorption, boolean poison, boolean regen, boolean wither, boolean freezing) {
            this.uuid = uuid;
            this.hp = hp;
            this.maxHp = maxHp;
            this.absorption = absorption;
            this.poison = poison;
            this.regen = regen;
            this.wither = wither;
            this.freezing = freezing;
        }
    }
}

