/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.network;

import com.everydayxp.partyhud.client.PartyHudHealthRegistry;
import com.everydayxp.partyhud.client.PartyHudPlayerRegistry;
import com.everydayxp.partyhud.client.PartyHudPlayersScreen;
import com.everydayxp.partyhud.network.PlayerEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public class PlayersListS2CPacket {
    public final List<PlayerEntry> players;

    public PlayersListS2CPacket(List<PlayerEntry> players) {
        this.players = players;
    }

    public static void encode(PlayersListS2CPacket msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.players.size());
        for (PlayerEntry e : msg.players) {
            buf.m_130077_(e.uuid());
            buf.m_130070_(e.name());
        }
    }

    public static PlayersListS2CPacket decode(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        ArrayList<PlayerEntry> list = new ArrayList<PlayerEntry>();
        for (int i = 0; i < size; ++i) {
            UUID id = buf.m_130259_();
            String name = buf.m_130136_(256);
            list.add(new PlayerEntry(id, name));
        }
        return new PlayersListS2CPacket(list);
    }

    public static void handle(PlayersListS2CPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            if (!FMLEnvironment.dist.isClient()) {
                return;
            }
            PartyHudPlayerRegistry.setPlayers(msg.players);
            Set online = msg.players.stream().map(PlayerEntry::uuid).collect(Collectors.toSet());
            PartyHudHealthRegistry.removeIf(uuid -> !online.contains(uuid));
            Minecraft mc = Minecraft.m_91087_();
            Screen patt2171$temp = mc.f_91080_;
            if (patt2171$temp instanceof PartyHudPlayersScreen) {
                PartyHudPlayersScreen screen = (PartyHudPlayersScreen)patt2171$temp;
                screen.refresh();
            }
        });
        ctx.setPacketHandled(true);
    }
}

