/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.network;

import com.everydayxp.partyhud.client.PartyHudClientState;
import com.everydayxp.partyhud.client.PartyHudPlayersScreen;
import com.everydayxp.partyhud.client.hud.SkinCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public class SyncPartyStateS2CPacket {
    public final UUID partyId;
    public final UUID leaderId;
    public final List<UUID> members;
    public final Map<UUID, String> names;

    public SyncPartyStateS2CPacket(UUID partyId, UUID leaderId, List<UUID> members, Map<UUID, String> names) {
        this.partyId = partyId;
        this.leaderId = leaderId;
        this.members = members;
        this.names = names;
    }

    public static void encode(SyncPartyStateS2CPacket msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.partyId != null);
        if (msg.partyId != null) {
            buf.m_130077_(msg.partyId);
        }
        buf.writeBoolean(msg.leaderId != null);
        if (msg.leaderId != null) {
            buf.m_130077_(msg.leaderId);
        }
        buf.m_130130_(msg.members.size());
        for (UUID uUID : msg.members) {
            buf.m_130077_(uUID);
        }
        buf.m_130130_(msg.names.size());
        for (Map.Entry entry : msg.names.entrySet()) {
            buf.m_130077_((UUID)entry.getKey());
            buf.m_130070_((String)entry.getValue());
        }
    }

    public static SyncPartyStateS2CPacket decode(FriendlyByteBuf buf) {
        UUID partyId = null;
        if (buf.readBoolean()) {
            partyId = buf.m_130259_();
        }
        UUID leaderId = null;
        if (buf.readBoolean()) {
            leaderId = buf.m_130259_();
        }
        int size = buf.m_130242_();
        ArrayList<UUID> members = new ArrayList<UUID>(size);
        for (int i = 0; i < size; ++i) {
            members.add(buf.m_130259_());
        }
        int nameSize = buf.m_130242_();
        HashMap<UUID, String> names = new HashMap<UUID, String>(nameSize);
        for (int i = 0; i < nameSize; ++i) {
            UUID id = buf.m_130259_();
            String name = buf.m_130136_(32);
            names.put(id, name);
        }
        return new SyncPartyStateS2CPacket(partyId, leaderId, members, names);
    }

    public static void handle(SyncPartyStateS2CPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            if (!FMLEnvironment.dist.isClient()) {
                return;
            }
            PartyHudClientState.setPartyState(msg.partyId, msg.leaderId, msg.members, msg.names);
            for (UUID memberId : msg.members) {
                SkinCache.preloadOfflineSkin(memberId);
            }
            Minecraft mc = Minecraft.m_91087_();
            Screen patt3281$temp = mc.f_91080_;
            if (patt3281$temp instanceof PartyHudPlayersScreen) {
                PartyHudPlayersScreen screen = (PartyHudPlayersScreen)patt3281$temp;
                screen.refresh();
            }
        });
        ctx.setPacketHandled(true);
    }
}

