/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class PartyFavoritesSavedData
extends SavedData {
    private static final String NAME = "partyhud_favorites";
    private final Map<UUID, Set<UUID>> favoritesByPlayer = new HashMap<UUID, Set<UUID>>();

    public static PartyFavoritesSavedData get(ServerLevel level) {
        return (PartyFavoritesSavedData)level.m_8895_().m_164861_(PartyFavoritesSavedData::load, PartyFavoritesSavedData::new, NAME);
    }

    public static PartyFavoritesSavedData load(CompoundTag tag) {
        PartyFavoritesSavedData data = new PartyFavoritesSavedData();
        ListTag playersList = tag.m_128437_("Players", 10);
        for (int i = 0; i < playersList.size(); ++i) {
            CompoundTag pTag = playersList.m_128728_(i);
            try {
                UUID ownerId = UUID.fromString(pTag.m_128461_("Owner"));
                ListTag favsTag = pTag.m_128437_("Favorites", 8);
                HashSet<UUID> favs = new HashSet<UUID>();
                for (int j = 0; j < favsTag.size(); ++j) {
                    try {
                        favs.add(UUID.fromString(favsTag.m_128778_(j)));
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                data.favoritesByPlayer.put(ownerId, favs);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag playersList = new ListTag();
        for (Map.Entry<UUID, Set<UUID>> entry : this.favoritesByPlayer.entrySet()) {
            CompoundTag pTag = new CompoundTag();
            pTag.m_128359_("Owner", entry.getKey().toString());
            ListTag favsTag = new ListTag();
            for (UUID fav : entry.getValue()) {
                favsTag.add((Object)StringTag.m_129297_((String)fav.toString()));
            }
            pTag.m_128365_("Favorites", (Tag)favsTag);
            playersList.add((Object)pTag);
        }
        tag.m_128365_("Players", (Tag)playersList);
        return tag;
    }

    public Set<UUID> getFavorites(UUID owner) {
        return this.favoritesByPlayer.computeIfAbsent(owner, k -> new HashSet());
    }

    public void setFavorite(UUID owner, UUID target, boolean add) {
        Set favs = this.favoritesByPlayer.computeIfAbsent(owner, k -> new HashSet());
        if (add) {
            favs.add(target);
        } else {
            favs.remove(target);
        }
        this.m_77762_();
    }
}

