/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.server;

import com.everydayxp.partyhud.server.PartyHudServerData;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PartyHudCommands {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"partyhud").then(Commands.m_82127_((String)"accept").then(Commands.m_82129_((String)"inviter", (ArgumentType)StringArgumentType.string()).executes(ctx -> PartyHudCommands.handleAccept((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"inviter")))))).then(Commands.m_82127_((String)"decline").then(Commands.m_82129_((String)"inviter", (ArgumentType)StringArgumentType.string()).executes(ctx -> PartyHudCommands.handleDecline((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"inviter")))))).then(Commands.m_82127_((String)"leave").executes(ctx -> PartyHudCommands.handleLeave((CommandSourceStack)ctx.getSource()))));
    }

    private static int handleAccept(CommandSourceStack source, String inviterUuidStr) {
        UUID inviterId;
        Entity entity = source.m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            return 0;
        }
        ServerPlayer invited = (ServerPlayer)entity;
        try {
            inviterId = UUID.fromString(inviterUuidStr);
        }
        catch (IllegalArgumentException e) {
            invited.m_213846_((Component)Component.m_237115_((String)"partyhud.chat.invalid_invite"));
            return 0;
        }
        UUID storedInviter = PartyHudServerData.consumeInvite(invited.m_20148_(), inviterId);
        if (storedInviter == null) {
            invited.m_213846_((Component)Component.m_237115_((String)"partyhud.chat.invite_expired"));
            return 0;
        }
        ServerPlayer inviter = invited.m_20194_().m_6846_().m_11259_(storedInviter);
        if (inviter == null) {
            invited.m_213846_((Component)Component.m_237115_((String)"partyhud.chat.inviter_offline"));
            return 0;
        }
        PartyHudServerData.createOrAddToParty(inviter, invited);
        inviter.m_213846_((Component)Component.m_237110_((String)"partyhud.chat.invite_accepted", (Object[])new Object[]{invited.m_7755_()}));
        invited.m_213846_((Component)Component.m_237110_((String)"partyhud.chat.joined_party", (Object[])new Object[]{inviter.m_7755_()}));
        return 1;
    }

    private static int handleDecline(CommandSourceStack source, String inviterUuidStr) {
        UUID inviterId;
        Entity entity = source.m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            return 0;
        }
        ServerPlayer invited = (ServerPlayer)entity;
        try {
            inviterId = UUID.fromString(inviterUuidStr);
        }
        catch (IllegalArgumentException e) {
            return 0;
        }
        PartyHudServerData.cancelInvitesTo(invited.m_20148_());
        ServerPlayer inviter = invited.m_20194_().m_6846_().m_11259_(inviterId);
        if (inviter != null) {
            inviter.m_213846_((Component)Component.m_237110_((String)"partyhud.chat.invite_declined", (Object[])new Object[]{invited.m_7755_()}));
        }
        invited.m_213846_((Component)Component.m_237115_((String)"partyhud.chat.you_declined"));
        return 1;
    }

    public static void forceLeave(ServerPlayer player) {
        Set<UUID> membersBefore = PartyHudServerData.getPartyOf(player);
        if (membersBefore.isEmpty()) {
            return;
        }
        PartyHudServerData.removeFromParty(player);
        PartyHudServerData.cancelInvitesTo(player.m_20148_());
        PartyHudServerData.cancelInvitesFrom(player.m_20148_());
    }

    private static int handleLeave(CommandSourceStack source) {
        Entity entity = source.m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        Set<UUID> membersBefore = PartyHudServerData.getPartyOf(player);
        if (membersBefore.isEmpty()) {
            player.m_213846_((Component)Component.m_237115_((String)"partyhud.chat.no_party"));
            return 1;
        }
        PartyHudCommands.forceLeave(player);
        player.m_213846_((Component)Component.m_237115_((String)"partyhud.chat.left_party"));
        return 1;
    }
}

