/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.server;

import com.everydayxp.partyhud.network.PartyHudNetwork;
import com.everydayxp.partyhud.network.PartyMemberPosSyncS2CPacket;
import com.everydayxp.partyhud.network.PlayerHealthSyncS2CPacket;
import com.everydayxp.partyhud.network.SyncFavoritesS2CPacket;
import com.everydayxp.partyhud.network.SyncPartyStateS2CPacket;
import com.everydayxp.partyhud.server.PartyFavoritesSavedData;
import com.everydayxp.partyhud.server.PartyHudServerData;
import com.everydayxp.partyhud.server.PartySavedData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="partyhud", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PartyHudServerEvents {
    private static int tickCounter = 0;
    private static final int SYNC_INTERVAL_TICKS = 10;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (++tickCounter < 10) {
            return;
        }
        tickCounter = 0;
        MinecraftServer server = event.getServer();
        if (server == null) {
            return;
        }
        for (ServerPlayer viewer : server.m_6846_().m_11314_()) {
            Set<UUID> uuidsToSync = PartyHudServerData.getPartyOf(viewer);
            if (uuidsToSync == null || uuidsToSync.isEmpty()) continue;
            ArrayList<PlayerHealthSyncS2CPacket.Entry> entries = new ArrayList<PlayerHealthSyncS2CPacket.Entry>();
            ArrayList<PartyMemberPosSyncS2CPacket.Entry> posEntries = new ArrayList<PartyMemberPosSyncS2CPacket.Entry>();
            for (UUID targetId : uuidsToSync) {
                ServerPlayer target = server.m_6846_().m_11259_(targetId);
                if (target == null) continue;
                float hp = target.m_21223_();
                float maxHp = target.m_21233_();
                float absorption = target.m_6103_();
                boolean poison = target.m_21023_(MobEffects.f_19614_);
                boolean regen = target.m_21023_(MobEffects.f_19605_);
                boolean wither = target.m_21023_(MobEffects.f_19615_);
                int frozen = target.m_146888_();
                int required = target.m_146891_();
                boolean freezing = frozen > 0 && frozen >= required / 4;
                entries.add(new PlayerHealthSyncS2CPacket.Entry(targetId, hp, maxHp, absorption, poison, regen, wither, freezing));
                posEntries.add(new PartyMemberPosSyncS2CPacket.Entry(targetId, target.m_9236_().m_46472_().m_135782_(), target.m_20185_(), target.m_20186_(), target.m_20189_()));
            }
            if (!entries.isEmpty()) {
                PartyHudNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> viewer), (Object)new PlayerHealthSyncS2CPacket(entries));
            }
            if (posEntries.isEmpty()) continue;
            PartyHudNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> viewer), (Object)new PartyMemberPosSyncS2CPacket(posEntries));
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PartyHudServerData.cancelInvitesTo(player2.m_20148_());
            PartyHudServerData.cancelInvitesFrom(player2.m_20148_());
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            Set<UUID> partyMembers = PartyHudServerData.getPartyOf(player2);
            if (!partyMembers.isEmpty()) {
                PartySavedData data = PartySavedData.get(player2.m_284548_());
                PartySavedData.PartyInfo info = data.getPartyByMember(player2.m_20148_());
                if (info != null) {
                    ArrayList<UUID> list = new ArrayList<UUID>(info.members);
                    HashMap<UUID, String> names = new HashMap<UUID, String>(info.names);
                    PartyHudNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new SyncPartyStateS2CPacket(info.partyId, info.leaderId, list, names));
                }
            } else {
                PartyHudNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new SyncPartyStateS2CPacket(null, null, List.of(), Map.of()));
            }
            PartyFavoritesSavedData favData = PartyFavoritesSavedData.get(player2.m_284548_());
            ArrayList<UUID> favList = new ArrayList<UUID>(favData.getFavorites(player2.m_20148_()));
            PartyHudNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new SyncFavoritesS2CPacket(favList));
        }
    }
}

