/*
 * Decompiled with CFR 0.152.
 */
package com.necromancer.client;

import com.necromancer.screen.RuneFusionScreenHandler;
import java.awt.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_465;

@Environment(value=EnvType.CLIENT)
public class RuneFusionScreen
extends class_465<RuneFusionScreenHandler> {
    private static final int BG_COLOR = -15398880;
    private static final int BORDER_COLOR = -5635841;
    private static final int BORDER_DARK = -11206520;
    private static final int SLOT_BG = -14019264;
    private static final int GLOW_COLOR = -2267393;
    private float animationTick = 0.0f;

    public RuneFusionScreen(RuneFusionScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_2792 = 176;
        this.field_2779 = 166;
    }

    protected void method_25426() {
        super.method_25426();
        this.field_25268 = 6;
        this.field_25270 = 73;
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        this.animationTick += delta;
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        this.drawAnimatedGlow(context, x, y);
        context.method_25294(x, y, x + this.field_2792, y + this.field_2779, -15398880);
        this.drawAnimatedBorder(context, x, y);
        for (int i = 0; i < 20; ++i) {
            int alpha = 255 - i * 10;
            int gradColor = alpha << 24 | 0x3A1050;
            context.method_25294(x + 2, y + 2 + i, x + this.field_2792 - 2, y + 3 + i, gradColor);
        }
        this.drawFusionArea(context, x, y);
        this.drawAnimatedSeparator(context, x + 4, y + 70, this.field_2792 - 8);
        this.drawInventorySlots(context, x, y);
        this.drawMagicalParticles(context, x, y);
    }

    private void drawAnimatedGlow(class_332 context, int x, int y) {
        float pulse = (float)(Math.sin((double)this.animationTick * 0.05) * 0.4 + 0.6);
        int glowAlpha = (int)(pulse * 60.0f);
        for (int i = 0; i < 5; ++i) {
            int offset = 5 + i * 2;
            int layerAlpha = glowAlpha - i * 10;
            if (layerAlpha <= 0) continue;
            int layerColor = layerAlpha << 24 | 0xAA00FF;
            context.method_25294(x - offset, y - offset, x + this.field_2792 + offset, y - offset + 2, layerColor);
            context.method_25294(x - offset, y + this.field_2779 + offset - 2, x + this.field_2792 + offset, y + this.field_2779 + offset, layerColor);
            context.method_25294(x - offset, y - offset, x - offset + 2, y + this.field_2779 + offset, layerColor);
            context.method_25294(x + this.field_2792 + offset - 2, y - offset, x + this.field_2792 + offset, y + this.field_2779 + offset, layerColor);
        }
    }

    private void drawAnimatedBorder(class_332 context, int x, int y) {
        float pulse = (float)(Math.sin((double)this.animationTick * 0.08) * 0.3 + 0.7);
        int r = (int)(170.0f * pulse);
        int g = 0;
        int b = (int)(255.0f * pulse);
        int animBorderColor = 0xFF000000 | r << 16 | g << 8 | b;
        context.method_25294(x, y, x + this.field_2792, y + 2, animBorderColor);
        context.method_25294(x, y + this.field_2779 - 2, x + this.field_2792, y + this.field_2779, animBorderColor);
        context.method_25294(x, y, x + 2, y + this.field_2779, animBorderColor);
        context.method_25294(x + this.field_2792 - 2, y, x + this.field_2792, y + this.field_2779, animBorderColor);
        int cornerColor = -2267393;
        context.method_25294(x, y, x + 6, y + 2, cornerColor);
        context.method_25294(x, y, x + 2, y + 6, cornerColor);
        context.method_25294(x + this.field_2792 - 6, y, x + this.field_2792, y + 2, cornerColor);
        context.method_25294(x + this.field_2792 - 2, y, x + this.field_2792, y + 6, cornerColor);
        context.method_25294(x, y + this.field_2779 - 2, x + 6, y + this.field_2779, cornerColor);
        context.method_25294(x, y + this.field_2779 - 6, x + 2, y + this.field_2779, cornerColor);
        context.method_25294(x + this.field_2792 - 6, y + this.field_2779 - 2, x + this.field_2792, y + this.field_2779, cornerColor);
        context.method_25294(x + this.field_2792 - 2, y + this.field_2779 - 6, x + this.field_2792, y + this.field_2779, cornerColor);
    }

    private void drawFusionArea(class_332 context, int x, int y) {
        this.drawGlowingSlot(context, x + 29, y + 34, -16733441, "WAND");
        int plusX = x + 52;
        int plusY = y + 40;
        context.method_25294(plusX, plusY + 3, plusX + 14, plusY + 5, -2267393);
        context.method_25294(plusX + 6, plusY - 1, plusX + 8, plusY + 9, -2267393);
        this.drawGlowingSlot(context, x + 69, y + 34, -65366, "RUNE");
        this.drawAnimatedArrow(context, x + 92, y + 40);
        this.drawOutputSlot(context, x + 129, y + 34);
    }

    private void drawGlowingSlot(class_332 context, int slotX, int slotY, int glowColor, String label) {
        float pulse = (float)(Math.sin((double)this.animationTick * 0.1) * 0.3 + 0.7);
        int glowAlpha = (int)(pulse * 80.0f);
        int glow = glowAlpha << 24 | glowColor & 0xFFFFFF;
        context.method_25294(slotX - 3, slotY - 3, slotX + 21, slotY + 21, glow);
        context.method_25294(slotX - 1, slotY - 1, slotX + 19, slotY + 19, -5635841);
        context.method_25294(slotX, slotY, slotX + 18, slotY + 18, -14019264);
        context.method_25294(slotX + 1, slotY + 1, slotX + 17, slotY + 2, -12967840);
        context.method_25294(slotX + 1, slotY + 1, slotX + 2, slotY + 17, -12967840);
    }

    private void drawOutputSlot(class_332 context, int slotX, int slotY) {
        boolean hasOutput = !((RuneFusionScreenHandler)this.field_2797).method_7611(2).method_7677().method_7960();
        float pulse = (float)(Math.sin((double)this.animationTick * 0.15) * 0.5 + 0.5);
        if (hasOutput) {
            int hue = (int)(this.animationTick * 3.0f) % 360;
            int rgb = Color.HSBtoRGB((float)hue / 360.0f, 0.8f, 1.0f);
            int glowAlpha = (int)(pulse * 120.0f) + 50;
            for (int i = 0; i < 4; ++i) {
                int layerAlpha = glowAlpha - i * 25;
                if (layerAlpha <= 0) continue;
                int layerGlow = layerAlpha << 24 | rgb & 0xFFFFFF;
                context.method_25294(slotX - 3 - i, slotY - 3 - i, slotX + 21 + i, slotY + 21 + i, layerGlow);
            }
        } else {
            int glowAlpha = (int)(pulse * 40.0f);
            int glow = glowAlpha << 24 | 0x888888;
            context.method_25294(slotX - 3, slotY - 3, slotX + 21, slotY + 21, glow);
        }
        int frameColor = hasOutput ? -22016 : -11206520;
        context.method_25294(slotX - 1, slotY - 1, slotX + 19, slotY + 19, frameColor);
        context.method_25294(slotX, slotY, slotX + 18, slotY + 18, -14019264);
    }

    private void drawAnimatedArrow(class_332 context, int x, int y) {
        int i;
        float pulse = (float)(Math.sin((double)this.animationTick * 0.1) * 0.3 + 0.7);
        int alpha = (int)(pulse * 255.0f);
        int arrowColor = alpha << 24 | 0xAA00FF;
        int offset = (int)(Math.sin((double)this.animationTick * 0.2) * 2.0);
        context.method_25294(x + offset, y + 2, x + 20 + offset, y + 6, arrowColor);
        for (i = 0; i < 5; ++i) {
            context.method_25294(x + 20 + i + offset, y + 2 - i, x + 21 + i + offset, y + 6 + i, arrowColor);
        }
        for (i = 0; i < 4; ++i) {
            double progress = ((double)this.animationTick * 0.1 + (double)i * 0.25) % 1.0;
            int px = x + (int)(progress * 25.0);
            int py = y + 4 + (int)(Math.sin(progress * Math.PI * 2.0) * 3.0);
            int particleAlpha = (int)((1.0 - Math.abs(progress - 0.5) * 2.0) * 200.0);
            int particleColor = particleAlpha << 24 | 0xFFAAFF;
            context.method_25294(px - 1, py - 1, px + 2, py + 2, particleColor);
        }
    }

    private void drawAnimatedSeparator(class_332 context, int x, int y, int width) {
        for (int i = 0; i < width; ++i) {
            float progress = (float)i / (float)width;
            float wave = (float)Math.sin((double)progress * Math.PI * 4.0 + (double)this.animationTick * 0.1);
            int alpha = (int)(100.0f + wave * 50.0f);
            int color = alpha << 24 | 0xAA00FF;
            context.method_25294(x + i, y, x + i + 1, y + 1, color);
        }
    }

    private void drawInventorySlots(class_332 context, int x, int y) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int slotX = x + 7 + col * 18;
                int slotY = y + 83 + row * 18;
                this.drawInventorySlot(context, slotX, slotY);
            }
        }
        for (int col = 0; col < 9; ++col) {
            int slotX = x + 7 + col * 18;
            int slotY = y + 141;
            this.drawInventorySlot(context, slotX, slotY);
        }
    }

    private void drawInventorySlot(class_332 context, int slotX, int slotY) {
        context.method_25294(slotX, slotY, slotX + 18, slotY + 18, -11206520);
        context.method_25294(slotX + 1, slotY + 1, slotX + 17, slotY + 17, -15070683);
    }

    private void drawMagicalParticles(class_332 context, int x, int y) {
        for (int i = 0; i < 12; ++i) {
            double time = ((double)this.animationTick * 0.03 + (double)i * 0.083) % 1.0;
            int px = x + 30 + (int)(time * 110.0);
            int py = y + 25 + (int)(Math.sin(time * Math.PI * 3.0 + (double)i) * 15.0);
            float pulse = (float)(Math.sin((double)this.animationTick * 0.2 + (double)i) * 0.5 + 0.5);
            int alpha = (int)(pulse * 150.0f);
            int[] colors = new int[]{0xFF00FF, 0xAA00FF, 0xFF00AA, 43775};
            int color = alpha << 24 | colors[i % 4];
            context.method_25294(px, py, px + 2, py + 2, color);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        float pulse = (float)(Math.sin((double)this.animationTick * 0.08) * 0.2 + 0.8);
        int r = (int)(221.0f * pulse);
        int g = (int)(102.0f * pulse);
        int b = 255;
        int titleColor = 0xFF000000 | r << 16 | g << 8 | b;
        String title = "\u2726 Rune Fusion \u2726";
        int titleWidth = this.field_22793.method_1727(title);
        context.method_25303(this.field_22793, title, (this.field_2792 - titleWidth) / 2, 6, titleColor);
        context.method_51439(this.field_22793, this.field_29347, 8, 73, -5592406, false);
    }
}

