/*
 * Decompiled with CFR 0.152.
 */
package com.necromancer.entity;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1613;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_8111;

public class SummonedSkeletonEntity
extends class_1613 {
    private static final class_2940<Optional<UUID>> OWNER_UUID = class_2945.method_12791(SummonedSkeletonEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Boolean> ARMORED_VARIANT = class_2945.method_12791(SummonedSkeletonEntity.class, (class_2941)class_2943.field_13323);

    public SummonedSkeletonEntity(class_1299<? extends class_1613> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(OWNER_UUID, Optional.empty());
        this.field_6011.method_12784(ARMORED_VARIANT, (Object)false);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1366((class_1314)this, 1.2, false));
        this.field_6201.method_6277(3, (class_1352)new FollowOwnerGoal(this));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1379((class_1314)this, 1.0));
        this.field_6185.method_6277(1, (class_1352)new TrackOwnerAttackerGoal(this));
        this.field_6185.method_6277(2, (class_1352)new AttackWithOwnerGoal(this));
        this.field_6185.method_6277(3, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1588.class, true, entity -> !(entity instanceof SummonedSkeletonEntity)));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1613.method_26905().method_26868(class_5134.field_23716, 25.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23717, 35.0);
    }

    public void setOwner(class_1657 player) {
        this.field_6011.method_12778(OWNER_UUID, Optional.of(player.method_5667()));
    }

    public UUID getOwnerUuid() {
        return ((Optional)this.field_6011.method_12789(OWNER_UUID)).orElse(null);
    }

    public class_1657 getOwner() {
        UUID uuid = this.getOwnerUuid();
        if (uuid == null) {
            return null;
        }
        if (this.method_37908() instanceof class_3218) {
            class_3218 serverWorld = (class_3218)this.method_37908();
            return serverWorld.method_8503().method_3760().method_14602(uuid);
        }
        return null;
    }

    public void setArmoredVariant(boolean armored) {
        this.field_6011.method_12778(ARMORED_VARIANT, (Object)armored);
    }

    public boolean isArmoredVariant() {
        return (Boolean)this.field_6011.method_12789(ARMORED_VARIANT);
    }

    public boolean isOwner(class_1309 entity) {
        return entity instanceof class_1657 && entity.method_5667().equals(this.getOwnerUuid());
    }

    public boolean method_18395(class_1309 target) {
        if (this.isOwner(target)) {
            return false;
        }
        if (target instanceof SummonedSkeletonEntity) {
            SummonedSkeletonEntity other = (SummonedSkeletonEntity)target;
            UUID myOwner = this.getOwnerUuid();
            UUID theirOwner = other.getOwnerUuid();
            if (myOwner != null && myOwner.equals(theirOwner)) {
                return false;
            }
        }
        return super.method_18395(target);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_5529() instanceof class_1309 && this.isOwner((class_1309)source.method_5529())) {
            return false;
        }
        if (source.method_49708(class_8111.field_42345)) {
            return false;
        }
        if (this.isArmoredVariant() && (source.method_49708(class_8111.field_42321) || source.method_49708(class_8111.field_42323))) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    public void explode() {
        if (this.method_37908() instanceof class_3218) {
            double z;
            double y;
            double x;
            int i;
            class_3218 serverWorld = (class_3218)this.method_37908();
            this.method_37908().method_8390(class_1309.class, this.method_5829().method_1014(7.0), entity -> this.method_18395((class_1309)entity)).forEach(entity -> entity.method_5643(this.method_48923().method_48819((class_1297)this, (class_1297)this.getOwner()), 25.0f));
            for (i = 0; i < 80; ++i) {
                x = this.method_23317() + (this.field_5974.method_43058() - 0.5) * 5.0;
                y = this.method_23318() + this.field_5974.method_43058() * 3.0;
                z = this.method_23321() + (this.field_5974.method_43058() - 0.5) * 5.0;
                serverWorld.method_14199((class_2394)class_2398.field_23114, x, y, z, 2, 0.0, 0.0, 0.0, 0.15);
                serverWorld.method_14199((class_2394)class_2398.field_22246, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
            }
            for (i = 0; i < 40; ++i) {
                x = this.method_23317() + (this.field_5974.method_43058() - 0.5) * 4.0;
                y = this.method_23318() + this.field_5974.method_43058() * 2.5;
                z = this.method_23321() + (this.field_5974.method_43058() - 0.5) * 4.0;
                serverWorld.method_14199((class_2394)class_2398.field_11251, x, y, z, 1, 0.0, 0.0, 0.0, 0.08);
                serverWorld.method_14199((class_2394)class_2398.field_11237, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            this.method_31472();
        }
    }

    protected boolean method_27071() {
        return false;
    }

    public boolean method_5822() {
        return false;
    }

    protected boolean method_5972() {
        return false;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.getOwnerUuid() != null) {
            nbt.method_25927("Owner", this.getOwnerUuid());
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_25928("Owner")) {
            this.field_6011.method_12778(OWNER_UUID, Optional.of(nbt.method_25926("Owner")));
        }
    }

    private class FollowOwnerGoal
    extends class_1352 {
        private final SummonedSkeletonEntity skeleton;
        private class_1657 owner;
        private final double speed = 1.0;
        private int updateCountdown;

        public FollowOwnerGoal(SummonedSkeletonEntity skeleton) {
            this.skeleton = skeleton;
        }

        public boolean method_6264() {
            class_1657 owner = this.skeleton.getOwner();
            if (owner == null) {
                return false;
            }
            if (this.skeleton.method_5858((class_1297)owner) < 16.0) {
                return false;
            }
            this.owner = owner;
            return true;
        }

        public boolean method_6266() {
            if (this.skeleton.method_5942().method_6357()) {
                return false;
            }
            return this.skeleton.method_5858((class_1297)this.owner) > 16.0;
        }

        public void method_6269() {
            this.updateCountdown = 0;
        }

        public void method_6270() {
            this.owner = null;
            this.skeleton.method_5942().method_6340();
        }

        public void method_6268() {
            this.skeleton.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)this.skeleton.method_5978());
            if (--this.updateCountdown <= 0) {
                this.updateCountdown = 10;
                if (!this.skeleton.method_5934() && !this.skeleton.method_5765()) {
                    if (this.skeleton.method_5858((class_1297)this.owner) >= 100.0) {
                        this.skeleton.method_20620(this.owner.method_23317(), this.owner.method_23318(), this.owner.method_23321());
                    } else {
                        this.skeleton.method_5942().method_6335((class_1297)this.owner, this.speed);
                    }
                }
            }
        }
    }

    private class TrackOwnerAttackerGoal
    extends class_1352 {
        private final SummonedSkeletonEntity skeleton;
        private class_1309 attacker;
        private int timestamp;

        public TrackOwnerAttackerGoal(SummonedSkeletonEntity skeleton) {
            this.skeleton = skeleton;
        }

        public boolean method_6264() {
            class_1657 owner = this.skeleton.getOwner();
            if (owner == null) {
                return false;
            }
            this.attacker = owner.method_6065();
            int i = owner.method_6117();
            return i != this.timestamp && this.attacker != null && this.skeleton.method_18395(this.attacker);
        }

        public void method_6269() {
            this.skeleton.method_5980(this.attacker);
            class_1657 owner = this.skeleton.getOwner();
            if (owner != null) {
                this.timestamp = owner.method_6117();
            }
            super.method_6269();
        }
    }

    private class AttackWithOwnerGoal
    extends class_1352 {
        private final SummonedSkeletonEntity skeleton;
        private class_1309 target;
        private int timestamp;

        public AttackWithOwnerGoal(SummonedSkeletonEntity skeleton) {
            this.skeleton = skeleton;
        }

        public boolean method_6264() {
            class_1657 owner = this.skeleton.getOwner();
            if (owner == null) {
                return false;
            }
            this.target = owner.method_6052();
            int i = owner.method_6083();
            return i != this.timestamp && this.target != null && this.skeleton.method_18395(this.target);
        }

        public void method_6269() {
            this.skeleton.method_5980(this.target);
            class_1657 owner = this.skeleton.getOwner();
            if (owner != null) {
                this.timestamp = owner.method_6083();
            }
            super.method_6269();
        }
    }
}

