/*
 * Decompiled with CFR 0.152.
 */
package com.necromancer.event;

import com.necromancer.data.NecromancerPlayerData;
import com.necromancer.item.FrostWandItem;
import com.necromancer.item.GravityMasterItem;
import com.necromancer.item.ModItems;
import com.necromancer.item.NecromancerStaffItem;
import com.necromancer.item.PetalWandItem;
import com.necromancer.item.VenomWandItem;
import com.necromancer.item.WebWandItem;
import com.necromancer.item.WitherWandItem;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;

public class AbilityTickHandler {
    private static int tickCounter = 0;

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            ++tickCounter;
            for (class_3222 player : server.method_3760().method_14571()) {
                class_1799 petalWand;
                class_3218 world;
                class_1799 gravityWand;
                class_1799 venomWand;
                class_1799 webWandStack;
                class_3218 world2;
                boolean hasStaff;
                NecromancerPlayerData data = NecromancerPlayerData.get((class_1657)player);
                class_1799 staff = AbilityTickHandler.getHeldStaff(player);
                boolean bl = hasStaff = staff != null;
                if (data.flightEnabled) {
                    if (!hasStaff) {
                        data.flightEnabled = false;
                        player.method_31549().field_7478 = false;
                        player.method_31549().field_7479 = false;
                        player.method_7355();
                        player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cFlight disabled - staff not held!"), true);
                    } else if (tickCounter % 140 == 0 && !NecromancerStaffItem.removeSouls(staff, 1)) {
                        data.flightEnabled = false;
                        player.method_31549().field_7478 = false;
                        player.method_31549().field_7479 = false;
                        player.method_7355();
                        player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cOut of souls! Flight disabled."), true);
                    }
                }
                if (data.soulSightEnabled && hasStaff && tickCounter % 10 == 0) {
                    world2 = player.method_51469();
                    List nearbyHostiles = world2.method_8390(class_1588.class, player.method_5829().method_1014(30.0), entity -> true);
                    for (Object hostile : nearbyHostiles) {
                        hostile.method_6092(new class_1293(class_1294.field_5912, 25, 0, false, false, false));
                    }
                }
                if (data.lifeDrainEnabled && hasStaff && tickCounter % 20 == 0) {
                    Object hostile;
                    if (!NecromancerStaffItem.removeSouls(staff, 1)) {
                        data.lifeDrainEnabled = false;
                        player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cOut of souls! Life Drain disabled."), true);
                        continue;
                    }
                    world2 = player.method_51469();
                    List nearbyEnemies = world2.method_8390(class_1309.class, player.method_5829().method_1014(10.0), entity -> entity instanceof class_1588 && entity.method_5805());
                    float totalDrained = 0.0f;
                    hostile = nearbyEnemies.iterator();
                    while (hostile.hasNext()) {
                        class_1309 enemy = (class_1309)hostile.next();
                        float damage = 3.0f;
                        enemy.method_5643(player.method_37908().method_48963().method_48815((class_1297)player, (class_1297)player), damage);
                        totalDrained += damage;
                    }
                    if (totalDrained > 0.0f) {
                        player.method_6025(totalDrained / 2.0f);
                    }
                }
                if ((webWandStack = AbilityTickHandler.getWebWand(player)) != null) {
                    class_2338 playerPos = player.method_24515();
                    if (player.method_37908().method_8320(playerPos).method_26204() == class_2246.field_10343) {
                        player.method_6092(new class_1293(class_1294.field_5904, 40, 3, false, false, false));
                    }
                    if (WebWandItem.isClimbingEnabled(webWandStack) && AbilityTickHandler.isTouchingSolidBlock(player)) {
                        if (!player.method_5715()) {
                            player.method_6092(new class_1293(class_1294.field_5902, 20, 1, false, false, false));
                        } else {
                            player.method_6092(new class_1293(class_1294.field_5906, 20, 0, false, false, false));
                        }
                        player.field_6017 = 0.0f;
                    }
                }
                if (AbilityTickHandler.isHoldingBubbleWand(player) && player.method_5869()) {
                    player.method_5855(player.method_5748());
                }
                if ((venomWand = AbilityTickHandler.getVenomWand(player)) != null) {
                    if (player.method_6059(class_1294.field_5899)) {
                        player.method_6016(class_1294.field_5899);
                    }
                    if (VenomWandItem.isToxicSkinEnabled(venomWand)) {
                        class_1309 attacker = player.method_6065();
                        if (player.field_6235 > 0 && attacker != null) {
                            attacker.method_6092(new class_1293(class_1294.field_5899, 100, 1));
                        }
                    }
                }
                if (AbilityTickHandler.isHoldingVampireScepter(player)) {
                    boolean isDark;
                    class_3218 world3 = player.method_51469();
                    boolean bl2 = isDark = world3.method_8314(class_1944.field_9284, player.method_24515()) < 7 || !world3.method_8530();
                    if (isDark) {
                        player.method_6092(new class_1293(class_1294.field_5910, 40, 0, false, false, true));
                        if (tickCounter % 60 == 0) {
                            player.method_6025(1.0f);
                        }
                    }
                }
                if (AbilityTickHandler.isHoldingLightWand(player)) {
                    player.method_6092(new class_1293(class_1294.field_5925, 400, 0, false, false, true));
                }
                if (AbilityTickHandler.isHoldingWitherWand(player)) {
                    class_2338 below = player.method_24515().method_10074();
                    if (player.method_37908().method_8320(below).method_27852(class_2246.field_10114) || player.method_37908().method_8320(below).method_27852(class_2246.field_22090)) {
                        player.method_6092(new class_1293(class_1294.field_5910, 40, 3, false, false, true));
                    }
                }
                if ((gravityWand = AbilityTickHandler.getGravityMasterFromInventory(player)) != null) {
                    AbilityTickHandler.handleGravityMasterAbilities(player, gravityWand);
                } else {
                    class_1324 kbRes = player.method_5996(class_5134.field_23718);
                    if (kbRes != null && kbRes.method_6201() >= 1.0) {
                        kbRes.method_6192(0.0);
                    }
                }
                if (AbilityTickHandler.isHoldingFrostWand(player)) {
                    class_2338 playerPos = player.method_24515();
                    world = player.method_51469();
                    for (int dx = -1; dx <= 1; ++dx) {
                        for (int dz = -1; dz <= 1; ++dz) {
                            class_2338 checkPos = playerPos.method_10069(dx, -1, dz);
                            if (!world.method_8320(checkPos).method_27852(class_2246.field_10382)) continue;
                            world.method_8501(checkPos, class_2246.field_10110.method_9564());
                            world.method_39279(checkPos, class_2246.field_10110, 60 + world.field_9229.method_43048(40));
                        }
                    }
                }
                if ((petalWand = AbilityTickHandler.getPetalWandFromHands(player)) == null) continue;
                world = player.method_51469();
                if (PetalWandItem.isFlowerTrailActive(petalWand)) {
                    long endTime = PetalWandItem.getFlowerTrailEndTime(petalWand);
                    if (world.method_8510() < endTime) {
                        class_2338 belowPlayer = player.method_24515().method_10074();
                        class_2338 flowerPos = player.method_24515();
                        if (world.method_8320(belowPlayer).method_26212((class_1922)world, belowPlayer) && world.method_8320(flowerPos).method_26215()) {
                            class_2248[] flowers = new class_2248[]{class_2246.field_10182, class_2246.field_10449, class_2246.field_10086, class_2246.field_10226, class_2246.field_10573, class_2246.field_10270, class_2246.field_10048};
                            class_2248 flower = flowers[world.field_9229.method_43048(flowers.length)];
                            world.method_8501(flowerPos, flower.method_9564());
                        }
                    }
                }
                if (tickCounter % 20 != 0) continue;
                List animals = world.method_8390(class_1429.class, player.method_5829().method_1014(50.0), animal -> !animal.method_6109());
                for (class_1429 animal2 : animals) {
                    if (!(animal2.method_5739((class_1297)player) > 4.0f)) continue;
                    animal2.method_5942().method_6335((class_1297)player, 1.25);
                }
            }
            if (tickCounter >= 1400) {
                tickCounter = 0;
            }
        });
    }

    private static void handleGravityMasterAbilities(class_3222 player, class_1799 gravityWand) {
        player.method_6092(new class_1293(class_1294.field_5913, 40, 4, false, false, true));
        if (GravityMasterItem.isSlowFallingEnabled(gravityWand)) {
            player.method_6092(new class_1293(class_1294.field_5906, 40, 0, false, false, true));
        }
        player.field_6017 = 0.0f;
        List loot = player.method_37908().method_8333((class_1297)player, player.method_5829().method_1014(30.0), e -> e instanceof class_1542 || e instanceof class_1303);
        for (class_1297 e2 : loot) {
            class_243 dir = player.method_19538().method_1031(0.0, 1.0, 0.0).method_1020(e2.method_19538()).method_1029();
            e2.method_18799(dir.method_1021(0.4));
            e2.field_6037 = true;
        }
        class_1324 kbRes = player.method_5996(class_5134.field_23718);
        if (kbRes != null) {
            boolean wantAnchor = GravityMasterItem.isGravAnchor(gravityWand);
            kbRes.method_6192(wantAnchor ? 1.0 : 0.0);
        }
        if (GravityMasterItem.isOrbitActive(gravityWand)) {
            class_1937 class_19372;
            int stones = GravityMasterItem.getOrbitStones(gravityWand);
            if (stones > 0 && (class_19372 = player.method_37908()) instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                double time = (double)player.method_37908().method_8510() * 0.1;
                for (int i = 0; i < stones; ++i) {
                    double angle = time + (double)i * (Math.PI * 2 / (double)stones);
                    double x = player.method_23317() + Math.cos(angle) * 1.5;
                    double z = player.method_23321() + Math.sin(angle) * 1.5;
                    serverWorld.method_14199((class_2394)class_2398.field_11207, x, player.method_23318() + 1.0, z, 1, 0.0, 0.0, 0.0, 0.0);
                }
            } else {
                GravityMasterItem.setOrbitActive(gravityWand, false);
            }
        }
    }

    private static class_1799 getHeldStaff(class_3222 player) {
        if (player.method_6047().method_31574((class_1792)ModItems.NECROMANCER_STAFF)) {
            return player.method_6047();
        }
        if (player.method_6079().method_31574((class_1792)ModItems.NECROMANCER_STAFF)) {
            return player.method_6079();
        }
        return null;
    }

    private static boolean isHoldingBubbleWand(class_3222 player) {
        return player.method_6047().method_31574((class_1792)ModItems.BUBBLE_WAND) || player.method_6079().method_31574((class_1792)ModItems.BUBBLE_WAND);
    }

    private static class_1799 getVenomWand(class_3222 player) {
        if (player.method_6047().method_31574((class_1792)ModItems.VENOM_WAND)) {
            return player.method_6047();
        }
        if (player.method_6079().method_31574((class_1792)ModItems.VENOM_WAND)) {
            return player.method_6079();
        }
        return null;
    }

    private static boolean isHoldingVampireScepter(class_3222 player) {
        return player.method_6047().method_31574((class_1792)ModItems.VAMPIRE_SCEPTER) || player.method_6079().method_31574((class_1792)ModItems.VAMPIRE_SCEPTER);
    }

    private static boolean isHoldingLightWand(class_3222 player) {
        return player.method_6047().method_31574((class_1792)ModItems.LIGHT_WAND) || player.method_6079().method_31574((class_1792)ModItems.LIGHT_WAND);
    }

    private static boolean isHoldingWitherWand(class_3222 player) {
        return player.method_6047().method_7909() instanceof WitherWandItem || player.method_6079().method_7909() instanceof WitherWandItem;
    }

    private static class_1799 getGravityMasterFromInventory(class_3222 player) {
        if (player.method_6047().method_7909() instanceof GravityMasterItem) {
            return player.method_6047();
        }
        if (player.method_6079().method_7909() instanceof GravityMasterItem) {
            return player.method_6079();
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (!(stack.method_7909() instanceof GravityMasterItem)) continue;
            return stack;
        }
        return null;
    }

    private static boolean isTouchingSolidBlock(class_3222 player) {
        class_2338[] directions;
        class_2338 pos = player.method_24515();
        class_3218 world = player.method_51469();
        for (class_2338 checkPos : directions = new class_2338[]{pos.method_10095(), pos.method_10072(), pos.method_10078(), pos.method_10067()}) {
            if (!world.method_8320(checkPos).method_26212((class_1922)world, checkPos) && !world.method_8320(checkPos.method_10084()).method_26212((class_1922)world, checkPos.method_10084())) continue;
            return true;
        }
        return false;
    }

    private static boolean isHoldingFrostWand(class_3222 player) {
        return player.method_6047().method_7909() instanceof FrostWandItem || player.method_6079().method_7909() instanceof FrostWandItem;
    }

    private static class_1799 getPetalWandFromHands(class_3222 player) {
        if (player.method_6047().method_7909() instanceof PetalWandItem) {
            return player.method_6047();
        }
        if (player.method_6079().method_7909() instanceof PetalWandItem) {
            return player.method_6079();
        }
        return null;
    }

    private static class_1799 getWebWand(class_3222 player) {
        if (player.method_6047().method_7909() instanceof WebWandItem) {
            return player.method_6047();
        }
        if (player.method_6079().method_7909() instanceof WebWandItem) {
            return player.method_6079();
        }
        return null;
    }
}

