/*
 * Decompiled with CFR 0.152.
 */
package com.necromancer.event;

import com.necromancer.item.RuneItems;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_219;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_77;
import net.minecraft.class_79;

public class RuneLootHandler {
    private static final Set<class_2960> FIRE_MOBS = Set.of(class_1299.field_6099.method_16351(), class_1299.field_6102.method_16351(), class_1299.field_6107.method_16351(), class_1299.field_6076.method_16351(), class_1299.field_23214.method_16351(), class_1299.field_6050.method_16351());
    private static final Set<class_2960> COLD_MOBS = Set.of(class_1299.field_6098.method_16351(), class_1299.field_6123.method_16351(), class_1299.field_6047.method_16351(), class_1299.field_6042.method_16351(), class_1299.field_30052.method_16351());
    private static final Set<class_2960> VAMPIRE_MOBS = Set.of(class_1299.field_6145.method_16351(), class_1299.field_6090.method_16351(), class_1299.field_6117.method_16351(), class_1299.field_6059.method_16351(), class_1299.field_6054.method_16351(), class_1299.field_6108.method_16351(), class_1299.field_6077.method_16351(), class_1299.field_17713.method_16351());
    private static final Set<class_2960> SWIFTNESS_MOBS = Set.of(class_1299.field_6091.method_16351(), class_1299.field_6078.method_16351(), class_1299.field_6079.method_16351(), class_1299.field_6084.method_16351(), class_1299.field_6125.method_16351(), class_1299.field_6139.method_16351(), class_1299.field_6081.method_16351(), class_1299.field_16281.method_16351(), class_1299.field_6140.method_16351(), class_1299.field_38384.method_16351());

    public static void register() {
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> {
            if (FIRE_MOBS.contains(id)) {
                RuneLootHandler.addRandomShardPool(tableBuilder, RuneLootHandler.getFireShards());
            } else if (COLD_MOBS.contains(id)) {
                RuneLootHandler.addRandomShardPool(tableBuilder, RuneLootHandler.getColdShards());
            } else if (VAMPIRE_MOBS.contains(id)) {
                RuneLootHandler.addRandomShardPool(tableBuilder, RuneLootHandler.getVampireShards());
            } else if (SWIFTNESS_MOBS.contains(id)) {
                RuneLootHandler.addRandomShardPool(tableBuilder, RuneLootHandler.getSwiftnessShards());
            }
        });
    }

    private static void addRandomShardPool(class_52.class_53 tableBuilder, List<class_1792> shards) {
        class_55.class_56 poolBuilder = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_356(class_219.method_932((float)0.2f));
        for (class_1792 shard : shards) {
            poolBuilder.method_351((class_79.class_80)class_77.method_411((class_1935)shard).method_437(1));
        }
        tableBuilder.method_336(poolBuilder);
    }

    private static List<class_1792> getFireShards() {
        return Arrays.asList(RuneItems.MAGMA_SHARD_1, RuneItems.MAGMA_SHARD_2, RuneItems.MAGMA_SHARD_3, RuneItems.MAGMA_SHARD_4, RuneItems.INFERNO_SHARD_1, RuneItems.INFERNO_SHARD_2, RuneItems.INFERNO_SHARD_3, RuneItems.INFERNO_SHARD_4);
    }

    private static List<class_1792> getColdShards() {
        return Arrays.asList(RuneItems.FROST_SHARD_1, RuneItems.FROST_SHARD_2, RuneItems.FROST_SHARD_3, RuneItems.FROST_SHARD_4, RuneItems.GLACIAL_SHARD_1, RuneItems.GLACIAL_SHARD_2, RuneItems.GLACIAL_SHARD_3, RuneItems.GLACIAL_SHARD_4);
    }

    private static List<class_1792> getVampireShards() {
        return Arrays.asList(RuneItems.BLOOD_SHARD_1, RuneItems.BLOOD_SHARD_2, RuneItems.BLOOD_SHARD_3, RuneItems.BLOOD_SHARD_4, RuneItems.VITALITY_SHARD_1, RuneItems.VITALITY_SHARD_2, RuneItems.VITALITY_SHARD_3, RuneItems.VITALITY_SHARD_4, RuneItems.SIPHON_SHARD_1, RuneItems.SIPHON_SHARD_2, RuneItems.SIPHON_SHARD_3, RuneItems.SIPHON_SHARD_4);
    }

    private static List<class_1792> getSwiftnessShards() {
        return Arrays.asList(RuneItems.ZEPHYR_SHARD_1, RuneItems.ZEPHYR_SHARD_2, RuneItems.ZEPHYR_SHARD_3, RuneItems.ZEPHYR_SHARD_4, RuneItems.VELOCITY_SHARD_1, RuneItems.VELOCITY_SHARD_2, RuneItems.VELOCITY_SHARD_3, RuneItems.VELOCITY_SHARD_4, RuneItems.TEMPO_SHARD_1, RuneItems.TEMPO_SHARD_2, RuneItems.TEMPO_SHARD_3, RuneItems.TEMPO_SHARD_4);
    }
}

